/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.lib.pdf.PDFFileImage;
import com.caucho.quercus.lib.pdf.PDFFont;
import com.caucho.quercus.lib.pdf.PDFImage;
import com.caucho.quercus.lib.pdf.PDFProcSet;
import com.caucho.quercus.lib.pdf.PDFWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;

public class PDFStream {
    private static final Logger log = Logger.getLogger(PDFStream.class.getName());
    private static final L10N L = new L10N(PDFStream.class);
    private int _id;
    private TempStream _tempStream = new TempStream();
    private WriteStream _out = new WriteStream();
    private PDFProcSet _procSet;
    private PDFFont _font;
    private double _fontSize = 24.0;
    private boolean _inText;
    private boolean _hasFont;
    private boolean _hasTextPos = true;
    private double _textX = 0.0;
    private double _textY = 0.0;
    private double _x = -1.0;
    private double _y = -1.0;
    private boolean _hasGraphicsPos = true;
    public static int STROKE = 1;
    public static int FILL = 2;
    public static int BOTH = 3;

    PDFStream(int id) {
        this._id = id;
        this._tempStream = new TempStream();
        this._tempStream.openWrite();
        this._out.init(this._tempStream);
        this._procSet = new PDFProcSet();
        this._procSet.add("/PDF");
        this._font = null;
        this._inText = false;
        this._hasFont = false;
        this._hasTextPos = true;
        this._hasGraphicsPos = true;
    }

    public int getId() {
        return this._id;
    }

    public void setFont(PDFFont font, double size) {
        this._font = font;
        this._fontSize = size;
        this._hasFont = false;
    }

    public PDFFont getFont() {
        return this._font;
    }

    public double getFontSize() {
        return this._fontSize;
    }

    public void setTextPos(double x, double y) {
        if (this._hasTextPos) {
            this.flushToGraph();
        }
        this._textX = x;
        this._textY = y;
        this._hasTextPos = false;
    }

    public void stroke() {
        this.flushToGraph();
        this.println("S");
    }

    public void closepath() {
        this.flushToGraph();
        this.println("h");
    }

    public void clip() {
        this.flushToGraph();
        this.println("W");
    }

    public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.flushToGraph();
        if (x1 == x2 && y1 == y2) {
            this.println(String.format(Locale.US, "%1.2f %1.2f %1.2f %1.2f y", x1, y1, x3, y3));
        } else if (x2 == x3 && y2 == y3) {
            this.println(String.format(Locale.US, "%1.2f %1.2f %1.2f %1.2f v", x1, y1, x2, y2));
        } else {
            this.println(String.format(Locale.US, "%1.2f %1.2f %1.2f %1.2f %1.2f %1.2f c", x1, y1, x2, y2, x3, y3));
        }
        this._x = x3;
        this._y = y3;
        this._hasGraphicsPos = true;
    }

    public void endpath() {
        this.flushToGraph();
        this.println("n");
    }

    public void closepathStroke() {
        this.flushToGraph();
        this.println("s");
    }

    public void closepathFillStroke() {
        this.flushToGraph();
        this.println("b");
    }

    public void fill() {
        this.flushToGraph();
        this.println("f");
    }

    public void fillStroke() {
        this.flushToGraph();
        this.println("B");
    }

    public void lineTo(double x, double y) {
        this.flushToGraph();
        if (x != this._x || y != this._y || !this._hasGraphicsPos) {
            this.println(String.format(Locale.US, "%1.2f %1.2f l", x, y));
        }
        this._x = x;
        this._y = y;
        this._hasGraphicsPos = true;
    }

    public void rect(double x, double y, double w, double h) {
        this.flushToGraph();
        this.println(String.format(Locale.US, "%1.2f %1.2f %1.2f %1.2f re", x, y, w, h));
    }

    public void moveTo(double x, double y) {
        this._x = x;
        this._y = y;
        this._hasGraphicsPos = false;
    }

    public boolean setcolor(String fstype, String colorspace, double c1, double c2, double c3, double c4) {
        int type;
        this.flushToGraph();
        if ("both".equals(fstype) || "fillstroke".equals(fstype)) {
            type = BOTH;
        } else if ("fill".equals(fstype)) {
            type = FILL;
        } else if ("stroke".equals(fstype)) {
            type = STROKE;
        } else {
            return false;
        }
        if ("gray".equals(colorspace)) {
            if ((type & STROKE) != 0) {
                this.println(String.format(Locale.US, "%1.4f G", c1));
            }
            if ((type & FILL) != 0) {
                this.println(String.format(Locale.US, "%1.4f g", c1));
            }
            return true;
        }
        if ("rgb".equals(colorspace)) {
            if ((type & STROKE) != 0) {
                this.println(String.format(Locale.US, "%1.4f %1.4f %1.4f RG", c1, c2, c3));
            }
            if ((type & FILL) != 0) {
                this.println(String.format(Locale.US, "%1.4f %1.4f %1.4f rg", c1, c2, c3));
            }
            return true;
        }
        if ("cmyk".equals(colorspace)) {
            if ((type & STROKE) != 0) {
                this.println(String.format(Locale.US, "%1.4f %1.4f %1.4f %1.4f K", c1, c2, c3, c4));
            }
            if ((type & FILL) != 0) {
                this.println(String.format(Locale.US, "%1.4f %1.4f %1.4f %1.4f k", c1, c2, c3, c4));
            }
            return true;
        }
        return false;
    }

    public void setDash(double b, double w) {
        this.println(String.format(Locale.US, "[%1.2f %1.2f] 0 d", b, w));
    }

    public boolean setlinewidth(double w) {
        this.println(String.format(Locale.US, "%1.2f w", w));
        return true;
    }

    public boolean save() {
        this.flushToGraph();
        this.println("q");
        return true;
    }

    public boolean restore() {
        this.flushToGraph();
        this.println("Q");
        return true;
    }

    public boolean concat(double a, double b, double c, double d, double e, double f) {
        this.println(String.format(Locale.US, "%1.2f %1.2f %1.2f %1.2f %1.2f %1.2f cm", a, b, c, d, e, f));
        return true;
    }

    public void show(String text) {
        this._procSet.add("/Text");
        if (!this._inText) {
            this.println("BT");
            this._inText = true;
        }
        if (!this._hasFont && this._font != null) {
            this.println("/" + this._font.getPDFName() + " " + this._fontSize + " Tf");
            this._hasFont = true;
        }
        if (!this._hasTextPos) {
            this.println(String.format(Locale.US, "%1.2f %1.2f Td", this._textX, this._textY));
            this._hasTextPos = true;
        }
        this.println("(" + PDFStream.pdfEscapeText(text) + ") Tj");
    }

    public void continue_text(String text) {
        this.println("(" + PDFStream.pdfEscapeText(text) + ") T*");
    }

    public boolean fit_image(PDFImage img) {
        this._procSet.add("/ImageB");
        this._procSet.add("/ImageC");
        this._procSet.add("/ImageI");
        this.println("/I" + img.getId() + " Do");
        return true;
    }

    public boolean fit_file_image(PDFFileImage img) {
        this._procSet.add("/ImageB");
        this._procSet.add("/ImageC");
        this._procSet.add("/ImageI");
        this.println("/I" + img.getId() + " Do");
        return true;
    }

    public void flushToGraph() {
        try {
            this.flush();
            if (!this._hasGraphicsPos) {
                this._out.println(String.format(Locale.US, "%1.2f %1.2f m", this._x, this._y));
                this._hasGraphicsPos = true;
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    private void println(String s) {
        try {
            this._out.println(s);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public void flush() {
        try {
            if (this._inText) {
                this._out.println("ET");
                this._inText = false;
                this._hasTextPos = false;
            }
            this._out.flush();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public PDFProcSet getProcSet() {
        return this._procSet;
    }

    public int getLength() {
        try {
            this._out.flush();
            return this._tempStream.getLength();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public void write(PDFWriter out) throws IOException {
        out.writeStream(this.getId(), this);
    }

    public void writeToStream(WriteStream os) throws IOException {
        this._tempStream.writeToStream(os);
        this._tempStream.destroy();
    }

    public static String pdfEscapeText(String text) {
        CharBuffer cb = new CharBuffer();
        for (char c : text.toCharArray()) {
            if (c == '(' || c == ')' || c == '\\') {
                cb.append('\\');
                cb.append(c);
                continue;
            }
            if (c == '\n') {
                cb.append('\n');
                continue;
            }
            if (c == '\r') {
                cb.append('\r');
                continue;
            }
            if (c == '\t') {
                cb.append('\t');
                continue;
            }
            if (c == '\b') {
                cb.append('\b');
                continue;
            }
            if (c == '\u00ff') {
                cb.append('\f');
                continue;
            }
            cb.append(c);
        }
        return cb.toString();
    }
}

