/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.lib.i18n.Utf8Encoder;
import com.caucho.quercus.lib.regexp.IllegalRegexpException;
import com.caucho.quercus.lib.regexp.PeekString;
import com.caucho.quercus.lib.regexp.Regcomp;
import com.caucho.quercus.lib.regexp.RegexpNode;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.Map;
import java.util.logging.Logger;

public class Regexp {
    private static final Logger log = Logger.getLogger(Regexp.class.getName());
    private static final L10N L = new L10N(Regexp.class);
    public static final int FAIL = -1;
    public static final int SUCCESS = 0;
    final StringValue _rawRegexp;
    StringValue _pattern;
    int _flags;
    RegexpNode _prog;
    boolean _ignoreCase;
    boolean _isGlobal;
    int _nLoop;
    int _nGroup;
    CharBuffer _prefix;
    int _minLength;
    int _firstChar;
    boolean[] _firstSet;
    boolean _isAnchorBegin;
    StringValue[] _groupNames;
    boolean _isUnicode;
    boolean _isPHP5String;
    boolean _isUtf8;
    boolean _isEval;

    public Regexp(StringValue rawRegexp) throws IllegalRegexpException {
        this._rawRegexp = rawRegexp;
        this._pattern = rawRegexp;
        this.init();
        Regcomp comp = new Regcomp(this._flags);
        this._prog = comp.parse(new PeekString(this._pattern));
        this.compile(this._prog, comp);
    }

    protected void init() {
        StringValue pattern;
        int head;
        StringValue rawRegexp = this._rawRegexp;
        if (rawRegexp.length() < 2) {
            throw new IllegalStateException(L.l("Can't find delimiters in regexp '{0}'.", (Object)rawRegexp));
        }
        char delim = '/';
        for (head = 0; head < rawRegexp.length(); ++head) {
            char c = rawRegexp.charAt(head);
            delim = c;
            if (!Character.isWhitespace(c)) break;
        }
        if (delim == '{') {
            delim = '}';
        } else if (delim == '[') {
            delim = ']';
        } else if (delim == '(') {
            delim = ')';
        } else if (delim == '<') {
            delim = '>';
        } else if (delim == '\\' || Character.isLetterOrDigit(delim)) {
            throw new QuercusException(L.l("Delimiter {0} in regexp '{1}' must not be backslash or alphanumeric.", (Object)String.valueOf(delim), (Object)rawRegexp));
        }
        int tail = rawRegexp.lastIndexOf(delim);
        if (tail <= 0) {
            throw new QuercusException(L.l("Can't find second {0} in regexp '{1}'.", (Object)String.valueOf(delim), (Object)rawRegexp));
        }
        StringValue sflags = rawRegexp.substring(tail + 1);
        this._pattern = pattern = rawRegexp.substring(head + 1, tail);
        int flags = 0;
        block16: for (int i = 0; sflags != null && i < sflags.length(); ++i) {
            switch (sflags.charAt(i)) {
                case 'm': {
                    flags |= 1;
                    continue block16;
                }
                case 's': {
                    flags |= 2;
                    continue block16;
                }
                case 'i': {
                    flags |= 4;
                    continue block16;
                }
                case 'x': {
                    flags |= 8;
                    continue block16;
                }
                case 'g': {
                    flags |= 0x10;
                    continue block16;
                }
                case 'A': {
                    flags |= 0x20;
                    continue block16;
                }
                case 'D': {
                    flags |= 0x40;
                    continue block16;
                }
                case 'U': {
                    flags |= 0x80;
                    continue block16;
                }
                case 'X': {
                    flags |= 0x100;
                    continue block16;
                }
                case 'S': {
                    continue block16;
                }
                case 'u': {
                    flags |= 0x200;
                    continue block16;
                }
                case 'e': {
                    this._isEval = true;
                    continue block16;
                }
                case '\n': 
                case ' ': {
                    continue block16;
                }
                default: {
                    throw new QuercusException(L.l("'{0}' is an unknown regexp flag in {1}", (Object)Character.valueOf(sflags.charAt(i)), (Object)rawRegexp));
                }
            }
        }
        this._flags = flags;
        if ((flags & 0x200) != 0) {
            this._pattern = Regexp.fromUtf8(pattern);
            if (pattern == null) {
                throw new QuercusException(L.l("Regexp: error converting subject to utf8"));
            }
        }
    }

    public StringValue getRawRegexp() {
        return this._rawRegexp;
    }

    public StringValue getPattern() {
        return this._pattern;
    }

    public boolean isUTF8() {
        return this._isUtf8;
    }

    public boolean isEval() {
        return this._isEval;
    }

    public StringValue convertSubject(Env env, StringValue subject) {
        if (this.isUTF8()) {
            return Regexp.fromUtf8(subject);
        }
        return subject;
    }

    public StringValue convertResult(Env env, StringValue result) {
        if (this.isUTF8()) {
            return Regexp.toUtf8(env, result);
        }
        return result;
    }

    private void compile(RegexpNode prog, Regcomp comp) {
        this._ignoreCase = (comp._flags & 4) != 0;
        this._isGlobal = (comp._flags & 0x10) != 0;
        this._isAnchorBegin = (comp._flags & 0x20) != 0;
        boolean bl = this._isUtf8 = (comp._flags & 0x200) != 0;
        if (prog.isAnchorBegin()) {
            this._isAnchorBegin = true;
        }
        this._minLength = prog.minLength();
        this._firstChar = prog.firstChar();
        this._firstSet = prog.firstSet(new boolean[256]);
        this._prefix = new CharBuffer(prog.prefix());
        this._nGroup = comp._maxGroup;
        this._nLoop = comp._nLoop;
        this._groupNames = new StringValue[this._nGroup + 1];
        for (Map.Entry<Integer, StringValue> entry : comp._groupNameMap.entrySet()) {
            StringValue groupName = entry.getValue();
            if (!this._isUnicode && this.isUTF8()) {
                groupName.toBinaryValue("UTF-8");
            }
            this._groupNames[entry.getKey().intValue()] = groupName;
        }
    }

    public StringValue getGroupName(int i) {
        return this._groupNames[i];
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public boolean isIgnoreCase() {
        return this._ignoreCase;
    }

    static StringValue fromUtf8(StringValue source) {
        UnicodeBuilderValue target = new UnicodeBuilderValue();
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char ch3;
            char ch2;
            char ch = source.charAt(i);
            if (ch < '\u0080') {
                ((StringValue)target).append(ch);
                continue;
            }
            if ((ch & 0xE0) == 192) {
                if (len <= i + 1) {
                    log.fine(L.l("Regexp: bad UTF-8 sequence, saw EOF"));
                    return null;
                }
                ch2 = source.charAt(++i);
                ((StringValue)target).append((char)(((ch & 0x1F) << 6) + (ch2 & 0x3F)));
                continue;
            }
            if ((ch & 0xF0) == 224) {
                if (len <= i + 2) {
                    log.fine(L.l("Regexp: bad UTF-8 sequence, saw EOF"));
                    return null;
                }
                ch2 = source.charAt(++i);
                ch3 = source.charAt(++i);
                ((StringValue)target).append((char)(((ch & 0xF) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)));
                continue;
            }
            if (i + 3 >= len) {
                log.fine(L.l("Regexp: bad UTF-8 sequence, saw EOF"));
                return null;
            }
            ch2 = source.charAt(++i);
            ch3 = source.charAt(++i);
            char ch4 = source.charAt(++i);
            int codePoint = ((ch & 7) << 18) + ((ch2 & 0x3F) << 12) + ((ch3 & 0x3F) << 6) + (ch4 & 0x3F);
            int high = (codePoint - 65536 >> 10) + 55296;
            int low = (codePoint & 0x3FF) + 56320;
            ((StringValue)target).append((char)high);
            ((StringValue)target).append((char)low);
        }
        return target;
    }

    static StringValue toUtf8(Env env, StringValue source) {
        Utf8Encoder encoder = new Utf8Encoder();
        return encoder.encode(env, source);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._pattern + "]";
    }
}

