/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.SimpleXMLElement;
import java.util.Iterator;

public class SimpleXMLAttributeList
extends SimpleXMLElement {
    protected SimpleXMLAttributeList(Env env, QuercusClass cls, SimpleXMLElement parent, String name) {
        super(env, cls, parent, name);
    }

    protected SimpleXMLAttributeList(Env env, QuercusClass cls, SimpleXMLElement parent, String name, String namespace, StringValue text) {
        super(env, cls, parent, name, namespace);
        this._text = text;
    }

    @Name(value="getName")
    public String simplexml_getName() {
        if (this._attributes == null) {
            return "";
        }
        return ((SimpleXMLElement)this._attributes.get(0)).getName();
    }

    protected void addNamespace(String prefix, String namespace) {
        if (this._parent != null) {
            this._parent.addNamespace(prefix, namespace);
        }
    }

    protected void addNamespaceAttribute(Env env, String name, String namespace) {
        if (this._parent != null) {
            this._parent.addNamespaceAttribute(env, name, namespace);
        }
    }

    public Iterator iterator() {
        if (this._attributes != null) {
            return this._attributes.iterator();
        }
        return null;
    }

    protected Value toXML(Env env) {
        StringValue sb = env.createStringBuilder();
        if (this._attributes != null) {
            for (SimpleXMLElement attr : this._attributes) {
                if (attr._name.equals("xmlns")) continue;
                attr.toXMLImpl(sb);
                break;
            }
            return sb;
        }
        return BooleanValue.FALSE;
    }

    protected void toXMLImpl(StringValue sb) {
        sb.append(" ");
        if (this._prefix != null && !"".equals(this._prefix)) {
            sb.append(this._prefix);
            sb.append(":");
        }
        sb.append(this._name);
        sb.append("=\"");
        if (this._text != null) {
            sb.append(this._text);
        }
        sb.append("\"");
    }

    public Value __get(Env env, Value indexV) {
        if (indexV.isString()) {
            String name = indexV.toString();
            SimpleXMLElement attr = this.getAttribute(name);
            if (attr != null) {
                return SimpleXMLAttributeList.wrapJava(env, this._cls, attr);
            }
            return NullValue.NULL;
        }
        if (indexV.isLongConvertible()) {
            int i = indexV.toInt();
            if (i < this._attributes.size()) {
                return SimpleXMLAttributeList.wrapJava(env, this._cls, (SimpleXMLElement)this._attributes.get(i));
            }
            return NullValue.NULL;
        }
        return NullValue.NULL;
    }
}

