/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.util.L10N;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIteratorImpl<T>
implements Iterator<T> {
    private static final L10N L = new L10N(AbstractIteratorImpl.class);
    protected final Env _env;
    protected final ObjectValue _obj;
    protected final QuercusClass _qClass;
    private final AbstractFunction _nextFun;
    private final AbstractFunction _currentFun;
    private final AbstractFunction _keyFun;
    private final AbstractFunction _rewindFun;
    private final AbstractFunction _validFun;
    private boolean _needNext;

    public AbstractIteratorImpl(Env env, ObjectValue obj) {
        this._env = env;
        this._qClass = obj.getQuercusClass();
        this._obj = obj;
        if (!obj.isA("iterator")) {
            throw new IllegalStateException(L.l("'{0}' is an invalid iterator", (Object)obj));
        }
        this._currentFun = this._qClass.getFunction(env.createString("current"));
        this._keyFun = this._qClass.getFunction(env.createString("key"));
        this._nextFun = this._qClass.getFunction(env.createString("next"));
        this._rewindFun = this._qClass.getFunction(env.createString("rewind"));
        this._validFun = this._qClass.getFunction(env.createString("valid"));
        this._rewindFun.callMethod(this._env, this._qClass, (Value)this._obj);
        this._needNext = false;
    }

    @Override
    public boolean hasNext() {
        if (this._needNext) {
            this._nextFun.callMethod(this._env, this._qClass, (Value)this._obj);
        }
        this._needNext = true;
        return this._validFun.callMethod(this._env, this._qClass, (Value)this._obj).toBoolean();
    }

    @Override
    public T next() {
        return this.getCurrent();
    }

    protected abstract T getCurrent();

    protected Value getCurrentKey() {
        return this._keyFun.callMethod(this._env, this._qClass, (Value)this._obj);
    }

    protected Value getCurrentValue() {
        return this._currentFun.callMethod(this._env, this._qClass, (Value)this._obj);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

