/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.Iterator;
import com.caucho.quercus.lib.spl.SeekableIterator;
import com.caucho.quercus.lib.spl.SplFileInfo;
import com.caucho.quercus.lib.spl.Traversable;
import com.caucho.vfs.Path;
import java.io.IOException;

public class DirectoryIterator
extends SplFileInfo
implements Iterator,
Traversable,
SeekableIterator {
    private String[] _list;
    private int _index;
    private DirectoryIterator _current;

    public DirectoryIterator(Env env, StringValue fileName) {
        super(env, fileName);
        try {
            this._list = this._path.list();
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    protected DirectoryIterator(Path path) {
        super(path);
        try {
            this._list = path.list();
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public Value current(Env env) {
        DirectoryIterator current = this.getCurrent(env);
        return current != null ? env.wrapJava(current) : UnsetValue.UNSET;
    }

    protected DirectoryIterator createCurrentIterator(Env env, Path path) {
        return new DirectoryIterator(path);
    }

    protected DirectoryIterator getCurrent(Env env) {
        if (this._current == null && this._index < this._list.length) {
            String name = this._list[this._index];
            Path child = this._path.lookup(name);
            this._current = this.createCurrentIterator(env, child);
        }
        return this._current;
    }

    protected DirectoryIterator getCurrentRaw() {
        return this._current;
    }

    protected int getKey() {
        return this._index;
    }

    public Value key(Env env) {
        return LongValue.create(this._index);
    }

    public void next(Env env) {
        ++this._index;
        this._current = null;
    }

    public void rewind(Env env) {
        this._index = 0;
    }

    public boolean valid(Env env) {
        return this._index < this._list.length;
    }

    public void seek(Env env, int index) {
        this._index = index;
    }
}

