/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.marshal.StringMarshal;
import java.util.logging.Logger;

public class RegexpMarshal
extends StringMarshal {
    private static final Logger log = Logger.getLogger(RegexpModule.class.getName());
    public static final RegexpMarshal MARSHAL = new RegexpMarshal();

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        try {
            return RegexpModule.createRegexp(env, expr.evalStringValue(env));
        }
        catch (QuercusException e) {
            env.warning(e);
            return null;
        }
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        try {
            return RegexpModule.createRegexp(env, value.toStringValue(env));
        }
        catch (QuercusException e) {
            env.warning(e);
            return null;
        }
    }

    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isString()) {
            return 0;
        }
        return 0x3FFFFFF;
    }

    public int getMarshalingCost(Expr expr) {
        if (expr.isString()) {
            return 0;
        }
        return 0x3FFFFFF;
    }

    public Class getExpectedClass() {
        return Regexp.class;
    }
}

