/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.quercus.lib.db.QuercusResultSet;
import com.caucho.quercus.mysql.AbstractResultSet;
import com.caucho.quercus.mysql.MysqlColumn;
import com.caucho.quercus.mysql.MysqlResultSetMetaData;
import com.caucho.quercus.mysql.MysqlStatementImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.TempOutputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MysqlResultImpl
extends AbstractResultSet
implements QuercusResultSet {
    private static final Logger log = Logger.getLogger(MysqlResultImpl.class.getName());
    private static final L10N L = new L10N(MysqlResultImpl.class);
    private MysqlStatementImpl _stmt;
    private boolean _isResultSet;
    private int _updateCount;
    private long _insertId;
    private MysqlResultSetMetaData _resultMetaData = new MysqlResultSetMetaData();
    private int _columnCount;
    private ArrayList<MysqlColumn> _columns;
    private boolean _isRowAvailable;
    private TempOutputStream _resultData;
    private char[] _charBuffer;

    MysqlResultImpl(MysqlStatementImpl stmt) {
        this._stmt = stmt;
        this._columns = this._resultMetaData.getColumns();
    }

    public boolean isResultSet() {
        return this._isResultSet;
    }

    public void setResultSet(boolean isResultSet) {
        this._isResultSet = isResultSet;
    }

    public int getUpdateCount() {
        return this._updateCount;
    }

    public void setUpdateCount(int count) {
        this._updateCount = count;
    }

    public long getInsertId() {
        return this._insertId;
    }

    public void setInsertId(long id) {
        this._insertId = id;
    }

    public void setColumnCount(int count) {
        this._columnCount = count;
        this._resultMetaData.setColumnCount(count);
        this._columns = this._resultMetaData.getColumns();
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public MysqlColumn getColumn(int index) {
        return this._columns.get(index);
    }

    public Statement getStatement() throws SQLException {
        return this._stmt;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._resultMetaData;
    }

    public void setRowAvailable(boolean isRowAvailable) {
        this._isRowAvailable = isRowAvailable;
    }

    public boolean next() throws SQLException {
        if (this._isRowAvailable) {
            this._isRowAvailable = this._stmt.getConnection().readRow(this);
            if (!this._isRowAvailable && this._resultData != null) {
                this._resultData.destroy();
            }
        }
        return this._isRowAvailable;
    }

    public TempOutputStream getResultStream() {
        if (this._resultData == null) {
            this._resultData = new TempOutputStream();
        } else {
            this._resultData.destroy();
        }
        return this._resultData;
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public int findColumn(String columnName) throws SQLException {
        for (int i = 0; i < this._columnCount; ++i) {
            MysqlColumn column = this._columns.get(i);
            if (!column.getName().equals(columnName)) continue;
            return i + 1;
        }
        return -1;
    }

    public String getString(int columnIndex) throws SQLException {
        if (columnIndex < 1 || this._columnCount < columnIndex) {
            throw new SQLException(L.l("{0} is an invalid column [1-{1}]", columnIndex, this._columnCount));
        }
        MysqlColumn column = this._columns.get(columnIndex - 1);
        int offset = column.getRowOffset();
        int length = column.getRowLength();
        if (length < 0) {
            return null;
        }
        if (this._charBuffer == null || this._charBuffer.length < length) {
            this._charBuffer = new char[length];
        }
        this._resultData.readAll(offset, this._charBuffer, 0, length);
        return new String(this._charBuffer, 0, length);
    }

    public int getStringLength(int columnIndex) throws SQLException {
        if (columnIndex < 1 || this._columnCount < columnIndex) {
            throw new SQLException(L.l("{0} is an invalid column [1-{1}]", columnIndex, this._columnCount));
        }
        MysqlColumn column = this._columns.get(columnIndex - 1);
        return column.getRowLength();
    }

    public void getString(int columnIndex, byte[] buffer, int offset) throws SQLException {
        if (columnIndex < 1 || this._columnCount < columnIndex) {
            throw new SQLException(L.l("{0} is an invalid column [1-{1}]", columnIndex, this._columnCount));
        }
        MysqlColumn column = this._columns.get(columnIndex - 1);
        int columnOffset = column.getRowOffset();
        int columnLength = column.getRowLength();
        this._resultData.readAll(columnOffset, buffer, offset, columnLength);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

