/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.InstanceInitializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedClassDef
extends ClassDef
implements InstanceInitializer {
    protected boolean _isAbstract;
    protected boolean _isInterface;
    protected boolean _isFinal;
    protected boolean _hasNonPublicMethods;
    private boolean _isTopScope;
    protected final HashMap<String, AbstractFunction> _functionMap = new HashMap();
    protected final HashMap<StringValue, ClassDef.FieldEntry> _fieldMap = new LinkedHashMap<StringValue, ClassDef.FieldEntry>();
    protected final HashMap<StringValue, ClassDef.StaticFieldEntry> _staticFieldMap = new LinkedHashMap<StringValue, ClassDef.StaticFieldEntry>();
    protected final HashMap<StringValue, Expr> _constMap = new HashMap();
    protected AbstractFunction _constructor;
    protected AbstractFunction _destructor;
    protected AbstractFunction _getField;
    protected AbstractFunction _setField;
    protected AbstractFunction _isset;
    protected AbstractFunction _unset;
    protected AbstractFunction _call;
    protected AbstractFunction _invoke;
    protected AbstractFunction _toString;
    protected int _parseIndex;
    protected String _comment;

    public InterpretedClassDef(Location location, String name, String parentName, String[] ifaceList, int index) {
        super(location, name, parentName, ifaceList);
        this._parseIndex = index;
    }

    public InterpretedClassDef(String name, String parentName, String[] ifaceList) {
        this(null, name, parentName, ifaceList, 0);
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    @Override
    public boolean isAbstract() {
        return this._isAbstract;
    }

    public void setInterface(boolean isInterface) {
        this._isInterface = isInterface;
    }

    @Override
    public boolean isInterface() {
        return this._isInterface;
    }

    public void setFinal(boolean isFinal) {
        this._isFinal = isFinal;
    }

    @Override
    public boolean isFinal() {
        return this._isFinal;
    }

    public boolean getHasNonPublicMethods() {
        return this._hasNonPublicMethods;
    }

    public boolean isTopScope() {
        return this._isTopScope;
    }

    public void setTopScope(boolean isTopScope) {
        this._isTopScope = isTopScope;
    }

    public String getCompilationName() {
        String name = this.getName();
        name = name.replace("__", "___");
        name = name.replace("\\", "__");
        return name + "_" + this._parseIndex;
    }

    @Override
    public void initClass(QuercusClass cl) {
        if (this._constructor != null) {
            cl.setConstructor(this._constructor);
        }
        if (this._destructor != null) {
            cl.setDestructor(this._destructor);
            cl.addMethod("__destruct", this._destructor);
        }
        if (this._getField != null) {
            cl.setFieldGet(this._getField);
        }
        if (this._setField != null) {
            cl.setFieldSet(this._setField);
        }
        if (this._call != null) {
            cl.setCall(this._call);
        }
        if (this._invoke != null) {
            cl.setInvoke(this._invoke);
        }
        if (this._toString != null) {
            cl.setToString(this._toString);
        }
        if (this._isset != null) {
            cl.setIsset(this._isset);
        }
        if (this._unset != null) {
            cl.setUnset(this._unset);
        }
        cl.addInitializer(this);
        for (Map.Entry<String, AbstractFunction> entry : this._functionMap.entrySet()) {
            cl.addMethod(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<CharSequence, Object> entry : this._fieldMap.entrySet()) {
            ClassDef.FieldEntry fieldEntry = (ClassDef.FieldEntry)entry.getValue();
            cl.addField((StringValue)entry.getKey(), fieldEntry.getValue(), fieldEntry.getVisibility());
        }
        String className = this.getName();
        for (Map.Entry<StringValue, ClassDef.StaticFieldEntry> entry : this._staticFieldMap.entrySet()) {
            ClassDef.StaticFieldEntry field = entry.getValue();
            cl.addStaticFieldExpr(className, entry.getKey(), field.getValue());
        }
        for (Map.Entry<StringValue, Expr> entry : this._constMap.entrySet()) {
            cl.addConstant(entry.getKey(), entry.getValue());
        }
    }

    public void setConstructor(AbstractFunction fun) {
        this._constructor = fun;
    }

    public void addFunction(String name, Function fun) {
        this._functionMap.put(name.intern(), fun);
        if (!fun.isPublic()) {
            this._hasNonPublicMethods = true;
        }
        if (name.equals("__construct")) {
            this._constructor = fun;
        } else if (name.equals("__destruct")) {
            this._destructor = fun;
        } else if (name.equals("__get")) {
            this._getField = fun;
        } else if (name.equals("__set")) {
            this._setField = fun;
        } else if (name.equals("__call")) {
            this._call = fun;
        } else if (name.equals("__invoke")) {
            this._invoke = fun;
        } else if (name.equals("__toString")) {
            this._toString = fun;
        } else if (name.equals("__isset")) {
            this._isset = fun;
        } else if (name.equals("__unset")) {
            this._unset = fun;
        } else if (name.equalsIgnoreCase(this.getName()) && this._constructor == null) {
            this._constructor = fun;
        }
    }

    public void addStaticValue(Value name, Expr value) {
        this._staticFieldMap.put(name.toStringValue(), new ClassDef.StaticFieldEntry(value));
    }

    public void addStaticValue(Value name, Expr value, String comment) {
        this._staticFieldMap.put(name.toStringValue(), new ClassDef.StaticFieldEntry(value, comment));
    }

    public void addConstant(StringValue name, Expr value) {
        this._constMap.put(name, value);
    }

    @Override
    public Expr findConstant(String name) {
        return this._constMap.get(name);
    }

    public void addValue(Value name, Expr value, FieldVisibility visibility) {
        this._fieldMap.put(name.toStringValue(), new ClassDef.FieldEntry(value, visibility));
    }

    public void addValue(Value name, Expr value, FieldVisibility visibility, String comment) {
        this._fieldMap.put(name.toStringValue(), new ClassDef.FieldEntry(value, visibility, comment));
    }

    public Expr get(Value name) {
        ClassDef.FieldEntry entry = this._fieldMap.get(name.toStringValue());
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public boolean isDeclaredField(StringValue name) {
        return this._fieldMap.get(name) != null;
    }

    public void init(Env env) {
        QuercusClass qClass = env.getClass(this.getName());
        for (Map.Entry<StringValue, ClassDef.StaticFieldEntry> entry : this._staticFieldMap.entrySet()) {
            StringValue name = entry.getKey();
            ClassDef.StaticFieldEntry field = entry.getValue();
            Var var = qClass.getStaticFieldVar(env, name);
            var.set(field.getValue().eval(env).copy());
        }
    }

    @Override
    public void initInstance(Env env, Value value) {
        ObjectValue object = (ObjectValue)value;
        for (Map.Entry<StringValue, ClassDef.FieldEntry> entry : this._fieldMap.entrySet()) {
            ClassDef.FieldEntry fieldEntry = entry.getValue();
            object.initField(entry.getKey(), fieldEntry.getValue().eval(env).copy(), fieldEntry.getVisibility());
        }
        if (this._destructor != null) {
            env.addObjectCleanup(object);
        }
    }

    @Override
    public AbstractFunction findConstructor() {
        return this._constructor;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public String getFieldComment(StringValue name) {
        ClassDef.FieldEntry field = this._fieldMap.get(name);
        if (field != null) {
            return field.getComment();
        }
        return null;
    }

    @Override
    public String getStaticFieldComment(StringValue name) {
        ClassDef.StaticFieldEntry field = this._staticFieldMap.get(name);
        if (field != null) {
            return field.getComment();
        }
        return null;
    }

    @Override
    public Set<Map.Entry<StringValue, ClassDef.FieldEntry>> fieldSet() {
        return this._fieldMap.entrySet();
    }

    @Override
    public Set<Map.Entry<StringValue, ClassDef.StaticFieldEntry>> staticFieldSet() {
        return this._staticFieldMap.entrySet();
    }

    @Override
    public Set<Map.Entry<String, AbstractFunction>> functionSet() {
        return this._functionMap.entrySet();
    }
}

