/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.FunctionInfo;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.quercus.statement.BlockStatement;
import com.caucho.quercus.statement.ExprStatement;
import com.caucho.quercus.statement.ReturnStatement;
import com.caucho.quercus.statement.Statement;
import com.caucho.vfs.BasicDependencyContainer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuercusProgram {
    private static final Logger log = Logger.getLogger(QuercusProgram.class.getName());
    private QuercusContext _quercus;
    private QuercusPage _compiledPage;
    private QuercusPage _profilePage;
    private Path _sourceFile;
    private final AtomicBoolean _isCompiling = new AtomicBoolean();
    private boolean _isCompilable = true;
    private Exception _compileException;
    private HashMap<String, Function> _functionMap;
    private HashMap<String, Function> _functionMapLowerCase = new HashMap();
    private ArrayList<Function> _functionList;
    private HashMap<String, InterpretedClassDef> _classMap;
    private ArrayList<InterpretedClassDef> _classList;
    private FunctionInfo _functionInfo;
    private Statement _statement;
    private ArrayList<PersistentDependency> _dependList = new ArrayList();
    private AbstractFunction[] _runtimeFunList;
    private final BasicDependencyContainer _depend;
    private final BasicDependencyContainer _topDepend;

    public QuercusProgram(QuercusContext quercus, Path sourceFile, HashMap<String, Function> functionMap, ArrayList<Function> functionList, HashMap<String, InterpretedClassDef> classMap, ArrayList<InterpretedClassDef> classList, FunctionInfo functionInfo, Statement statement) {
        this._quercus = quercus;
        this._depend = new BasicDependencyContainer();
        this._depend.setCheckInterval(quercus.getDependencyCheckInterval());
        this._topDepend = new BasicDependencyContainer();
        this._topDepend.setCheckInterval(quercus.getDependencyCheckInterval());
        this._topDepend.add(new PageDependency());
        this._sourceFile = sourceFile;
        if (sourceFile != null) {
            this.addDepend(sourceFile);
        }
        this._functionMap = functionMap;
        this._functionList = functionList;
        for (Map.Entry<String, Function> entry : functionMap.entrySet()) {
            this._functionMapLowerCase.put(entry.getKey().toLowerCase(Locale.ENGLISH), entry.getValue());
        }
        this._classMap = classMap;
        this._classList = classList;
        this._functionInfo = functionInfo;
        this._statement = statement;
    }

    public QuercusProgram(QuercusContext quercus, Path sourceFile, QuercusPage page) {
        this._quercus = quercus;
        this._sourceFile = sourceFile;
        this._compiledPage = page;
        this._depend = new BasicDependencyContainer();
        this._topDepend = new BasicDependencyContainer();
        this._topDepend.setCheckInterval(quercus.getDependencyCheckInterval());
        this._topDepend.add(new PageDependency());
    }

    public QuercusContext getPhp() {
        return this._quercus;
    }

    public Path getSourcePath() {
        return this._sourceFile;
    }

    public FunctionInfo getFunctionInfo() {
        return this._functionInfo;
    }

    public Statement getStatement() {
        return this._statement;
    }

    public boolean startCompiling() {
        return this._isCompiling.compareAndSet(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCompiling() {
        QuercusProgram quercusProgram = this;
        synchronized (quercusProgram) {
            this._isCompiling.set(false);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompile() {
        QuercusProgram quercusProgram = this;
        synchronized (quercusProgram) {
            if (this._isCompiling.get()) {
                try {
                    this.wait(120000L);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    public boolean isCompiling() {
        return this._isCompiling.get();
    }

    public void setCompilable(boolean isCompilable) {
        this._isCompilable = isCompilable;
    }

    public boolean isCompilable() {
        return this._isCompilable;
    }

    public void setCompileException(Throwable e) {
        if (e == null) {
            this._compileException = null;
            return;
        }
        String msg = e.toString();
        if (msg != null && msg.length() > 4096) {
            msg = msg.substring(0, 4096);
        }
        this._compileException = new QuercusException(msg);
    }

    public Throwable getCompileException() {
        return this._compileException;
    }

    public void addDepend(Path path) {
        Depend depend = new Depend(path);
        depend.setRequireSource(this._quercus.isRequireSource());
        this._dependList.add(depend);
        this._depend.add(depend);
    }

    public ArrayList<PersistentDependency> getDependencyList() {
        return this._dependList;
    }

    public boolean isModified() {
        return this._topDepend.isModified();
    }

    public QuercusPage getCompiledPage() {
        return this._compiledPage;
    }

    public void setCompiledPage(QuercusPage page) {
        this._compiledPage = page;
    }

    public QuercusPage getProfilePage() {
        return this._profilePage;
    }

    public void setProfilePage(QuercusPage page) {
        this._profilePage = page;
    }

    public AbstractFunction findFunction(String name) {
        AbstractFunction fun = this._functionMap.get(name);
        if (fun != null) {
            return fun;
        }
        if (!this._quercus.isStrict()) {
            fun = this._functionMapLowerCase.get(name.toLowerCase(Locale.ENGLISH));
        }
        return fun;
    }

    public Collection<Function> getFunctions() {
        return this._functionMap.values();
    }

    public ArrayList<Function> getFunctionList() {
        return this._functionList;
    }

    public Collection<InterpretedClassDef> getClasses() {
        return this._classMap.values();
    }

    public ArrayList<InterpretedClassDef> getClassList() {
        return this._classList;
    }

    public QuercusProgram createExprReturn() {
        BlockStatement blockStmt;
        Statement[] statements;
        if (this._statement instanceof ExprStatement) {
            ExprStatement exprStmt = (ExprStatement)this._statement;
            this._statement = new ReturnStatement(exprStmt.getExpr());
        } else if (this._statement instanceof BlockStatement && (statements = (blockStmt = (BlockStatement)this._statement).getStatements()).length > 0 && statements[0] instanceof ExprStatement) {
            ExprStatement exprStmt = (ExprStatement)statements[0];
            this._statement = new ReturnStatement(exprStmt.getExpr());
        }
        return this;
    }

    public Value execute(Env env) {
        return this._statement.execute(env);
    }

    public void init(Env env) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRuntimeFunction(AbstractFunction[] funList) {
        QuercusProgram quercusProgram = this;
        synchronized (quercusProgram) {
            if (this._runtimeFunList == null) {
                this._runtimeFunList = funList;
                this.notifyAll();
                return true;
            }
            return false;
        }
    }

    public AbstractFunction[] getRuntimeFunctionList() {
        return this._runtimeFunList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRuntimeFunctionList(long timeout) {
        QuercusProgram quercusProgram = this;
        synchronized (quercusProgram) {
            if (this._runtimeFunList == null) {
                try {
                    if (timeout > 0L) {
                        this.wait(timeout);
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
    }

    public void importDefinitions(Env env) {
        for (Map.Entry<String, Function> entry : this._functionMap.entrySet()) {
            Function fun = entry.getValue();
            if (!fun.isGlobal()) continue;
            env.addFunction(entry.getKey(), fun);
        }
        for (Map.Entry<String, Object> entry : this._classMap.entrySet()) {
            env.addClassDef(entry.getKey(), (ClassDef)entry.getValue());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._sourceFile + "]";
    }

    class PageDependency
    implements Dependency {
        PageDependency() {
        }

        public boolean isModified() {
            if (QuercusProgram.this._compiledPage != null) {
                return QuercusProgram.this._compiledPage.isModified();
            }
            return QuercusProgram.this._depend.isModified();
        }

        public boolean logModified(Logger log) {
            if (this.isModified()) {
                log.finer(QuercusProgram.this._sourceFile + " is modified");
                return true;
            }
            return false;
        }
    }
}

