/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.script;

import com.caucho.quercus.script.QuercusScriptEngine;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuercusScriptEngineFactory
implements ScriptEngineFactory {
    private Bindings _globalBindings = new SimpleBindings();

    @Override
    public String getEngineName() {
        return "Caucho Quercus Script Engine";
    }

    @Override
    public String getEngineVersion() {
        try {
            Class<?> cl = Class.forName("com.caucho.Version");
            Field version = cl.getField("VERSION");
            return (String)version.get(null);
        }
        catch (Exception exception) {
            return "Resin/3.1.0";
        }
    }

    @Override
    public List<String> getExtensions() {
        ArrayList<String> ext = new ArrayList<String>();
        ext.add("php");
        return ext;
    }

    @Override
    public List<String> getMimeTypes() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("quercus");
        names.add("php");
        return names;
    }

    @Override
    public String getLanguageName() {
        return "php";
    }

    @Override
    public String getLanguageVersion() {
        return "5.3.2";
    }

    @Override
    public Object getParameter(String key) {
        if ("THREADING".equals(key)) {
            return "THREAD-ISOLATED";
        }
        if ("javax.script.engine".equals(key)) {
            return this.getEngineName();
        }
        if ("javax.script.engine_version".equals(key)) {
            return this.getEngineVersion();
        }
        if ("javax.script.name".equals(key)) {
            return this.getEngineName();
        }
        if ("javax.script.language".equals(key)) {
            return this.getLanguageName();
        }
        if ("javax.script.language_version".equals(key)) {
            return this.getLanguageVersion();
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append("$");
        sb.append(obj);
        sb.append("->");
        sb.append(m);
        sb.append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("$");
            sb.append(args[i]);
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "echo('" + toDisplay.replace("'", "\\'") + "');";
    }

    @Override
    public String getProgram(String[] statements) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?php\n");
        for (int i = 0; i < statements.length; ++i) {
            sb.append(statements[i]);
            sb.append(";\n");
        }
        sb.append("?>\n");
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new QuercusScriptEngine(this);
    }

    public String toString() {
        return "QuercusScriptEngineFactory[]";
    }
}

