/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.vfs.GoogleStorePath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GoogleStoreServlet
extends GenericServlet {
    private String _gsBucket;
    private Path _path;

    public void init() {
        this._gsBucket = this.getInitParameter("gs_bucket");
        if (Boolean.valueOf(this.getInitParameter("enable")).booleanValue()) {
            this._path = new GoogleStorePath(this._gsBucket);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        res.setContentType("text/html");
        if (this._path == null) {
            res.sendError(403);
            return;
        }
        String fileName = req.getParameter("file");
        if (fileName != null) {
            this.printFile(fileName, req, res);
            return;
        }
        PrintWriter out = res.getWriter();
        out.println("<pre>");
        this.printPath(out, this._path, 0);
        out.println("</pre>");
    }

    private void printFile(String fileName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String mimeType = this.getServletContext().getMimeType(fileName);
        if (fileName.endsWith(".php") || fileName.endsWith(".inc") || fileName.endsWith(".js") || fileName.endsWith(".html") || fileName.endsWith(".xsl") || fileName.endsWith(".css")) {
            res.setContentType("text/plain");
        } else if (mimeType != null) {
            res.setContentType(mimeType);
        }
        ServletOutputStream os = res.getOutputStream();
        Path path = this._path.lookup(fileName);
        path.writeToStream(os);
    }

    private void printPath(PrintWriter out, Path path, int depth) throws IOException {
        if (path == null || !path.exists()) {
            return;
        }
        this.printDepth(out, depth);
        if (path.isDirectory()) {
            out.print(path.getFullPath());
            out.print("/");
        } else if (path.isFile()) {
            out.print("<a href='?file=" + path.getFullPath() + "'>");
            out.print(path.getTail());
            out.print("</a>");
        } else {
            out.print(path.getTail());
        }
        out.print(" ");
        out.print(" len=" + path.getLength());
        out.println();
        if (path.isDirectory()) {
            Object[] names = path.list();
            if (names == null) {
                return;
            }
            Arrays.sort(names);
            for (Object name : names) {
                Path subPath = path.lookup((String)name);
                this.printPath(out, subPath, depth + 1);
            }
        }
    }

    private void printDepth(PrintWriter out, int depth) throws IOException {
        for (int i = 0; i < 2 * depth; ++i) {
            out.print(" ");
        }
    }
}

