/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.server;

import com.caucho.config.ConfigException;
import com.caucho.remote.ServiceException;
import com.caucho.remote.server.ProtocolServletFactory;
import java.lang.annotation.Annotation;
import javax.ejb.Remote;
import javax.enterprise.inject.spi.Annotated;
import javax.jws.WebService;
import javax.servlet.Servlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProtocolServletFactory
implements ProtocolServletFactory {
    @Override
    public void setServiceType(Annotation ann) {
    }

    @Override
    public void setAnnotated(Annotated annotated) {
    }

    @Override
    public abstract Servlet createServlet(Class<?> var1, Object var2) throws ServiceException;

    protected Class<?> getRemoteAPI(Class<?> serviceClass) {
        Remote remote = serviceClass.getAnnotation(Remote.class);
        if (remote != null) {
            return remote.value()[0];
        }
        for (Class<?> ifc : serviceClass.getInterfaces()) {
            if (!ifc.isAnnotationPresent(Remote.class)) continue;
            return ifc;
        }
        WebService webService = serviceClass.getAnnotation(WebService.class);
        if (webService != null && !"".equals(webService.endpointInterface())) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> api = Class.forName(webService.endpointInterface(), false, loader);
                return api;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        Class<?> remoteAPI = null;
        for (Class<?> ifc : serviceClass.getInterfaces()) {
            if (ifc.getName().startsWith("java.io") || ifc.getName().startsWith("javax.ejb")) continue;
            if (remoteAPI != null) {
                return serviceClass;
            }
            remoteAPI = ifc;
        }
        if (remoteAPI != null) {
            return remoteAPI;
        }
        return serviceClass;
    }
}

