/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.WebSocketConstants;
import com.caucho.remote.websocket.WebSocketReader;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;

public abstract class FrameInputStream
extends InputStream
implements WebSocketConstants {
    private WebSocketContext _cxt;
    private WebSocketReader _textIn;

    public void init(WebSocketContext cxt, InputStream is) {
        this._cxt = cxt;
    }

    public WebSocketContext getContext() {
        return this._cxt;
    }

    public abstract int getOpcode();

    public abstract long getLength();

    public abstract boolean isFinal();

    public WebSocketReader initReader(long length, boolean isFinal) throws IOException {
        if (this._textIn == null) {
            this._textIn = new WebSocketReader(this);
        }
        this._textIn.init(length, isFinal);
        return this._textIn;
    }

    public boolean readFrameHeader() throws IOException {
        long length = this.getLength();
        if (length > 0L) {
            this.skip(length);
        }
        do {
            if (this.readFrameHeaderImpl()) continue;
            return false;
        } while (!this.handleFrame());
        return true;
    }

    protected abstract boolean readFrameHeaderImpl() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleFrame() throws IOException {
        switch (this.getOpcode()) {
            case 9: {
                long length = this.getLength();
                if (!this.isFinal()) {
                    this.closeError(1002, "ping must be final");
                    return true;
                }
                if (length > 125L) {
                    this.closeError(1002, "ping length must be less than 125");
                    return true;
                }
                byte[] value = new byte[(int)length];
                int i = 0;
                while ((long)i < length) {
                    value[i] = (byte)this.read();
                    ++i;
                }
                this.getContext().pong(value);
                return false;
            }
            case 10: {
                if (!this.isFinal()) {
                    this.closeError(1002, "pong must be final");
                    return true;
                }
                if (this.getLength() > 125L) {
                    this.closeError(1002, "pong must be less than 125");
                    return true;
                }
                long length = this.getLength();
                byte[] value = new byte[(int)length];
                int i = 0;
                while ((long)i < length) {
                    value[i] = (byte)this.read();
                    ++i;
                }
                return false;
            }
            case 8: {
                int closeCode = 1002;
                String closeMessage = "error";
                try {
                    long length = this.getLength();
                    if (length > 125L) {
                        closeCode = 1002;
                        closeMessage = "close must be less than 125 in length";
                    } else if (!this.isFinal()) {
                        closeCode = 1002;
                        closeMessage = "close final";
                    } else if (length > 0L) {
                        int ch;
                        int d1 = this.read();
                        int d2 = this.read();
                        int code = ((d1 & 0xFF) << 8) + (d2 & 0xFF);
                        if (d2 < 0) {
                            code = 1002;
                        }
                        WebSocketReader textIn = this.initReader(length -= 2L, true);
                        StringBuilder sb = new StringBuilder();
                        while ((ch = textIn.read()) >= 0) {
                            sb.append(ch);
                        }
                        switch (code) {
                            case 1000: 
                            case 1001: 
                            case 1003: 
                            case 1007: 
                            case 1008: 
                            case 1009: 
                            case 1010: {
                                closeCode = 1000;
                                closeMessage = "ok";
                                break;
                            }
                            default: {
                                if (3000 <= code && code <= 4999) {
                                    closeCode = 1000;
                                    closeMessage = "ok";
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        closeCode = 1000;
                        closeMessage = "ok";
                    }
                    this._cxt.onClose(closeCode, closeMessage);
                    boolean bl = false;
                    Object var12_16 = null;
                    this.closeError(closeCode, closeMessage);
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    this.closeError(closeCode, closeMessage);
                    throw throwable;
                }
            }
        }
        return true;
    }

    public void skipToFrameEnd() throws IOException {
        while (this.getLength() > 0L && !this.isFinal()) {
            this.skip(this.getLength());
        }
    }

    public void closeError(int i, String msg) {
        this._cxt.close(i, msg);
    }
}

