/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.FrameInputStream;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;

public class MaskedFrameInputStream
extends FrameInputStream {
    private InputStream _is;
    private final byte[] _mask = new byte[4];
    private int _maskOffset;
    private boolean _isFinal;
    private int _op;
    private long _length;

    public void init(WebSocketContext cxt, InputStream is) {
        super.init(cxt, is);
        this._is = is;
    }

    public int getOpcode() {
        return this._op;
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public long getLength() {
        return this._length;
    }

    public final byte[] getMask() {
        return this._mask;
    }

    public int read() throws IOException {
        long length = this._length;
        if (length > 0L) {
            int ch = this._is.read();
            this._length = length - 1L;
            if (ch >= 0) {
                int maskOffset = this._maskOffset;
                this._maskOffset = maskOffset + 1 & 3;
                ch = (ch ^ this.getMask()[maskOffset]) & 0xFF;
                return ch;
            }
            return -1;
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int sublen;
        if (this._length == 0L && !this._isFinal) {
            this.readFrameHeader();
            if (this._length == 0L) {
                return -1;
            }
        }
        if (length < (sublen = (int)this._length)) {
            sublen = length;
        }
        if ((sublen = this._is.read(buffer, offset, sublen)) < 0) {
            return sublen;
        }
        int maskOffset = this._maskOffset;
        byte[] mask = this.getMask();
        for (int i = 0; i < sublen; ++i) {
            int n = offset + i;
            buffer[n] = (byte)(buffer[n] ^ mask[maskOffset + i & 3]);
        }
        this._length -= (long)sublen;
        this._maskOffset = maskOffset + sublen & 3;
        return sublen;
    }

    protected boolean readFrameHeaderImpl() throws IOException {
        do {
            InputStream is = this._is;
            int frame1 = is.read();
            int frame2 = is.read();
            if (frame2 < 0) {
                return false;
            }
            boolean isFinal = (frame1 & 0x80) == 128;
            this._op = frame1 & 0xF;
            int rsv = frame1 & 0x70;
            if (rsv != 0) {
                this.getContext().close(1002, "illegal request");
                return false;
            }
            this._isFinal = isFinal;
            long length = frame2 & 0x7F;
            if (length >= 126L) {
                length = length == 126L ? ((long)is.read() << 8) + (long)is.read() : ((long)is.read() << 56) + ((long)is.read() << 48) + ((long)is.read() << 40) + ((long)is.read() << 32) + ((long)is.read() << 24) + ((long)is.read() << 16) + ((long)is.read() << 8) + (long)is.read();
            }
            this._length = length;
            byte[] mask = this.getMask();
            if ((frame2 & 0x80) != 0) {
                mask[0] = (byte)is.read();
                mask[1] = (byte)is.read();
                mask[2] = (byte)is.read();
                mask[3] = (byte)is.read();
                this._maskOffset = 0;
                continue;
            }
            mask[0] = 0;
            mask[1] = 0;
            mask[2] = 0;
            mask[3] = 0;
            this._maskOffset = 0;
        } while (!this.handleFrame());
        return true;
    }
}

