/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.FrameInputStream;
import com.caucho.remote.websocket.WebSocketConstants;
import java.io.IOException;
import java.io.Reader;

public class WebSocketReader
extends Reader
implements WebSocketConstants {
    private static final char UTF8_ERROR = '\ufeff';
    private FrameInputStream _is;
    private boolean _isFinal;
    private long _length;
    private final char[] _buffer = new char[257];
    private int _charOffset;
    private int _charLength;

    public WebSocketReader(FrameInputStream is) throws IOException {
        this._is = is;
    }

    public void init() throws IOException {
        this.init(this._is.getLength(), this._is.isFinal());
    }

    public void init(long length, boolean isFinal) {
        this._isFinal = isFinal;
        this._length = length;
    }

    public long getLength() {
        return this._length;
    }

    public int read() throws IOException {
        int length = this._charLength;
        int offset = this._charOffset;
        if (length <= offset) {
            if (!this.fillBuffer()) {
                return -1;
            }
            offset = this._charOffset;
            length = this._charLength;
        }
        this._charOffset = offset + 1;
        return this._buffer[offset];
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        int sublen;
        int charLength = this._charLength;
        int charOffset = this._charOffset;
        if (charLength <= charOffset) {
            if (!this.fillBuffer()) {
                return -1;
            }
            charOffset = this._charOffset;
            charLength = this._charLength;
        }
        if (length < (sublen = charLength - charOffset)) {
            sublen = length;
        }
        System.arraycopy(this._buffer, charOffset, buffer, offset, sublen);
        this._charOffset = charOffset + sublen;
        return sublen;
    }

    private boolean fillBuffer() throws IOException {
        this._charOffset = 0;
        int charLength = 0;
        char[] charBuffer = this._buffer;
        int length = charBuffer.length - 1;
        while (charLength < length) {
            int d3;
            int d2;
            int ch;
            int d1 = this.readByte();
            if (d1 < 0) {
                this._charLength = charLength;
                return charLength > 0;
            }
            if (d1 < 128) {
                ch = d1;
            } else if ((d1 & 0xE0) == 192) {
                d2 = this.readByte();
                ch = (char)(((d1 & 0x1F) << 6) + (d2 & 0x3F));
                if (d2 < 0) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if ((d2 & 0xC0) != 128) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if (ch < 128) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                }
            } else if ((d1 & 0xF0) == 224) {
                d2 = this.readByte();
                d3 = this.readByte();
                ch = (char)(((d1 & 0xF) << 12) + ((d2 & 0x3F) << 6) + (d3 & 0x3F));
                if (d3 < 0) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if ((d2 & 0xC0) != 128) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if ((d3 & 0xC0) != 128) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if (ch < 2048) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if (55296 <= ch && ch <= 57343) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                }
            } else if ((d1 & 0xF8) == 240) {
                d2 = this.readByte();
                d3 = this.readByte();
                int d4 = this.readByte();
                int cp = ((d1 & 7) << 18) + ((d2 & 0x3F) << 12) + ((d3 & 0x3F) << 6) + (d4 & 0x3F);
                char h = (char)(55296 + ((cp -= 65536) >> 10 & 0x3FF));
                charBuffer[charLength++] = h;
                ch = (char)(56320 + (cp & 0x3FF));
                if (d4 < 0) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if ((d2 & 0xC0) != 128) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if ((d3 & 0xC0) != 128) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if ((d4 & 0xC0) != 128) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if (cp < 0) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                } else if (cp >= 0x100000) {
                    this._is.closeError(1007, "illegal utf-8");
                    ch = 65279;
                }
            } else {
                this._is.closeError(1007, "illegal utf-8");
                ch = 65279;
            }
            charBuffer[charLength++] = ch;
        }
        this._charLength = charLength;
        return true;
    }

    private int readByte() throws IOException {
        FrameInputStream is = this._is;
        while (this._length == 0L && !this._isFinal) {
            if (!is.readFrameHeader()) {
                return -1;
            }
            if (is.getOpcode() == 8) {
                return -1;
            }
            if (is.getOpcode() != 0) {
                this._is.closeError(1002, "illegal fragment");
                return -1;
            }
            this._isFinal = is.isFinal();
            this._length = is.getLength();
        }
        if (this._length > 0L) {
            int ch = is.read();
            --this._length;
            return ch;
        }
        return -1;
    }

    public void close() throws IOException {
        while (this._length > 0L && !this._isFinal) {
            this.skip(this._length);
        }
    }
}

