/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.scope.ContextContainer;
import com.caucho.resin.ResinBeanContainer;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanContainerRequest {
    private ClassLoader _oldClassLoader;
    private BeanContainerRequest _oldContext;
    private ResinBeanContainer _cdiContainer;
    private ContextContainer _context = new ContextContainer();

    BeanContainerRequest(ResinBeanContainer cdiContainer, ClassLoader oldClassLoader, BeanContainerRequest oldContext) {
        this._cdiContainer = cdiContainer;
        this._oldClassLoader = oldClassLoader;
        this._oldContext = oldContext;
    }

    ClassLoader getOldClassLoader() {
        return this._oldClassLoader;
    }

    BeanContainerRequest getOldContext() {
        return this._oldContext;
    }

    <T> T get(Contextual<T> bean) {
        return this._context.get(bean);
    }

    <T> T get(Contextual<T> bean, CreationalContext<T> env, InjectManager manager) {
        T value = this._context.get(bean);
        if (value != null) {
            return value;
        }
        value = bean.create(env);
        this._context.put(bean, bean, value, env);
        return value;
    }

    public void close() {
        ResinBeanContainer cdiContainer = this._cdiContainer;
        this._cdiContainer = null;
        ContextContainer context = this._context;
        this._context = null;
        if (context != null) {
            context.close();
        }
        if (cdiContainer != null) {
            cdiContainer.completeRequest(this);
        }
    }
}

