/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.rewrite.AbstractDispatchRule;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.rewrite.RewriteFilter;
import com.caucho.rewrite.RewriteFilterAdapter;
import com.caucho.server.rewrite.MatchFilterChain;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

public abstract class AbstractRegexpDispatchRule
extends AbstractDispatchRule {
    private Pattern _regexp;
    private ArrayList<RewriteFilter> _filterList = new ArrayList();
    private RewriteFilter[] _filters = new RewriteFilter[0];
    private ArrayList<RequestPredicate> _predicateList = new ArrayList();
    private RequestPredicate[] _predicates = new RequestPredicate[0];

    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    public Pattern getRegexp() {
        return this._regexp;
    }

    public boolean isRequest() {
        return true;
    }

    public boolean isInclude() {
        return false;
    }

    public boolean isForward() {
        return false;
    }

    public boolean isFilter() {
        return false;
    }

    public void add(RequestPredicate predicate) {
        this._predicateList.add(predicate);
        this._predicates = new RequestPredicate[this._predicateList.size()];
        this._predicateList.toArray(this._predicates);
    }

    public void add(RewriteFilter filter) {
        this._filterList.add(filter);
        this._filters = new RewriteFilter[this._filterList.size()];
        this._filterList.toArray(this._filters);
    }

    public void add(Filter filter) throws ServletException {
        this.add(new RewriteFilterAdapter(filter));
    }

    public String rewriteUri(String uri, String queryString) {
        return uri;
    }

    public FilterChain map(DispatcherType type, String uri, String queryString, FilterChain next, FilterChain tail) throws ServletException {
        Matcher matcher = null;
        if (this._regexp == null || (matcher = this._regexp.matcher(uri)).find()) {
            String target = this.rewriteTarget(matcher, uri, queryString);
            FilterChain chain = this.createDispatch(type, uri, queryString, target, tail);
            for (int i = this._filters.length - 1; i >= 0; --i) {
                chain = this._filters[i].map(uri, queryString, chain);
            }
            if (this._predicates.length > 0) {
                chain = new MatchFilterChain(this._predicates, chain, next);
            }
            return chain;
        }
        return next;
    }

    protected FilterChain createDispatch(DispatcherType type, String uri, String queryString, String target, FilterChain next) {
        return next;
    }

    protected String rewriteTarget(Matcher matcher, String uri, String queryString) {
        if (queryString == null) {
            return uri;
        }
        if (uri.indexOf(63) >= 0) {
            return uri + "&" + queryString;
        }
        return uri + "?" + queryString;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[regexp=" + this._regexp + "]";
    }
}

