/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.security.AbstractLogin;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClientCertLogin
extends AbstractLogin {
    public String getAuthType() {
        return "CLIENT_CERT";
    }

    public Principal authenticate(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        return this.getUserPrincipal(request, response, application);
    }

    public Principal getUserPrincipal(HttpServletRequest request) {
        return this.getUserPrincipal(request, null, null);
    }

    public Principal getUserPrincipal(HttpServletRequest request, HttpServletResponse response, ServletContext application) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs != null) {
            return certs[0].getSubjectDN();
        }
        return null;
    }
}

