/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.servlet.comet.CometController;
import com.caucho.servlet.comet.CometServlet;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometServletFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(CometServletFilterChain.class.getName());
    private ServletConfigImpl _config;
    private CometServlet _servlet;

    public CometServletFilterChain(ServletConfigImpl config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this._config = config;
    }

    public String getServletName() {
        return this._config.getServletName();
    }

    public HashMap<String, String> getRoleMap() {
        return this._config.getRoleMap();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this._servlet == null) {
            try {
                this._servlet = (CometServlet)this._config.createServlet(false);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException(e);
            }
        }
        ServletCometController controller = null;
        try {
            block15: {
                try {
                    controller = (ServletCometController)request.getAttribute("caucho.comet.controller");
                    if (controller != null) {
                        controller.suspend();
                        if (this._servlet.resume(request, response, controller)) {
                            controller = null;
                        }
                        break block15;
                    }
                    controller = new ServletCometController(request, response);
                    request.setAttribute("caucho.comet.controller", controller);
                    controller.suspend();
                    if (!this._servlet.service(request, response, controller)) break block15;
                    controller = null;
                }
                catch (UnavailableException e) {
                    this._servlet = null;
                    this._config.setInitException(e);
                    this._config.killServlet();
                    request.setAttribute("javax.servlet.error.servlet_name", this._config.getServletName());
                    throw e;
                }
                catch (ServletException e) {
                    request.setAttribute("javax.servlet.error.servlet_name", this._config.getServletName());
                    throw e;
                }
                catch (IOException e) {
                    request.setAttribute("javax.servlet.error.servlet_name", this._config.getServletName());
                    throw e;
                }
                catch (RuntimeException e) {
                    request.setAttribute("javax.servlet.error.servlet_name", this._config.getServletName());
                    throw e;
                }
            }
            Object var6_6 = null;
            if (controller != null) {
                controller.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (controller != null) {
                controller.close();
            }
            throw throwable;
        }
    }

    static class ServletCometController
    implements CometController,
    AsyncListener {
        private HttpServletRequestImpl _request;
        private ServletResponse _response;
        private AsyncContext _context;
        private AtomicBoolean _isWake = new AtomicBoolean();

        ServletCometController(ServletRequest request, ServletResponse response) {
            this._request = (HttpServletRequestImpl)request;
            this._response = response;
        }

        void suspend() {
            AsyncContext oldContext = this._context;
            if (this._request.isConnectionClosed() || this._request.isClosed()) {
                return;
            }
            this._context = this._request.startAsync();
            if (oldContext != null) {
                this._context.addListener(this);
            }
            this._isWake.set(false);
        }

        public long getMaxIdleTime() {
            return 0L;
        }

        public boolean isClosed() {
            HttpServletRequestImpl request = this._request;
            return request == null || request.isClosed() || !this.isActive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getAttribute(String name) {
            HttpServletRequestImpl request = this._request;
            if (request != null) {
                HttpServletRequestImpl httpServletRequestImpl = request;
                synchronized (httpServletRequestImpl) {
                    return request.getAttribute("caucho.comet." + name);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAttribute(String name) {
            HttpServletRequestImpl request = this._request;
            if (request != null) {
                HttpServletRequestImpl httpServletRequestImpl = request;
                synchronized (httpServletRequestImpl) {
                    request.removeAttribute("caucho.comet." + name);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(String name, Object value) {
            HttpServletRequestImpl request = this._request;
            if (request != null) {
                HttpServletRequestImpl httpServletRequestImpl = request;
                synchronized (httpServletRequestImpl) {
                    request.setAttribute("caucho.comet." + name, value);
                }
            }
        }

        public void setMaxIdleTime(long idleTime) {
            if (this._context != null) {
                this._context.setTimeout(idleTime);
            }
        }

        public boolean isActive() {
            return this._context != null;
        }

        public boolean wake() {
            if (!this._isWake.getAndSet(true)) {
                AsyncContext context = this._context;
                if (context != null) {
                    try {
                        context.dispatch();
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public void close() {
            AsyncContext context = this._context;
            this._context = null;
            if (context != null) {
                context.complete();
            }
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this._request = null;
            this._response = null;
            this._context = null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._context + "]";
        }
    }
}

