/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.jsp.Page;
import com.caucho.jsp.QServlet;
import com.caucho.server.dispatch.ServletConfigImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PageFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(PageFilterChain.class.getName());
    private ServletContext _application;
    private QServlet _servlet;
    private String _jspFile;
    private ServletConfigImpl _config;
    private ServletContext _servletContext;
    private SoftReference<Page> _pageRef;
    private boolean _isSingleThread;

    PageFilterChain(ServletContext application, QServlet servlet) {
        this._application = application;
        this._servlet = servlet;
    }

    PageFilterChain(ServletContext application, QServlet servlet, String jspFile, ServletConfigImpl config) {
        this._application = application;
        this._servlet = servlet;
        this._jspFile = jspFile;
        this._config = config;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public QServlet getServlet() {
        return this._servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block22: {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            FileNotFoundException notFound = null;
            SoftReference<Page> pageRef = this._pageRef;
            Page page = pageRef != null ? pageRef.get() : null;
            if (page == null || page._caucho_isModified()) {
                try {
                    this._pageRef = null;
                    page = this.compilePage(page, req, res);
                    if (page != null) {
                        this._pageRef = new SoftReference<Page>(page);
                        this._isSingleThread = page instanceof SingleThreadModel;
                    }
                }
                catch (FileNotFoundException e) {
                    page = null;
                    notFound = e;
                }
            }
            if (page == null) {
                if (notFound == null) {
                    return;
                }
                String errorUri = (String)req.getAttribute("javax.servlet.error.request_uri");
                String uri = (String)req.getAttribute("javax.servlet.include.request_uri");
                String forward = (String)req.getAttribute("javax.servlet.forward.request_uri");
                if (uri != null) {
                    throw notFound;
                }
                if (forward != null) {
                    throw notFound;
                }
                if (errorUri != null) {
                    throw notFound;
                }
                log.log(Level.FINER, notFound.toString(), notFound);
                res.sendError(404);
            } else if (req instanceof HttpServletRequest) {
                try {
                    if (this._isSingleThread) {
                        Page errorUri = page;
                        synchronized (errorUri) {
                            page.pageservice(req, res);
                            break block22;
                        }
                    }
                    page.pageservice(req, res);
                }
                catch (ServletException e) {
                    request.setAttribute("javax.servlet.error.exception", e);
                    if (this._config != null) {
                        request.setAttribute("javax.servlet.error.servlet_name", this._config.getServletName());
                    }
                    throw e;
                }
                catch (IOException e) {
                    request.setAttribute("javax.servlet.error.exception", e);
                    if (this._config != null) {
                        request.setAttribute("javax.servlet.error.servlet_name", this._config.getServletName());
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    request.setAttribute("javax.servlet.error.exception", e);
                    if (this._config != null) {
                        request.setAttribute("javax.servlet.error.servlet_name", this._config.getServletName());
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Page compilePage(Page oldPage, HttpServletRequest req, HttpServletResponse res) throws ServletException, FileNotFoundException {
        ServletConfig config;
        Page newPage = null;
        if (oldPage != null && !oldPage.startRecompiling()) {
            return oldPage;
        }
        try {
            try {
                if (this._jspFile != null) {
                    req.setAttribute("caucho.jsp.jsp-file", this._jspFile);
                    req.setAttribute("caucho.jsp.servlet-config", this._config);
                }
                if (this._config != null) {
                    newPage = (Page)this._config.createServlet(false);
                } else {
                    newPage = this._servlet.getPage(req, res);
                    if (newPage != null && !newPage.isInit()) {
                        config = new ServletConfigImpl();
                        ((ServletConfigImpl)config).setServletContext(this._application);
                        ((ServletConfigImpl)config).setServletName(req.getServletPath());
                        newPage.caucho_init(config);
                    }
                }
                if (oldPage != null && !oldPage.isDead()) {
                    oldPage.destroy();
                }
                if (newPage != null) {
                    newPage._caucho_use();
                }
                config = newPage;
                Object var7_10 = null;
                if (this._jspFile == null) return config;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (this._jspFile == null) throw throwable;
            req.removeAttribute("caucho.jsp.jsp-file");
            req.removeAttribute("caucho.jsp.servlet-config");
            throw throwable;
        }
        req.removeAttribute("caucho.jsp.jsp-file");
        req.removeAttribute("caucho.jsp.servlet-config");
        return config;
    }

    public String toString() {
        if (this._config != null) {
            return this.getClass().getSimpleName() + "[" + this._config + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._servlet + "]";
    }
}

