/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.config.ConfigException;
import com.caucho.db.jdbc.DataSourceImpl;
import com.caucho.env.distcache.CacheDataBacking;
import com.caucho.env.health.HealthSystemFacade;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.server.distcache.CacheData;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.DataRemoveActor;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeStore;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.HashKey;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheDataBackingImpl
implements CacheDataBacking {
    private static final Logger log = Logger.getLogger(CacheDataBackingImpl.class.getName());
    private CacheStoreManager _manager;
    private DataStore _dataStore;
    private MnodeStore _mnodeStore;
    private DataRemoveActor _removeActor;
    private final AtomicLong _createCount = new AtomicLong();
    private long _createReaperCount;
    private Alarm _reaperAlarm = new Alarm(new ReaperListener());
    private long _reaperTimeout = 3600000L;

    public CacheDataBackingImpl(CacheStoreManager storeManager) {
        this._manager = storeManager;
    }

    public void setDataStore(DataStore dataStore) {
        this._dataStore = dataStore;
    }

    public void setMnodeStore(MnodeStore mnodeStore) {
        this._mnodeStore = mnodeStore;
    }

    @Override
    public DataStore getDataStore() {
        return this._dataStore;
    }

    @Override
    public MnodeStore getMnodeStore() {
        return this._mnodeStore;
    }

    @Override
    public MnodeEntry loadLocalEntryValue(HashKey key) {
        MnodeEntry entry = this._mnodeStore.load(key);
        return entry;
    }

    @Override
    public MnodeEntry insertLocalValue(HashKey key, HashKey cacheKey, MnodeEntry mnodeUpdate, MnodeEntry oldEntryValue) {
        if (oldEntryValue == null || oldEntryValue.isImplicitNull() || oldEntryValue == MnodeEntry.NULL) {
            if (this._mnodeStore.insert(key, cacheKey, mnodeUpdate, mnodeUpdate.getValueDataId(), mnodeUpdate.getLastAccessedTime(), mnodeUpdate.getLastModifiedTime())) {
                return mnodeUpdate;
            }
            log.fine(this + " db insert failed due to timing conflict" + "(key=" + key + ")");
            return oldEntryValue;
        }
        if (this._mnodeStore.updateSave(key.getHash(), cacheKey.getHash(), mnodeUpdate, mnodeUpdate.getValueDataId(), mnodeUpdate.getLastAccessedTime(), mnodeUpdate.getLastModifiedTime())) {
            return mnodeUpdate;
        }
        if (this._mnodeStore.insert(key, cacheKey, mnodeUpdate, mnodeUpdate.getValueDataId(), mnodeUpdate.getLastAccessedTime(), mnodeUpdate.getLastModifiedTime())) {
            return mnodeUpdate;
        }
        log.fine(this + " db update failed due to timing conflict" + "(key=" + key + ")");
        return oldEntryValue;
    }

    @Override
    public boolean putLocalValue(MnodeEntry mnodeEntry, HashKey key, HashKey cacheKey, MnodeEntry oldEntryEntry, MnodeUpdate mnodeUpdate) {
        long oldDataId;
        boolean isSave = false;
        if (oldEntryEntry == null || oldEntryEntry.isImplicitNull() || oldEntryEntry == MnodeEntry.NULL) {
            long lastAccessTime = mnodeUpdate.getLastAccessTime();
            long lastModifiedTime = mnodeUpdate.getLastAccessTime();
            if (this._mnodeStore.insert(key, cacheKey, mnodeUpdate, mnodeEntry.getValueDataId(), lastAccessTime, lastModifiedTime)) {
                isSave = true;
                this.addCreateCount();
            } else {
                log.fine(this + " db insert failed due to timing conflict" + "(key=" + key + ", version=" + mnodeUpdate.getVersion() + ")");
            }
        } else if (this._mnodeStore.updateSave(key.getHash(), cacheKey.getHash(), mnodeUpdate, mnodeEntry.getValueDataId(), mnodeEntry.getLastAccessedTime(), mnodeEntry.getLastModifiedTime())) {
            isSave = true;
        } else if (this._mnodeStore.insert(key, cacheKey, mnodeUpdate, mnodeEntry.getValueDataId(), mnodeEntry.getLastAccessedTime(), mnodeEntry.getLastModifiedTime())) {
            isSave = true;
            this.addCreateCount();
        } else {
            log.fine(this + " db update failed due to timing conflict" + "(key=" + key + ", version=" + mnodeUpdate.getVersion() + ")");
        }
        if (isSave && oldEntryEntry != null && (oldDataId = oldEntryEntry.getValueDataId()) > 0L && mnodeEntry.getValueDataId() != oldDataId) {
            this.removeData(oldDataId);
        }
        return isSave;
    }

    private void addCreateCount() {
        this._createCount.incrementAndGet();
        if (this._createReaperCount < this._createCount.get()) {
            this.updateCreateReaperCount();
            this._reaperAlarm.queue(0L);
        }
    }

    @Override
    public MnodeEntry saveLocalUpdateTime(HashKey keyHash, MnodeEntry mnodeValue, MnodeEntry oldMnodeValue) {
        if (this._mnodeStore.updateAccessTime(keyHash, mnodeValue.getVersion(), mnodeValue.getAccessedExpireTimeout(), mnodeValue.getLastAccessedTime())) {
            return mnodeValue;
        }
        log.fine(this + " db updateTime failed due to timing conflict" + "(key=" + keyHash + ", version=" + mnodeValue.getVersion() + ")");
        return oldMnodeValue;
    }

    @Override
    public boolean loadData(long valueDataId, WriteStream os) throws IOException {
        return this._dataStore.load(valueDataId, os);
    }

    @Override
    public Blob loadBlob(long valueDataId) {
        return this._dataStore.loadBlob(valueDataId);
    }

    @Override
    public long saveData(StreamSource source, int length) {
        try {
            return this._dataStore.save(source, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long saveData(InputStream is, int length) throws IOException {
        return this._dataStore.save(is, length);
    }

    @Override
    public boolean removeData(long dataId) {
        this._removeActor.offer(dataId);
        return true;
    }

    @Override
    public boolean isDataAvailable(long valueIndex) {
        return valueIndex > 0L;
    }

    @Override
    public long getStartupLastUpdateTime() {
        return this._mnodeStore.getStartupLastUpdateTime();
    }

    @Override
    public long getStartupLastUpdateTime(HashKey cacheKey) {
        return this._mnodeStore.getStartupLastUpdateTime(cacheKey);
    }

    @Override
    public ArrayList<CacheData> getUpdates(long accessTime, int offset) {
        return this._mnodeStore.getUpdates(accessTime, offset);
    }

    @Override
    public ArrayList<CacheData> getUpdates(HashKey cacheKey, long accessTime, int offset) {
        return this._mnodeStore.getUpdates(cacheKey, accessTime, offset);
    }

    @Override
    public void start() {
        try {
            Path dataDirectory = RootDirectorySystem.getCurrentDataDirectory();
            String serverId = ResinSystem.getCurrentId();
            if (serverId.isEmpty()) {
                serverId = "default";
            }
            DataSource dataSource = this.createDataSource(dataDirectory, serverId);
            Path mnodeDb = dataDirectory.lookup(serverId).lookup("mnode.db");
            Path dataDb = dataDirectory.lookup(serverId).lookup("data.db");
            String exitMessage = HealthSystemFacade.getExitMessage();
            if (exitMessage.indexOf(mnodeDb.getFullPath()) >= 0 || exitMessage.indexOf(dataDb.getFullPath()) >= 0) {
                log.warning("removing cache database " + mnodeDb.getFullPath() + " because of corruption");
                try {
                    mnodeDb.remove();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                try {
                    dataDb.remove();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            String tableName = "mnode";
            this._mnodeStore = new MnodeStore(dataSource, tableName, serverId);
            this._mnodeStore.init();
            this._dataStore = new DataStore(serverId, this._mnodeStore);
            this._dataStore.init();
            this._removeActor = new DataRemoveActor(this._dataStore);
            this.updateCreateReaperCount();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        this._reaperAlarm.queue(0L);
    }

    private DataSource createDataSource(Path dataDirectory, String serverId) {
        Path path = dataDirectory.lookup("distcache");
        if (path == null) {
            throw new NullPointerException();
        }
        try {
            path.mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            DataSourceImpl dataSource = new DataSourceImpl();
            dataSource.setPath(path);
            dataSource.setRemoveOnError(true);
            dataSource.init();
            return dataSource;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void removeExpiredData() {
        boolean isExpire;
        int removeCount = 0;
        long preCount = this._mnodeStore.getCount();
        long oid = 0L;
        do {
            isExpire = false;
            long startOid = oid++;
            for (MnodeStore.ExpiredMnode data : this._mnodeStore.selectExpiredData(startOid)) {
                try {
                    if (data.getOid() < startOid) {
                        log.warning(this + " mismatched oid " + data.getOid());
                        return;
                    }
                    if (!this.removeData(data.getKey(), data.getCacheHash(), data.getDataId())) continue;
                    ++removeCount;
                    isExpire = true;
                    if (oid >= data.getOid()) continue;
                    oid = data.getOid();
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        } while (isExpire);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " removed " + removeCount + " expired entries");
        }
    }

    private boolean removeData(byte[] key, byte[] cacheHash, long dataId) {
        Object config = null;
        DistCacheEntry distEntry = this._manager.getCacheEntry(HashKey.create(key), HashKey.create(cacheHash));
        distEntry.clear();
        if (!this._mnodeStore.remove(key)) {
            return false;
        }
        if (dataId > 0L) {
            this.removeData(dataId);
        }
        return true;
    }

    private void updateCreateReaperCount() {
        long entryCount = this._mnodeStore.getCount();
        long createCount = this._createCount.get();
        int delta = Math.max(1024, (int)(entryCount / 8L));
        this._createReaperCount = createCount + (long)delta;
    }

    @Override
    public void close() {
        this._reaperAlarm.dequeue();
        MnodeStore mnodeStore = this._mnodeStore;
        this._mnodeStore = null;
        DataStore dataStore = this._dataStore;
        this._dataStore = null;
        DataRemoveActor removeActor = this._removeActor;
        this._removeActor = null;
        if (removeActor != null) {
            removeActor.close();
        }
        if (mnodeStore != null) {
            mnodeStore.close();
        }
        if (dataStore != null) {
            dataStore.destroy();
        }
    }

    class ReaperListener
    implements AlarmListener {
        ReaperListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAlarm(Alarm alarm) {
            CacheDataBackingImpl.this.updateCreateReaperCount();
            ReaperListener reaperListener = this;
            synchronized (reaperListener) {
                try {
                    CacheDataBackingImpl.this.removeExpiredData();
                }
                finally {
                    if (CacheDataBackingImpl.this._mnodeStore != null) {
                        alarm.queue(CacheDataBackingImpl.this._reaperTimeout);
                    }
                }
            }
        }
    }
}

