/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.env.service.ResinSystem;
import com.caucho.inject.Module;
import com.caucho.server.distcache.CacheEntryFactory;
import com.caucho.server.distcache.CacheHandle;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.util.HashKey;
import com.caucho.util.LruCache;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public final class CacheEntryManager {
    private final String _serverId;
    private final CacheEntryFactory _cacheEntryFactory;
    private final LruCache<HashKey, DistCacheEntry> _entryCache = new LruCache(65536);

    public CacheEntryManager(CacheEntryFactory cacheEntryFactory) {
        this._serverId = ResinSystem.getCurrentId();
        this._cacheEntryFactory = cacheEntryFactory;
    }

    public final DistCacheEntry getCacheEntry(HashKey key) {
        return this._entryCache.get(key);
    }

    public final DistCacheEntry createCacheEntry(HashKey key, CacheHandle cache) {
        DistCacheEntry cacheEntry = this._entryCache.get(key);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        cacheEntry = this._cacheEntryFactory.createCacheEntry(key, cache);
        cacheEntry = this._entryCache.putIfNew(cacheEntry.getKeyHash(), cacheEntry);
        cacheEntry.loadLocalMnodeValue();
        return cacheEntry;
    }

    public Iterator<DistCacheEntry> getEntries() {
        return this._entryCache.values();
    }

    public final void clearLeases() {
        Iterator<DistCacheEntry> iter = this._entryCache.values();
        while (iter.hasNext()) {
            DistCacheEntry entry = iter.next();
            entry.clearLease();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverId + "]";
    }
}

