/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.config.ConfigException;
import com.caucho.distcache.ByteStreamCache;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.distcache.ObjectCache;
import com.caucho.env.actor.AbstractWorkerQueue;
import com.caucho.env.distcache.CacheDataBacking;
import com.caucho.env.thread.ThreadPool;
import com.caucho.loader.Environment;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheHandle;
import com.caucho.server.distcache.CacheManagerImpl;
import com.caucho.server.distcache.CacheMnodeListener;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.DistCacheSystem;
import com.caucho.server.distcache.ExtCacheEntryFacade;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeStore;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.ConcurrentArrayList;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashKey;
import com.caucho.util.L10N;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.WriteStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheException;
import javax.cache.CacheLoader;
import javax.cache.CacheManager;
import javax.cache.CacheStatistics;
import javax.cache.Status;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryReadListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.mbeans.CacheMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheImpl<K, V>
implements ObjectCache<K, V>,
ByteStreamCache,
Closeable {
    private static final L10N L = new L10N(CacheImpl.class);
    private static final Logger log = Logger.getLogger(CacheImpl.class.getName());
    private CacheManagerImpl _localManager;
    private final CacheStoreManager _manager;
    private final String _name;
    private final String _managerName;
    private final String _guid;
    private final CacheConfig _config;
    private CacheMnodeListenerImpl _mnodeListener;
    private ConcurrentArrayList<ReadListener<K, V>> _readListeners;
    private ConcurrentArrayList<UpdatedListener<K, V>> _updatedListeners;
    private ConcurrentArrayList<CacheEntryExpiredListener> _expiredListeners;
    private ConcurrentArrayList<RemovedListener<K, V>> _removedListeners;
    private LoadQueueWorker<K, V> _loadQueue;
    private final AtomicLong _getCount = new AtomicLong();
    private final AtomicLong _hitCount = new AtomicLong();
    private final AtomicLong _missCount = new AtomicLong();
    private final AtomicLong _putCount = new AtomicLong();
    private final AtomicLong _removeCount = new AtomicLong();
    private CacheAdmin _admin = new CacheAdmin();
    private boolean _isInit;
    private boolean _isClosed;

    public CacheImpl(CacheManagerImpl localManager, String name, String managerName, String guid, CacheConfig config) {
        this._localManager = localManager;
        this._name = name;
        this._managerName = managerName;
        this._guid = guid;
        this._config = config;
        this._manager = this.getManager();
        this.init(true);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getManagerName() {
        return this._managerName;
    }

    @Override
    public CacheManager getCacheManager() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public String getGuid() {
        return this._guid;
    }

    public CacheConfig getConfig() {
        return this._config;
    }

    public CacheHandle getCacheHandle() {
        return this._config.getCache();
    }

    public long getExpireTimeout() {
        return this._config.getModifiedExpireTimeout();
    }

    public long getIdleTimeout() {
        return this._config.getAccessedExpireTimeout();
    }

    public long getIdleTimeoutWindow() {
        return this._config.getAccessedExpireTimeoutWindow();
    }

    public long getLeaseTimeout() {
        return this._config.getLeaseExpireTimeout();
    }

    public long getLocalReadTimeout() {
        return this._config.getLocalExpireTimeout();
    }

    public CacheImpl createIfAbsent() {
        this.init(true);
        return this._localManager.getCache(this._guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean ifAbsent) {
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            this._config.init();
            CacheHandle cache = this._manager.getCache(this._config.getGuid(), this._config.getKeySerializer());
            this._config.setCache(cache);
            Environment.addCloseListener(this);
        }
        this._manager.initCache(this);
        this._mnodeListener = new CacheMnodeListenerImpl();
        this._manager.addCacheListener(this.getCacheKey(), this._mnodeListener);
        this._admin.register();
    }

    public Object peek(Object key) {
        DistCacheEntry cacheEntry = this.getDistCacheEntry(key);
        return cacheEntry != null ? cacheEntry.getMnodeEntry().getValue() : null;
    }

    public HashKey getKeyHash(Object key) {
        return this.getDistCacheEntry(key).getKeyHash();
    }

    @Override
    public V get(Object key) {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        this._getCount.incrementAndGet();
        if (!entry.getMnodeEntry().isValueNull()) {
            this._hitCount.incrementAndGet();
        } else {
            this._missCount.incrementAndGet();
        }
        Object value = entry.get();
        if (this._readListeners != null) {
            this.entryRead(key, value);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " get " + key + " -> " + value);
        }
        return (V)value;
    }

    @Override
    public boolean get(Object key, OutputStream os) throws IOException {
        return this.getDistCacheEntry(key).getStream(os);
    }

    @Override
    public ExtCacheEntry getExtCacheEntry(Object key) {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        entry.loadMnodeValue();
        return this.getExtCacheEntry(entry);
    }

    @Override
    public ExtCacheEntry getExtCacheEntry(HashKey key) {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        entry.loadMnodeValue();
        return this.getExtCacheEntry(entry);
    }

    public ExtCacheEntry peekExtCacheEntry(Object key) {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        return this.getExtCacheEntry(entry);
    }

    @Override
    public ExtCacheEntry getStatCacheEntry(Object key) {
        return new ExtCacheEntryFacade(this.getDistCacheEntry(key));
    }

    public Cache.Entry getCacheEntry(Object key) {
        return this.getExtCacheEntry(key);
    }

    @Override
    public void put(K key, V value) {
        this.getDistCacheEntry(key).put(value);
        this._putCount.incrementAndGet();
        this.entryUpdate(key, value);
    }

    public ExtCacheEntry put(Object key, InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout, int flags) throws IOException {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        entry.put(is, accessedExpireTimeout, modifiedExpireTimeout, flags);
        return this.getExtCacheEntry(entry);
    }

    public ExtCacheEntry put(Object key, InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout) throws IOException {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        entry.put(is, accessedExpireTimeout, modifiedExpireTimeout);
        return this.getExtCacheEntry(entry);
    }

    public ExtCacheEntry put(Object key, InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout, long lastAccessTime, long lastModifiedTime) throws IOException {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        entry.put(is, accessedExpireTimeout, modifiedExpireTimeout, lastAccessTime, lastModifiedTime);
        return this.getExtCacheEntry(entry);
    }

    @Override
    public Object getAndPut(Object key, Object value) {
        return this.getDistCacheEntry(key).getAndPut(value);
    }

    @Override
    public boolean compareVersionAndPut(Object key, long version, Object value) {
        this.put(key, value);
        return true;
    }

    @Override
    public boolean putIfNew(Object key, MnodeUpdate update, InputStream is) throws IOException {
        return this.getDistCacheEntry(key).putIfNew(update, is);
    }

    @Override
    public boolean putIfAbsent(Object key, Object value) throws CacheException {
        long testHash = 0L;
        return this.getDistCacheEntry(key).compareAndPut(testHash, value);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object value) throws CacheException {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        long oldHash = entry.getValueHash(oldValue, this._config);
        boolean isReplace = entry.compareAndPut(oldHash, value);
        return isReplace;
    }

    @Override
    public boolean replace(Object key, Object value) throws CacheException {
        long oldHash;
        DistCacheEntry entry = this.getDistCacheEntry(key);
        boolean isChanged = entry.compareAndPut(oldHash = MnodeEntry.ANY_KEY, value);
        if (isChanged) {
            this.entryUpdate(key, value);
        }
        return isChanged;
    }

    @Override
    public Object getAndReplace(Object key, Object value) throws CacheException {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        long oldHash = MnodeEntry.ANY_KEY;
        return entry.getAndReplace(oldHash, value);
    }

    @Override
    public boolean remove(Object key) {
        boolean isRemoved = this.getDistCacheEntry(key).remove();
        if (isRemoved) {
            this.entryRemoved(key);
            this._removeCount.incrementAndGet();
        }
        return isRemoved;
    }

    @Override
    public boolean remove(Object key, Object oldValue) {
        this.getDistCacheEntry(key).remove();
        return true;
    }

    @Override
    public Object getAndRemove(Object key) throws CacheException {
        return this.getDistCacheEntry(key).getAndRemove();
    }

    @Override
    public boolean compareAndRemove(Object key, long version) {
        DistCacheEntry cacheEntry = this.getDistCacheEntry(key);
        if (cacheEntry.getMnodeEntry().getVersion() == version) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public ExtCacheEntry getLiveCacheEntry(Object key) {
        DistCacheEntry distEntry = this.getDistCacheEntry(key);
        distEntry.loadMnodeValue();
        return this.getExtCacheEntry(distEntry);
    }

    private ExtCacheEntryFacade getExtCacheEntry(DistCacheEntry distEntry) {
        return new ExtCacheEntryFacade(distEntry);
    }

    protected DistCacheEntry getDistCacheEntry(Object key) {
        DistCacheEntry cacheEntry = null;
        if (cacheEntry == null) {
            cacheEntry = this._manager.getCacheEntry(key, this._config);
        }
        return cacheEntry;
    }

    protected final DistCacheEntry getDistCacheEntry(HashKey key) {
        return this._manager.getCacheEntry(key, this.getCacheHandle());
    }

    @Override
    public Map getAll(Set keys) {
        HashMap result = new HashMap();
        for (Object key : keys) {
            V value = this.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerCacheEntryListener(CacheEntryListener<? super K, ? super V> listener) {
        CacheImpl cacheImpl;
        if (listener instanceof CacheEntryReadListener) {
            cacheImpl = this;
            synchronized (cacheImpl) {
                if (this._readListeners == null) {
                    this._readListeners = new ConcurrentArrayList<ReadListener>(ReadListener.class);
                }
            }
            this._readListeners.add(new ReadListener<K, V>(listener));
        }
        if (listener instanceof CacheEntryUpdatedListener) {
            cacheImpl = this;
            synchronized (cacheImpl) {
                if (this._updatedListeners == null) {
                    this._updatedListeners = new ConcurrentArrayList<UpdatedListener>(UpdatedListener.class);
                }
            }
            this._updatedListeners.add(new UpdatedListener<K, V>(listener));
        }
        if (listener instanceof CacheEntryRemovedListener) {
            cacheImpl = this;
            synchronized (cacheImpl) {
                if (this._removedListeners == null) {
                    this._removedListeners = new ConcurrentArrayList<RemovedListener>(RemovedListener.class);
                }
                this._removedListeners.add(new RemovedListener<K, V>(listener));
            }
        }
        if (listener instanceof CacheEntryExpiredListener) {
            cacheImpl = this;
            synchronized (cacheImpl) {
                if (this._expiredListeners == null) {
                    this._expiredListeners = new ConcurrentArrayList<CacheEntryExpiredListener>(CacheEntryExpiredListener.class);
                }
            }
        }
        return true;
    }

    @Override
    public boolean unregisterCacheEntryListener(CacheEntryListener listener) {
        boolean result = false;
        if (this.unregister(this._readListeners, listener)) {
            result = true;
        }
        if (this.unregister(this._updatedListeners, listener)) {
            result = true;
        }
        if (this.unregister(this._removedListeners, listener)) {
            result = true;
        }
        return result;
    }

    private boolean unregister(ConcurrentArrayList<? extends Listener> listeners, CacheEntryListener listener) {
        if (listeners != null) {
            for (Listener listener2 : listeners) {
                if (!listener2.isMatch(listener)) continue;
                listeners.remove(listener2);
                return true;
            }
        }
        return false;
    }

    @Override
    public CacheStatistics getStatistics() {
        return this.getMBean();
    }

    @Override
    public void putAll(Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        Set entries = map.entrySet();
        Iterator i$ = entries.iterator();
        while (i$.hasNext()) {
            Map.Entry item;
            Map.Entry entry = item = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        return entry != null && entry.getMnodeEntry().isValid();
    }

    public boolean isBackup() {
        return this._config.isBackup();
    }

    public boolean isTriplicate() {
        return this._config.isTriplicate();
    }

    public HashKey getCacheKey() {
        return this._config.getCacheKey();
    }

    protected Object cacheLoader(Object key) {
        V value = this.get(key);
        if (value != null) {
            return value;
        }
        CacheLoader loader = this._config.getCacheLoader();
        Object arg = null;
        Cache.Entry entry = value = loader != null ? loader.load(key) : null;
        if (value != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public boolean isClosed() {
        return this._isClosed;
    }

    @Override
    public void close() {
        this._isClosed = true;
        this._admin.unregister();
        this._localManager.remove(this._guid);
        this._manager.closeCache(this._guid, this.getCacheKey());
    }

    public boolean loadData(long valueDataId, WriteStream os) throws IOException {
        return this.getDataBacking().loadData(valueDataId, os);
    }

    public long saveData(StreamSource source, int length) throws IOException {
        return this.getDataBacking().saveData(source, length);
    }

    public boolean isDataAvailable(long valueDataId) {
        return this.getDataBacking().isDataAvailable(valueDataId);
    }

    private CacheDataBacking getDataBacking() {
        return this._manager.getDataBacking();
    }

    public byte[] getKeyHash(String name) {
        return this.getDistCacheEntry(name).getKeyHash().getHash();
    }

    public long getValueHash(Object value) {
        return this._manager.calculateValueHash(value, this._config);
    }

    public MnodeStore getMnodeStore() {
        return this._manager.getMnodeStore();
    }

    public DataStore getDataStore() {
        return this._manager.getDataStore();
    }

    private CacheStoreManager getManager() throws ConfigException {
        DistCacheSystem cacheService = DistCacheSystem.getCurrent();
        if (cacheService == null) {
            throw new ConfigException(L.l("'{0}' cannot be initialized because it is not in a Resin environment", (Object)this.getClass().getSimpleName()));
        }
        CacheStoreManager manager = cacheService.getDistCacheManager();
        if (manager == null) {
            throw new IllegalStateException("distributed cache manager not available");
        }
        return manager;
    }

    @Override
    public CacheMXBean getMBean() {
        return this._admin;
    }

    @Override
    public CacheConfiguration getConfiguration() {
        return this._config;
    }

    @Override
    public Object invokeEntryProcessor(Object key, Cache.EntryProcessor entryProcessor) {
        DistCacheEntry entry = this.getDistCacheEntry(key);
        if (entry == null || entry.getMnodeEntry().isValueNull()) {
            return null;
        }
        return entryProcessor.process(new MutableEntry(entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> load(K key) throws CacheException {
        LoadQueueWorker<K, V> loadQueue;
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            loadQueue = this._loadQueue;
            if (loadQueue == null) {
                loadQueue = new LoadQueueWorker(this);
                this._loadQueue = loadQueue;
            }
        }
        LoadFuture loadFuture = new LoadFuture(this, key);
        loadQueue.offer(loadFuture);
        loadQueue.wake();
        return loadFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Map<K, ? extends V>> loadAll(Set<? extends K> keys) throws CacheException {
        LoadQueueWorker<K, V> loadQueue;
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            loadQueue = this._loadQueue;
            if (loadQueue == null) {
                loadQueue = new LoadQueueWorker(this);
                this._loadQueue = loadQueue;
            }
        }
        LoadFuture loadFuture = new LoadFuture(this, keys);
        loadQueue.offer(loadFuture);
        loadQueue.wake();
        return loadFuture;
    }

    @Override
    public void removeAll(Set keys) {
        for (Object key : keys) {
            this.remove(key);
        }
    }

    @Override
    public void removeAll() throws CacheException {
        Iterator<Cache.Entry<K, V>> i$ = this.iterator();
        while (i$.hasNext()) {
            Cache.Entry<K, V> entryObj;
            Cache.Entry<K, V> entry = entryObj = i$.next();
            this.remove((Object)entry.getKey());
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        return new EntryIterator(this._manager.getEntries(), this.getCacheKey());
    }

    @Override
    public Status getStatus() {
        return Status.STARTED;
    }

    private void entryRead(Object key, V value) {
        ConcurrentArrayList<ReadListener<K, V>> readListeners = this._readListeners;
        if (readListeners == null || readListeners.size() == 0) {
            return;
        }
        CacheEntryEventImpl<Object, V> event = new CacheEntryEventImpl<Object, V>(this, key, value);
        for (ReadListener<Object, V> readListener : readListeners) {
            readListener.entryRead(event);
        }
    }

    private void mnodeOnPutUpdate(HashKey key, HashKey cacheKey, MnodeValue value) {
        ConcurrentArrayList<UpdatedListener<K, V>> updatedListeners = this._updatedListeners;
        if (updatedListeners == null || updatedListeners.size() == 0) {
            return;
        }
        this.scheduleUpdate(key, cacheKey);
    }

    private void scheduleUpdate(final HashKey key, final HashKey cacheKey) {
        ThreadPool.getCurrent().schedule(new Runnable(){

            public void run() {
                DistCacheEntry entry = CacheImpl.this._manager.getCacheEntry(key, cacheKey);
                if (entry != null) {
                    CacheImpl.this.entryUpdate(entry.getKey(), entry.get());
                }
            }
        });
    }

    private void entryUpdate(Object key, V value) {
        ConcurrentArrayList<UpdatedListener<K, V>> updatedListeners = this._updatedListeners;
        if (updatedListeners == null || updatedListeners.size() == 0) {
            return;
        }
        CacheEntryEventImpl<Object, V> event = new CacheEntryEventImpl<Object, V>(this, key, value);
        for (UpdatedListener<Object, V> updatedListener : updatedListeners) {
            updatedListener.entryUpdated(event);
        }
    }

    private void entryRemoved(Object key) {
        ConcurrentArrayList<RemovedListener<K, V>> removedListeners = this._removedListeners;
        if (removedListeners == null || removedListeners.size() == 0) {
            return;
        }
        CacheEntryEventImpl<Object, Object> event = new CacheEntryEventImpl<Object, Object>(this, key, null);
        for (RemovedListener<Object, Object> removedListener : removedListeners) {
            removedListener.entryRemoved(event);
        }
    }

    @Override
    public void start() throws CacheException {
    }

    @Override
    public void stop() throws CacheException {
    }

    @Override
    public Object unwrap(Class cl) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._guid + "]";
    }

    private class CacheMnodeListenerImpl
    implements CacheMnodeListener {
        private CacheMnodeListenerImpl() {
        }

        public void onPut(HashKey key, HashKey cacheKey, MnodeValue value) {
            CacheImpl.this.mnodeOnPutUpdate(key, cacheKey, value);
        }
    }

    class CacheAdmin
    extends AbstractManagedObject
    implements CacheMXBean {
        CacheAdmin() {
        }

        protected void register() {
            super.registerSelf();
        }

        void unregister() {
            super.unregisterSelf();
        }

        public String getName() {
            return CacheImpl.this.getName() + "|" + CacheImpl.this.getManagerName();
        }

        public Status getStatus() {
            return CacheImpl.this.getStatus();
        }

        public Date getStartAccumulationDate() {
            return null;
        }

        public long getCacheHits() {
            return CacheImpl.this._hitCount.get();
        }

        public long getCacheMisses() {
            return CacheImpl.this._missCount.get();
        }

        public float getCacheHitPercentage() {
            return 100.0f - this.getCacheMissPercentage();
        }

        public float getCacheMissPercentage() {
            long hits = this.getCacheHits();
            long misses = this.getCacheMisses();
            if (hits == 0L) {
                hits = 1L;
            }
            return (float)(100.0 * (double)misses / (double)(hits + misses));
        }

        public long getCacheGets() {
            return CacheImpl.this._getCount.get();
        }

        public long getCachePuts() {
            return CacheImpl.this._putCount.get();
        }

        public long getCacheRemovals() {
            return CacheImpl.this._removeCount.get();
        }

        public float getAverageGetMillis() {
            return 0.0f;
        }

        public float getAveragePutMillis() {
            return 0.0f;
        }

        public float getAverageRemoveMillis() {
            return 0.0f;
        }

        public long getCacheEvictions() {
            return 0L;
        }

        public void clearStatistics() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LoadFuture<K, V>
    implements Future<V> {
        private CacheImpl<K, V> _cache;
        private K _key;
        private Set<K> _keySet;
        private V _value;
        private volatile boolean _isDone;

        LoadFuture(CacheImpl<K, V> cache, K key) {
            this._cache = cache;
            this._key = key;
        }

        LoadFuture(CacheImpl<K, V> cache, Set<K> keySet) {
            this._cache = cache;
            this._keySet = keySet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void process(CacheImpl<K, V> cache) {
            try {
                this._value = this._keySet != null ? cache.getAll((Set)this._keySet) : cache.get(this._key);
            }
            finally {
                this._cache = null;
                LoadFuture loadFuture = this;
                synchronized (loadFuture) {
                    this._isDone = true;
                    this.notifyAll();
                }
            }
        }

        @Override
        public boolean cancel(boolean isCancel) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, ExecutionException {
            LoadFuture loadFuture = this;
            synchronized (loadFuture) {
                while (!this._isDone && !this._cache.isClosed()) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            return this._value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long time, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            long timeout = timeUnit.toMillis(time);
            long expireTime = CurrentTime.getCurrentTimeActual() + timeout;
            LoadFuture loadFuture = this;
            synchronized (loadFuture) {
                long now;
                while (!this._isDone && !this._cache.isClosed() && (now = CurrentTime.getCurrentTimeActual()) < expireTime) {
                    try {
                        long delta = expireTime - now;
                        this.wait(delta);
                    }
                    catch (Exception e) {}
                }
            }
            return this._value;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this._isDone;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LoadQueueWorker<K, V>
    extends AbstractWorkerQueue<LoadFuture<K, V>> {
        private CacheImpl<K, V> _cache;

        LoadQueueWorker(CacheImpl<K, V> cache) {
            super(256);
            this._cache = cache;
        }

        @Override
        public void process(LoadFuture<K, V> item) {
            CacheImpl<K, V> cache = this._cache;
            if (cache != null) {
                item.process(cache);
            }
        }

        void close() {
            this._cache = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheEntryEventImpl<K, V>
    extends CacheEntryEvent<K, V> {
        private K _key;
        private V _value;

        CacheEntryEventImpl(Cache<K, V> cache, K key, V value) {
            super(cache);
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RemovedListener<K, V>
    extends Listener<K, V>
    implements CacheEntryRemovedListener<K, V> {
        private CacheEntryRemovedListener<K, V> _listener;

        RemovedListener(CacheEntryListener<? super K, ? super V> listener) {
            this._listener = (CacheEntryRemovedListener)listener;
        }

        @Override
        public boolean isMatch(CacheEntryListener<K, V> listener) {
            return this._listener == listener;
        }

        @Override
        public void entryRemoved(CacheEntryEvent<? extends K, ? extends V> event) throws CacheEntryListenerException {
            this._listener.entryRemoved(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UpdatedListener<K, V>
    extends Listener<K, V>
    implements CacheEntryUpdatedListener<K, V> {
        private CacheEntryUpdatedListener<K, V> _listener;

        UpdatedListener(CacheEntryListener<? super K, ? super V> listener) {
            this._listener = (CacheEntryUpdatedListener)listener;
        }

        @Override
        public boolean isMatch(CacheEntryListener<K, V> listener) {
            return this._listener == listener;
        }

        @Override
        public void entryUpdated(CacheEntryEvent<? extends K, ? extends V> event) throws CacheEntryListenerException {
            this._listener.entryUpdated(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReadListener<K, V>
    extends Listener<K, V>
    implements CacheEntryReadListener<K, V> {
        private CacheEntryReadListener<K, V> _listener;

        ReadListener(CacheEntryListener<? super K, ? super V> listener) {
            this._listener = (CacheEntryReadListener)listener;
        }

        @Override
        public boolean isMatch(CacheEntryListener<K, V> listener) {
            return this._listener == listener;
        }

        @Override
        public void entryRead(CacheEntryEvent<? extends K, ? extends V> event) throws CacheEntryListenerException {
            this._listener.entryRead(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Listener<K, V> {
        Listener() {
        }

        abstract boolean isMatch(CacheEntryListener<K, V> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryIterator<K, V>
    implements Iterator<Cache.Entry<K, V>> {
        private Iterator<DistCacheEntry> _storeIterator;
        private HashKey _cacheKey;
        private DistCacheEntry _next;

        EntryIterator(Iterator<DistCacheEntry> storeIterator, HashKey cacheKey) {
            this._storeIterator = storeIterator;
            this._cacheKey = cacheKey;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            DistCacheEntry entry = this._next;
            this._next = null;
            this.findNext();
            return new ExtCacheEntryFacade(entry);
        }

        @Override
        public void remove() {
        }

        private void findNext() {
            while (this._storeIterator.hasNext()) {
                DistCacheEntry entry = this._storeIterator.next();
                if (!this._cacheKey.equals(entry.getCacheKey())) continue;
                this._next = entry;
                return;
            }
        }
    }

    class MutableEntry
    implements Cache.MutableEntry {
        private DistCacheEntry _entry;

        MutableEntry(DistCacheEntry entry) {
            this._entry = entry;
        }

        public boolean exists() {
            return !this._entry.getMnodeEntry().isValueNull();
        }

        public void remove() {
            this._entry.remove();
        }

        public void setValue(Object value) {
            this._entry.put(value);
        }

        public Object getKey() {
            return this._entry.getKey();
        }

        public Object getValue() {
            return this._entry.getMnodeEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryImpl<K, V>
    implements Cache.Entry<K, V> {
        private final K _key;
        private final V _value;

        EntryImpl(K key, V value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }
    }
}

