/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.distcache.jcache.CacheManagerFacade;
import com.caucho.loader.Environment;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheImpl;
import com.caucho.server.distcache.DistCacheSystem;
import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManagerImpl
implements Closeable {
    private DistCacheSystem _cacheSystem;
    private String _name;
    private String _guid;
    private ConcurrentHashMap<String, CacheImpl> _cacheMap;
    private CacheManagerFacade _facade;

    public CacheManagerImpl(DistCacheSystem cacheSystem, String name, String guid, ClassLoader loader) {
        this._cacheSystem = cacheSystem;
        this._name = name;
        this._guid = guid;
        this._cacheMap = new ConcurrentHashMap();
        this._facade = new CacheManagerFacade(this._name, loader, this);
        Environment.addCloseListener(this, loader);
    }

    public String getName() {
        return this._name;
    }

    public String getGuid() {
        return this._guid;
    }

    public CacheImpl getCache(String name) {
        return this._cacheMap.get(name);
    }

    public CacheImpl createIfAbsent(String name, CacheConfig config) {
        CacheImpl cache = this._cacheMap.get(name);
        if (cache == null) {
            String guid = name + ":" + this._guid;
            cache = new CacheImpl(this, name, this.getName(), guid, config);
            this._cacheMap.putIfAbsent(name, cache);
        }
        return this._cacheMap.get(name);
    }

    public void remove(String name) {
        this._cacheMap.remove(name);
    }

    public void close() {
        this._cacheMap.clear();
        this._cacheSystem.removeCacheManager(this._guid);
    }
}

