/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.util.HashKey;
import java.security.MessageDigest;

public class HashManager {
    public static final int SIZE = 32;
    public static final String HASH_ALGORITHM = "SHA-256";
    public static final HashKey NULL = new HashKey(new byte[32]);
    private MessageDigest _digest;

    public HashManager() {
        try {
            this._digest = MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashKey generateHash(String key) {
        MessageDigest messageDigest = this._digest;
        synchronized (messageDigest) {
            this._digest.reset();
            int len = key.length();
            for (int i = 0; i < len; ++i) {
                char ch = key.charAt(i);
                this._digest.update((byte)ch);
                this._digest.update((byte)(ch >> 8));
            }
            return new HashKey(this._digest.digest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashKey generateHash(HashKey priorHash, String key) {
        MessageDigest messageDigest = this._digest;
        synchronized (messageDigest) {
            this._digest.reset();
            this._digest.update(priorHash.getHash());
            int len = key.length();
            for (int i = 0; i < len; ++i) {
                char ch = key.charAt(i);
                this._digest.update((byte)ch);
                this._digest.update((byte)(ch >> 8));
            }
            return new HashKey(this._digest.digest());
        }
    }
}

