/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.db.jdbc.DataSourceImpl;
import com.caucho.server.distcache.CacheData;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.CurrentTime;
import com.caucho.util.FreeList;
import com.caucho.util.HashKey;
import com.caucho.util.Hex;
import com.caucho.util.JdbcUtil;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MnodeStore {
    private static final L10N L = new L10N(MnodeStore.class);
    private static final Logger log = Logger.getLogger(MnodeStore.class.getName());
    private FreeList<CacheMapConnection> _freeConn = new FreeList(32);
    private final String _serverName;
    private final String _tableName;
    private DataSource _dataSource;
    private boolean _isLocalDataSource;
    private String _loadQuery;
    private String _insertQuery;
    private String _updateSaveQuery;
    private String _updateAccessTimeQuery;
    private String _selectExpireQuery;
    private String _countQuery;
    private String _updatesSinceQuery;
    private String _remoteUpdatesSinceQuery;
    private String _deleteQuery;
    private long _serverVersion;
    private long _startupLastAccessTime;
    private final AtomicLong _entryCount = new AtomicLong();

    public MnodeStore(DataSource dataSource, String tableName, String serverName) throws Exception {
        this._dataSource = dataSource;
        this._isLocalDataSource = dataSource instanceof DataSourceImpl;
        this._serverName = serverName;
        this._tableName = tableName;
        if (dataSource == null) {
            throw new NullPointerException();
        }
        if (this._tableName == null) {
            throw new NullPointerException();
        }
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public String getTableName() {
        return this._tableName;
    }

    public long getStartupLastUpdateTime() {
        return this._startupLastAccessTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStartupLastUpdateTime(HashKey cacheKey) {
        long l;
        ResultSet rs;
        Connection conn;
        block8: {
            long l2;
            block7: {
                conn = null;
                rs = null;
                try {
                    conn = this._dataSource.getConnection();
                    String sql = "SELECT MAX(update_time) FROM " + this._tableName + " WHERE cache_id=?";
                    PreparedStatement pStmt = conn.prepareStatement(sql);
                    pStmt.setBytes(1, cacheKey.getHash());
                    rs = pStmt.executeQuery(sql);
                    if (rs.next()) {
                        l2 = rs.getLong(1);
                        JdbcUtil.close(rs);
                        break block7;
                    }
                    l = 0L;
                    JdbcUtil.close(rs);
                    break block8;
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, e.toString(), e);
                    long l3 = 0L;
                    return l3;
                }
            }
            JdbcUtil.close(conn);
            return l2;
        }
        JdbcUtil.close(conn);
        return l;
        finally {
            JdbcUtil.close(rs);
            JdbcUtil.close(conn);
        }
    }

    protected void init() throws Exception {
        this._loadQuery = "SELECT value_hash,value_data_id,value_length,     cache_id,flags,     item_version,server_version,     access_timeout,modified_timeout,     access_time,modified_time FROM " + this._tableName + " WHERE id=?";
        this._insertQuery = "INSERT into " + this._tableName + " (id,value_hash,value_data_id,value_length,cache_id,flags," + "  item_version,server_version," + "  access_timeout,modified_timeout," + "  access_time,modified_time)" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        this._updateSaveQuery = "UPDATE " + this._tableName + " SET value_hash=?,value_data_id=?,value_length=?,cache_id=?,flags=?," + "     item_version=?,server_version=?," + "     access_timeout=?,modified_timeout=?," + "     access_time=?,modified_time=?" + " WHERE id=? AND item_version<=?";
        this._updateAccessTimeQuery = "UPDATE " + this._tableName + " SET access_timeout=?,access_time=?" + " WHERE id=? AND item_version=?";
        this._selectExpireQuery = "SELECT resin_oid,id,cache_id,value_data_id FROM " + this._tableName + " WHERE ? < resin_oid" + " AND (access_time + 1.25 * access_timeout < ?" + "      OR modified_time + modified_timeout < ?)" + " LIMIT 4096";
        this._deleteQuery = "DELETE FROM " + this._tableName + " WHERE id=?";
        this._countQuery = "SELECT count(*) FROM " + this._tableName;
        this._updatesSinceQuery = "SELECT id,value_hash,value_data_id,value_length,cache_id,flags,item_version,     access_timeout,modified_timeout,     access_time,modified_time FROM " + this._tableName + " WHERE ? <= access_time" + "   AND bitand(flags, " + 4 + ") <> 0" + " LIMIT 1024";
        this._remoteUpdatesSinceQuery = "SELECT id,value_hash,value_data_id,value_length,     cache_id,flags,item_version,     access_timeout,modified_timeout,      access_time,modified_time FROM " + this._tableName + " WHERE ? = cache_id AND ? <= access_time" + " LIMIT 1024";
        this.initDatabase();
        this._serverVersion = this.initVersion();
        this._startupLastAccessTime = this.initLastAccessTime();
        long initCount = this.getCountImpl();
        if (initCount > 0L) {
            this._entryCount.set(initCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDatabase() throws Exception {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            try {
                String sql = "SELECT id, value_hash, value_data_id, value_length, cache_id, flags,     access_timeout, modified_timeout,     access_time, modified_time     server_version, item_version FROM " + this._tableName + " WHERE 1=0";
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                return;
            }
            catch (Exception e) {
                log.log(Level.ALL, e.toString(), e);
                log.finer(this + " " + e.toString());
                try {
                    stmt.executeQuery("DROP TABLE " + this._tableName);
                }
                catch (Exception e2) {
                    log.log(Level.ALL, e2.toString(), e2);
                    log.finer(this + " " + e2.toString());
                }
                String sql = "CREATE TABLE " + this._tableName + " (\n" + "  id BINARY(32) PRIMARY KEY,\n" + "  cache_id BINARY(32),\n" + "  value_hash BIGINT,\n" + "  value_data_id BIGINT,\n" + "  value_length BIGINT,\n" + "  access_timeout BIGINT,\n" + "  modified_timeout BIGINT,\n" + "  access_time BIGINT,\n" + "  modified_time BIGINT,\n" + "  item_version BIGINT,\n" + "  flags BIGINT,\n" + "  server_version INTEGER)";
                log.fine(sql);
                stmt.executeUpdate(sql);
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int initVersion() throws Exception {
        ResultSet rs;
        Connection conn;
        block2: {
            int n;
            conn = this._dataSource.getConnection();
            rs = null;
            try {
                Statement stmt = conn.createStatement();
                String sql = "SELECT MAX(server_version) FROM " + this._tableName;
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block2;
                n = rs.getInt(1) + 1;
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                conn.close();
                throw throwable;
            }
            JdbcUtil.close(rs);
            conn.close();
            return n;
        }
        JdbcUtil.close(rs);
        conn.close();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long initLastAccessTime() throws Exception {
        ResultSet rs;
        Connection conn;
        block2: {
            long l;
            conn = this._dataSource.getConnection();
            rs = null;
            try {
                Statement stmt = conn.createStatement();
                String sql = "SELECT MAX(access_time) FROM " + this._tableName;
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block2;
                l = rs.getLong(1);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                conn.close();
                throw throwable;
            }
            JdbcUtil.close(rs);
            conn.close();
            return l;
        }
        JdbcUtil.close(rs);
        conn.close();
        return 0L;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<CacheData> getUpdates(long updateTime, int offset) {
        ArrayList<CacheData> arrayList;
        ResultSet rs;
        Connection conn;
        block9: {
            block8: {
                conn = null;
                rs = null;
                try {
                    conn = this._dataSource.getConnection();
                    String sql = this._updatesSinceQuery;
                    PreparedStatement pstmt = conn.prepareStatement(sql);
                    pstmt.setLong(1, updateTime);
                    ArrayList<CacheData> entryList = new ArrayList<CacheData>();
                    rs = pstmt.executeQuery();
                    rs.relative(offset);
                    while (rs.next()) {
                        HashKey cacheKey;
                        byte[] keyHash = rs.getBytes(1);
                        long valueHash = rs.getLong(2);
                        long valueIndex = rs.getLong(3);
                        long valueLength = rs.getLong(4);
                        byte[] cacheHash = rs.getBytes(5);
                        long flags = rs.getLong(6);
                        long version = rs.getLong(7);
                        long accessTimeout = rs.getLong(8);
                        long modifiedTimeout = rs.getLong(9);
                        long accessTime = rs.getLong(10);
                        long modifiedTime = rs.getLong(11);
                        long leaseTimeout = 30000L;
                        HashKey hashKey = cacheKey = cacheHash != null ? new HashKey(cacheHash) : null;
                        if (keyHash == null) continue;
                        entryList.add(new CacheData(new HashKey(keyHash), cacheKey, valueHash, valueIndex, valueLength, version, flags, accessTimeout, modifiedTimeout, leaseTimeout, accessTime, modifiedTime));
                    }
                    if (entryList.size() > 0) {
                        arrayList = entryList;
                        JdbcUtil.close(rs);
                        break block8;
                    }
                    arrayList = null;
                    JdbcUtil.close(rs);
                    break block9;
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, e.toString(), e);
                    return null;
                }
            }
            JdbcUtil.close(conn);
            return arrayList;
        }
        JdbcUtil.close(conn);
        return arrayList;
        finally {
            JdbcUtil.close(rs);
            JdbcUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<CacheData> getUpdates(HashKey cacheKey, long updateTime, int offset) {
        ArrayList<CacheData> arrayList;
        ResultSet rs;
        Connection conn;
        block9: {
            block8: {
                conn = null;
                rs = null;
                try {
                    conn = this._dataSource.getConnection();
                    String sql = this._remoteUpdatesSinceQuery;
                    PreparedStatement pstmt = conn.prepareStatement(sql);
                    pstmt.setBytes(1, cacheKey.getHash());
                    pstmt.setLong(2, updateTime);
                    ArrayList<CacheData> entryList = new ArrayList<CacheData>();
                    rs = pstmt.executeQuery();
                    rs.relative(offset);
                    while (rs.next()) {
                        byte[] keyHash = rs.getBytes(1);
                        long valueHash = rs.getLong(2);
                        long valueIndex = rs.getLong(3);
                        long valueLength = rs.getLong(4);
                        byte[] cacheHash = rs.getBytes(5);
                        long flags = rs.getLong(6);
                        long version = rs.getLong(7);
                        long accessTimeout = rs.getLong(8);
                        long modifiedTimeout = rs.getLong(9);
                        long accessTime = rs.getLong(10);
                        long modifiedTime = rs.getLong(11);
                        long leaseTimeout = 30000L;
                        if (keyHash == null) continue;
                        entryList.add(new CacheData(new HashKey(keyHash), HashKey.create(cacheHash), valueHash, valueIndex, valueLength, version, flags, accessTimeout, modifiedTimeout, leaseTimeout, accessTime, modifiedTime));
                    }
                    if (entryList.size() > 0) {
                        arrayList = entryList;
                        JdbcUtil.close(rs);
                        break block8;
                    }
                    arrayList = null;
                    JdbcUtil.close(rs);
                    break block9;
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, e.toString(), e);
                    return null;
                }
            }
            JdbcUtil.close(conn);
            return arrayList;
        }
        JdbcUtil.close(conn);
        return arrayList;
        finally {
            JdbcUtil.close(rs);
            JdbcUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MnodeEntry load(HashKey id) {
        block12: {
            MnodeEntry mnodeEntry;
            CacheMapConnection conn = null;
            ResultSet rs = null;
            try {
                conn = this.getConnection();
                PreparedStatement pstmt = conn.prepareLoad();
                pstmt.setBytes(1, id.getHash());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    long valueHash = rs.getLong(1);
                    long valueDataId = rs.getLong(2);
                    long valueLength = rs.getLong(3);
                    byte[] cacheHash = rs.getBytes(4);
                    long flags = rs.getLong(5);
                    long itemVersion = rs.getLong(6);
                    long serverVersion = rs.getLong(7);
                    long accessedExpireTimeout = rs.getLong(8);
                    long modifiedExpireTimeout = rs.getLong(9);
                    long accessTime = rs.getLong(10);
                    long modifiedTime = rs.getLong(11);
                    long leaseTimeout = 300000L;
                    MnodeEntry entry = new MnodeEntry(valueHash, valueLength, itemVersion, flags, accessedExpireTimeout, modifiedExpireTimeout, leaseTimeout, valueDataId, null, accessTime, modifiedTime, serverVersion == this._serverVersion, false);
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(this + " load " + id + " " + entry);
                    }
                    MnodeEntry mnodeEntry2 = entry;
                    JdbcUtil.close(rs);
                    if (conn != null) {
                        conn.close();
                    }
                    return mnodeEntry2;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " load: no mnode for cache key " + id);
                }
                mnodeEntry = null;
                JdbcUtil.close(rs);
            }
            catch (SQLException e) {
                log.log(Level.FINE, e.toString(), e);
                break block12;
            }
            finally {
                JdbcUtil.close(rs);
                if (conn != null) {
                    conn.close();
                }
            }
            if (conn != null) {
                conn.close();
            }
            return mnodeEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(HashKey id, HashKey cacheKey, MnodeValue mnodeUpdate, long valueDataId, long lastAccessTime, long lastModifiedTime) {
        if (valueDataId == 0L != (mnodeUpdate.getValueHash() == 0L)) {
            throw new IllegalStateException(L.l("data {0} vs hash {1} mismatch for cache mnode {2}", (Object)valueDataId, (Object)mnodeUpdate.getValueHash(), (Object)id));
        }
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareInsert();
            stmt.setBytes(1, id.getHash());
            stmt.setLong(2, mnodeUpdate.getValueHash());
            stmt.setLong(3, valueDataId);
            stmt.setLong(4, mnodeUpdate.getValueLength());
            stmt.setBytes(5, cacheKey.getHash());
            stmt.setLong(6, mnodeUpdate.getFlags());
            stmt.setLong(7, mnodeUpdate.getVersion());
            stmt.setLong(8, this._serverVersion);
            stmt.setLong(9, mnodeUpdate.getAccessedExpireTimeout());
            stmt.setLong(10, mnodeUpdate.getModifiedExpireTimeout());
            long now = CurrentTime.getCurrentTime();
            stmt.setLong(11, lastAccessTime);
            stmt.setLong(12, lastModifiedTime);
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " insert key=" + id + " " + mnodeUpdate + " count=" + count);
            }
            if (count > 0) {
                this._entryCount.addAndGet(1L);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSave(byte[] key, byte[] cacheHash, MnodeValue mnodeUpdate, long valueDataId, long lastAccessTime, long lastModifiedTime) {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareUpdateSave();
            stmt.setLong(1, mnodeUpdate.getValueHash());
            stmt.setLong(2, valueDataId);
            stmt.setLong(3, mnodeUpdate.getValueLength());
            stmt.setBytes(4, cacheHash);
            stmt.setLong(5, mnodeUpdate.getFlags());
            stmt.setLong(6, mnodeUpdate.getVersion());
            stmt.setLong(7, this._serverVersion);
            stmt.setLong(8, mnodeUpdate.getAccessedExpireTimeout());
            stmt.setLong(9, mnodeUpdate.getModifiedExpireTimeout());
            stmt.setLong(10, lastAccessTime);
            stmt.setLong(11, lastModifiedTime);
            stmt.setBytes(12, key);
            stmt.setLong(13, mnodeUpdate.getVersion());
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                if (count > 0) {
                    log.finer(this + " updateSave " + HashKey.create(key) + " " + mnodeUpdate);
                } else {
                    log.finer(this + " updateSave-failed " + HashKey.create(key) + " " + mnodeUpdate);
                }
            }
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAccessTime(HashKey id, long itemVersion, long accessTimeout, long accessTime) {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.preparedUpdateAccessTime();
            stmt.setLong(1, accessTimeout);
            stmt.setLong(2, accessTime);
            stmt.setBytes(3, id.getHash());
            stmt.setLong(4, itemVersion);
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " updateUpdateTime key=" + id);
            }
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(byte[] key) {
        CacheMapConnection conn = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareDelete();
            pstmt.setBytes(1, key);
            int count = pstmt.executeUpdate();
            if (count > 0) {
                this._entryCount.addAndGet(-1L);
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " remove " + HashKey.create(key));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            JdbcUtil.close(rs);
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ExpiredMnode> selectExpiredData(long startOid) {
        ArrayList<ExpiredMnode> expireList = new ArrayList<ExpiredMnode>();
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareSelectExpire();
            long now = CurrentTime.getCurrentTime();
            pstmt.setLong(1, startOid);
            pstmt.setLong(2, now);
            pstmt.setLong(3, now);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                long oid = rs.getLong(1);
                byte[] key = rs.getBytes(2);
                byte[] cacheHash = rs.getBytes(3);
                long dataId = rs.getLong(4);
                expireList.add(new ExpiredMnode(oid, key, cacheHash, dataId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            conn.close();
        }
        return expireList;
    }

    public long getCount() {
        return this._entryCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getCountImpl() {
        long l;
        ResultSet rs;
        CacheMapConnection conn;
        block5: {
            conn = null;
            rs = null;
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareCount();
            rs = stmt.executeQuery();
            if (rs == null || !rs.next()) break block5;
            long value = rs.getLong(1);
            rs.close();
            long l2 = value;
            JdbcUtil.close(rs);
            conn.close();
            return l2;
        }
        try {
            l = -1L;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, e.toString(), e);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                conn.close();
                throw throwable;
            }
            JdbcUtil.close(rs);
            conn.close();
            return -1L;
        }
        JdbcUtil.close(rs);
        conn.close();
        return l;
    }

    public void destroy() {
        this._dataSource = null;
        this._freeConn = null;
    }

    private CacheMapConnection getConnection() throws SQLException {
        CacheMapConnection cConn = this._freeConn.allocate();
        if (cConn == null) {
            Connection conn = this._dataSource.getConnection();
            cConn = new CacheMapConnection(conn);
        }
        return cConn;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverName + "]";
    }

    public static final class ExpiredMnode {
        private final long _oid;
        private final byte[] _key;
        private final byte[] _cacheHash;
        private final long _dataId;

        ExpiredMnode(long oid, byte[] key, byte[] cacheHash, long dataId) {
            this._oid = oid;
            this._key = key;
            this._cacheHash = cacheHash;
            this._dataId = dataId;
        }

        public final long getOid() {
            return this._oid;
        }

        public final byte[] getKey() {
            return this._key;
        }

        public final byte[] getCacheHash() {
            return this._cacheHash;
        }

        public final long getDataId() {
            return this._dataId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Hex.toHex(this._key, 0, 4) + "," + Long.toHexString(this._dataId) + "]";
        }
    }

    private class CacheMapConnection {
        private Connection _conn;
        private PreparedStatement _loadStatement;
        private PreparedStatement _insertStatement;
        private PreparedStatement _updateSaveStatement;
        private PreparedStatement _updateAccessTimeStatement;
        private PreparedStatement _selectExpireStatement;
        private PreparedStatement _deleteStatement;
        private PreparedStatement _countStatement;

        CacheMapConnection(Connection conn) {
            this._conn = conn;
        }

        PreparedStatement prepareLoad() throws SQLException {
            if (this._loadStatement == null) {
                this._loadStatement = this._conn.prepareStatement(MnodeStore.this._loadQuery);
            }
            return this._loadStatement;
        }

        PreparedStatement prepareInsert() throws SQLException {
            if (this._insertStatement == null) {
                this._insertStatement = this._conn.prepareStatement(MnodeStore.this._insertQuery);
            }
            return this._insertStatement;
        }

        PreparedStatement prepareUpdateSave() throws SQLException {
            if (this._updateSaveStatement == null) {
                this._updateSaveStatement = this._conn.prepareStatement(MnodeStore.this._updateSaveQuery);
            }
            return this._updateSaveStatement;
        }

        PreparedStatement preparedUpdateAccessTime() throws SQLException {
            if (this._updateAccessTimeStatement == null) {
                this._updateAccessTimeStatement = this._conn.prepareStatement(MnodeStore.this._updateAccessTimeQuery);
            }
            return this._updateAccessTimeStatement;
        }

        PreparedStatement prepareSelectExpire() throws SQLException {
            if (this._selectExpireStatement == null) {
                this._selectExpireStatement = this._conn.prepareStatement(MnodeStore.this._selectExpireQuery);
            }
            return this._selectExpireStatement;
        }

        PreparedStatement prepareDelete() throws SQLException {
            if (this._deleteStatement == null) {
                this._deleteStatement = this._conn.prepareStatement(MnodeStore.this._deleteQuery);
            }
            return this._deleteStatement;
        }

        PreparedStatement prepareCount() throws SQLException {
            if (this._countStatement == null) {
                this._countStatement = this._conn.prepareStatement(MnodeStore.this._countQuery);
            }
            return this._countStatement;
        }

        void close() {
            if (!MnodeStore.this._isLocalDataSource || MnodeStore.this._freeConn == null || !MnodeStore.this._freeConn.freeCareful(this)) {
                try {
                    this._conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

