/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.db.block.BlockManager;
import com.caucho.distcache.jdbc.JdbcCacheBacking;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.distcache.AbstractCacheBacking;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentStoreConfig {
    private static final L10N L = new L10N(PersistentStoreConfig.class);
    private static EnvironmentLocal<PersistentStoreConfig> _current = new EnvironmentLocal();
    private String _type;
    private DataSource _dataSource;
    private String _tableName;
    private boolean _isBackup = true;
    private boolean _isTriplicate = true;
    private boolean _isAlwaysSave = false;
    private AbstractCacheBacking<?, ?> _backing;

    public static PersistentStoreConfig getCurrent() {
        return _current.get();
    }

    public void setJndiName(String name) {
    }

    public void setType(String type) throws ConfigException {
        this._type = type;
    }

    public void setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException();
        }
        this._dataSource = dataSource;
    }

    @Deprecated
    public void setPath(Path path) {
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public void setAlwaysSave(boolean isAlwaysSave) {
        this._isAlwaysSave = isAlwaysSave;
    }

    public boolean isAlwaysSave() {
        return this._isAlwaysSave;
    }

    public void setAlwaysLoad(boolean isAlwaysLoad) {
    }

    public void setBackup(boolean isBackup) {
        this._isBackup = isBackup;
    }

    public void setSaveBackup(boolean isBackup) {
        this.setBackup(isBackup);
    }

    public void setTriplicate(boolean isTriplicate) {
        this._isTriplicate = isTriplicate;
    }

    public boolean isSaveTriplicate() {
        return this._isTriplicate;
    }

    public boolean isSaveBackup() {
        return this._isBackup;
    }

    public void setWaitForAcknowledge(boolean isWait) {
    }

    public void setMaxIdleTime(Period period) {
    }

    public void setEnableMmap(boolean isEnable) {
        BlockManager.getBlockManager().setEnableMmap(isEnable);
    }

    public PersistentStoreConfig createInit() {
        return this;
    }

    public boolean isJdbc() {
        return "jdbc".equals(this._type);
    }

    public AbstractCacheBacking<?, ?> getBacking() {
        return this._backing;
    }

    @PostConstruct
    public void init() throws Exception {
        if (this.isJdbc() && this._dataSource == null) {
            throw new ConfigException(L.l("'jdbc' persistent-store requires a data-source"));
        }
        if (this.isJdbc()) {
            JdbcCacheBacking backing;
            this._backing = backing = new JdbcCacheBacking();
            backing.setDatabase(this._dataSource);
            backing.init();
        }
        _current.set(this);
    }
}

