/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.env.meter.CountSensor;
import com.caucho.env.meter.MeterService;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.ContentType;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.http.ResponseWriter;
import com.caucho.server.http.ServletOutputStreamImpl;
import com.caucho.server.log.LogBuffer;
import com.caucho.server.session.CookieImpl;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CaseInsensitiveIntMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.ClientDisconnectException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpResponse {
    private static final Logger log = Logger.getLogger(AbstractHttpResponse.class.getName());
    private static final L10N L = new L10N(AbstractHttpResponse.class);
    private static final CountSensor _statusXxxSensor = MeterService.createCountMeter("Resin|Http|xxx");
    private static final CountSensor _status2xxSensor = MeterService.createCountMeter("Resin|Http|2xx");
    private static final CountSensor _status200Sensor = MeterService.createCountMeter("Resin|Http|200");
    private static final CountSensor _status3xxSensor = MeterService.createCountMeter("Resin|Http|3xx");
    private static final CountSensor _status304Sensor = MeterService.createCountMeter("Resin|Http|304");
    private static final CountSensor _status4xxSensor = MeterService.createCountMeter("Resin|Http|4xx");
    private static final CountSensor _status400Sensor = MeterService.createCountMeter("Resin|Http|400");
    private static final CountSensor _status404Sensor = MeterService.createCountMeter("Resin|Http|404");
    private static final CountSensor _status5xxSensor = MeterService.createCountMeter("Resin|Http|5xx");
    private static final CountSensor _status500Sensor = MeterService.createCountMeter("Resin|Http|500");
    private static final CountSensor _status503Sensor = MeterService.createCountMeter("Resin|Http|503");
    private static final CaseInsensitiveIntMap _headerCodes;
    private static final int HEADER_CACHE_CONTROL = 1;
    private static final int HEADER_CONTENT_TYPE = 2;
    private static final int HEADER_CONTENT_LENGTH = 3;
    private static final int HEADER_DATE = 4;
    private static final int HEADER_SERVER = 5;
    private static final int HEADER_CONNECTION = 6;
    private static final CharBuffer CACHE_CONTROL;
    private static final CharBuffer CONNECTION;
    private static final CharBuffer CONTENT_TYPE;
    private static final CharBuffer CONTENT_LENGTH;
    private static final CharBuffer DATE;
    private static final CharBuffer SERVER;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final ConcurrentHashMap<String, ContentType> _contentTypeMap;
    protected final AbstractHttpRequest _request;
    protected final ArrayList<String> _headerKeys = new ArrayList();
    protected final ArrayList<String> _headerValues = new ArrayList();
    private final ArrayList<String> _footerKeys = new ArrayList();
    private final ArrayList<String> _footerValues = new ArrayList();
    private final AbstractResponseStream _responseStream;
    private final ServletOutputStreamImpl _responseOutputStream = new ServletOutputStreamImpl();
    private final ResponseWriter _responsePrintWriter = new ResponseWriter();
    private final LogBuffer _logBuffer = new LogBuffer(true);
    private final QDate _calendar = new QDate(false);
    private final QDate _localCalendar = new QDate(true);
    private final byte[] _dateBuffer = new byte[64];
    private final CharBuffer _dateCharBuffer = new CharBuffer();
    private int _dateBufferLength;
    private long _lastDate;
    private final byte[] _logDateBuffer = new byte[64];
    private final CharBuffer _logDateCharBuffer = new CharBuffer();
    private int _logMinutesOffset;
    private int _logSecondsOffset;
    private int _logDateBufferLength;
    private long _lastLogDate;
    private final CharBuffer _cb = new CharBuffer();
    private boolean _isHeaderWritten;
    private String _serverHeader;
    private long _contentLength;
    private boolean _isClosed;

    protected AbstractHttpResponse(AbstractHttpRequest request) {
        this._request = request;
        this._responseStream = this.createResponseStream();
    }

    protected final QDate getCalendar() {
        return this._calendar;
    }

    public boolean isIgnoreClientDisconnect() {
        return this._request.isIgnoreClientDisconnect();
    }

    public boolean isConnectionClosed() {
        return this._request.isConnectionClosed();
    }

    public void clientDisconnect() {
        try {
            this._responseStream.close();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        this._request.clientDisconnect();
    }

    public ServletResponse getResponse() {
        return null;
    }

    public AbstractHttpRequest getRequest() {
        return this._request;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void startRequest() throws IOException {
        this._headerKeys.clear();
        this._headerValues.clear();
        this._footerKeys.clear();
        this._footerValues.clear();
        this._responseStream.start();
        this._isHeaderWritten = false;
        this._contentLength = -1L;
        this._isClosed = false;
        this._serverHeader = null;
    }

    public void startInvocation() {
    }

    protected abstract AbstractResponseStream createResponseStream();

    protected void setHead() {
        this._responseStream.setHead();
    }

    protected final boolean isHead() {
        return this._responseStream.isHead();
    }

    public boolean containsHeader(String name) {
        for (int i = 0; i < this._headerKeys.size(); ++i) {
            String oldKey = this._headerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(name)) continue;
            return true;
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this._request.getResponseFacade().getContentType() != null;
        }
        if (name.equalsIgnoreCase("content-length")) {
            return this._contentLength >= 0L;
        }
        return false;
    }

    public String getHeader(String name) {
        ArrayList<String> keys = this._headerKeys;
        int headerSize = keys.size();
        for (int i = 0; i < headerSize; ++i) {
            String oldKey = keys.get(i);
            if (!oldKey.equalsIgnoreCase(name)) continue;
            return this._headerValues.get(i);
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this._request.getResponseFacade().getContentType();
        }
        if (name.equalsIgnoreCase("content-length")) {
            return this._contentLength >= 0L ? String.valueOf(this._contentLength) : null;
        }
        return null;
    }

    public void setHeader(String key, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.setSpecial(key, value)) {
            return;
        }
        if (this.isCommitted() && !this._isHeaderWritten) {
            return;
        }
        this.setHeaderImpl(key, value);
    }

    protected void setHeaderImpl(String key, String value) {
        int i = 0;
        boolean hasHeader = false;
        ArrayList<String> keys = this._headerKeys;
        ArrayList<String> values = this._headerValues;
        for (i = keys.size() - 1; i >= 0; --i) {
            String oldKey = keys.get(i);
            if (!oldKey.equalsIgnoreCase(key)) continue;
            if (hasHeader) {
                keys.remove(i);
                values.remove(i);
                continue;
            }
            hasHeader = true;
            values.set(i, value);
        }
        if (!hasHeader) {
            keys.add(key);
            values.add(value);
        }
    }

    public void addHeader(String key, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.addHeaderImpl(key, value);
    }

    public void addHeaderImpl(String key, String value) {
        if (this.setSpecial(key, value)) {
            return;
        }
        this._headerKeys.add(key);
        this._headerValues.add(value);
    }

    protected static ContentType parseContentType(String contentType) {
        ContentType item = _contentTypeMap.get(contentType);
        if (item == null) {
            item = new ContentType(contentType);
            _contentTypeMap.put(contentType, item);
        }
        return item;
    }

    protected boolean setSpecial(String key, String value) {
        int length = key.length();
        if (length == 0) {
            return false;
        }
        int ch = key.charAt(0);
        if (65 <= ch && ch <= 90) {
            ch += 32;
        }
        int code = (length << 8) + ch;
        switch (code) {
            case 3427: {
                if (CACHE_CONTROL.matchesIgnoreCase(key) && !value.startsWith("max-age") && !value.startsWith("s-maxage") && !value.equals("x-anonymous")) {
                    this._request.getResponseFacade().setCacheControl(true);
                }
                return false;
            }
            case 2659: {
                if (CONNECTION.matchesIgnoreCase(key)) {
                    if ("close".equalsIgnoreCase(value)) {
                        this._request.killKeepalive("client connection: close");
                    }
                    return true;
                }
                return false;
            }
            case 3171: {
                if (CONTENT_TYPE.matchesIgnoreCase(key)) {
                    this._request.getResponseFacade().setContentType(value);
                    return true;
                }
                return false;
            }
            case 3683: {
                if (CONTENT_LENGTH.matchesIgnoreCase(key)) {
                    this._contentLength = this.parseLong(value);
                    return true;
                }
                return false;
            }
            case 1124: {
                return DATE.matchesIgnoreCase(key);
            }
            case 1651: {
                if (SERVER.matchesIgnoreCase(key)) {
                    this._serverHeader = value;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private long parseLong(String string) {
        int i;
        int length = string.length();
        char ch = '\u0000';
        for (i = 0; i < length && Character.isWhitespace((int)(ch = string.charAt(i))); ++i) {
        }
        int sign = 1;
        long value = 0L;
        if (ch == '-') {
            sign = -1;
            if (i < length) {
                ch = string.charAt(i++);
            }
        } else if (ch == '+' && i < length) {
            ch = string.charAt(i++);
        }
        if ('0' > ch || ch > '9') {
            throw new IllegalArgumentException(L.l("'{0}' is an invalid content-length", (Object)string));
        }
        while (i < length && '0' <= (ch = string.charAt(i)) && ch <= '9') {
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return (long)sign * value;
    }

    public void removeHeader(String key) {
        ArrayList<String> keys = this._headerKeys;
        ArrayList<String> values = this._headerValues;
        for (int i = keys.size() - 1; i >= 0; --i) {
            String oldKey = keys.get(i);
            if (!oldKey.equalsIgnoreCase(key)) continue;
            keys.remove(i);
            values.remove(i);
            return;
        }
    }

    public void setIntHeader(String name, int value) {
        this._cb.clear();
        this._cb.append(value);
        this.setHeader(name, this._cb.toString());
    }

    public void addIntHeader(String key, int value) {
        this._cb.clear();
        this._cb.append(value);
        this.addHeader(key, this._cb.toString());
    }

    public void setDateHeader(String name, long value) {
        this._calendar.setGMTTime(value);
        this.setHeader(name, this._calendar.printDate());
    }

    public void addDateHeader(String key, long value) {
        this._calendar.setGMTTime(value);
        this.addHeader(key, this._calendar.printDate());
    }

    public ArrayList<String> getHeaderKeys() {
        return this._headerKeys;
    }

    public ArrayList<String> getHeaderValues() {
        return this._headerValues;
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < this._headerKeys.size(); ++i) {
            String key = this._headerKeys.get(i);
            if (!key.equals(name)) continue;
            headers.add(this._headerValues.get(i));
        }
        return headers;
    }

    public Collection<String> getHeaderNames() {
        return new HashSet<String>(this._headerKeys);
    }

    public ArrayList<String> getFooterKeys() {
        return this._footerKeys;
    }

    public ArrayList<String> getFooterValues() {
        return this._footerValues;
    }

    public void setContentLength(long length) {
        this._contentLength = length;
    }

    public final long getContentLengthHeader() {
        return this._contentLength;
    }

    public String getServerHeader() {
        return this._serverHeader;
    }

    public void setFooter(String key, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int i = 0;
        boolean hasFooter = false;
        for (i = this._footerKeys.size() - 1; i >= 0; --i) {
            String oldKey = this._footerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(key)) continue;
            if (hasFooter) {
                this._footerKeys.remove(i);
                this._footerValues.remove(i);
                continue;
            }
            hasFooter = true;
            this._footerValues.set(i, value);
        }
        if (!hasFooter) {
            this._footerKeys.add(key);
            this._footerValues.add(value);
        }
    }

    public void addFooter(String key, String value) {
        if (this.setSpecial(key, value)) {
            return;
        }
        this._footerKeys.add(key);
        this._footerValues.add(value);
    }

    protected boolean hasFooter() {
        return this._footerKeys.size() > 0;
    }

    protected AbstractResponseStream getResponseStream() {
        return this._responseStream;
    }

    protected ServletOutputStreamImpl getResponseOutputStream() {
        return this._responseOutputStream;
    }

    protected ResponseWriter getResponsePrintWriter() {
        return this._responsePrintWriter;
    }

    public boolean isCommitted() {
        if (this._responseStream.isCommitted()) {
            return true;
        }
        return this._contentLength > 0L && this._contentLength <= (long)this._responseStream.getContentLength();
    }

    protected void reset() {
        this._headerKeys.clear();
        this._headerValues.clear();
        this._contentLength = -1L;
    }

    public int getContentLength() {
        return this._responseStream.getContentLength();
    }

    public boolean isHeaderWritten() {
        return this._isHeaderWritten;
    }

    public void setHeaderWritten(boolean isWritten) {
        this._isHeaderWritten = isWritten;
    }

    final void writeContinue() throws IOException {
        if (!this.isHeaderWritten()) {
            this.writeContinueInt();
        }
    }

    protected void writeContinueInt() throws IOException {
    }

    public final boolean writeHeaders(int length) throws IOException {
        if (this.isHeaderWritten()) {
            return false;
        }
        HttpServletRequestImpl req = this._request.getRequestFacade();
        HttpServletResponseImpl res = this._request.getResponseFacade();
        if (res == null) {
            return false;
        }
        if (res.getStatus() == 304) {
            res.handleNotModified();
            length = -1;
        }
        this._isHeaderWritten = true;
        boolean isHead = false;
        if (this._request.getMethod().equals("HEAD")) {
            isHead = true;
            this._responseStream.setHead();
        }
        WebApp webApp = this._request.getWebApp();
        int statusCode = res.getStatus();
        this.addSensorCount(statusCode, webApp);
        if (req != null) {
            HttpSession session = req.getMemorySession();
            if (session instanceof SessionImpl) {
                ((SessionImpl)session).saveBeforeHeaders();
            }
            res.addServletCookie(webApp);
        }
        return this.writeHeadersInt(length, isHead);
    }

    private void addSensorCount(int statusCode, WebApp webApp) {
        int majorCode = statusCode / 100;
        block0 : switch (majorCode) {
            case 2: {
                _status2xxSensor.start();
                switch (statusCode) {
                    case 200: {
                        _status200Sensor.start();
                        break block0;
                    }
                }
                _status2xxSensor.start();
                break;
            }
            case 3: {
                switch (statusCode) {
                    case 304: {
                        _status304Sensor.start();
                        break block0;
                    }
                }
                _status3xxSensor.start();
                break;
            }
            case 4: {
                switch (statusCode) {
                    case 400: {
                        _status400Sensor.start();
                        _status4xxSensor.start();
                        break block0;
                    }
                    case 404: {
                        _status404Sensor.start();
                        break block0;
                    }
                }
                _status4xxSensor.start();
                break;
            }
            case 5: {
                if (webApp != null) {
                    webApp.addStatus500();
                }
                _status5xxSensor.start();
                switch (statusCode) {
                    case 500: {
                        _status500Sensor.start();
                        break block0;
                    }
                    case 503: {
                        _status503Sensor.start();
                        break block0;
                    }
                }
                break;
            }
            default: {
                _statusXxxSensor.start();
            }
        }
    }

    protected abstract boolean writeHeadersInt(int var1, boolean var2) throws IOException;

    public boolean fillCookie(CharBuffer cb, Cookie cookie, long date, int version, boolean isCookie2) {
        String path;
        cb.clear();
        cb.append(cookie.getName());
        if (isCookie2) {
            cb.append("=\"");
            cb.append(cookie.getValue());
            cb.append("\"");
        } else {
            cb.append("=");
            String v = cookie.getValue();
            int len = v != null ? v.length() : 0;
            for (int i = 0; i < len; ++i) {
                char ch = v.charAt(i);
                cb.append(ch);
            }
        }
        String domain = cookie.getDomain();
        if (domain != null && !domain.equals("")) {
            if (isCookie2) {
                cb.append("; Domain=");
                cb.append('\"');
                cb.append(domain);
                cb.append('\"');
            } else {
                cb.append("; domain=");
                cb.append(domain);
            }
        }
        if ((path = cookie.getPath()) != null && !path.equals("")) {
            if (isCookie2) {
                cb.append("; Path=");
                cb.append('\"');
                cb.append(path);
                cb.append('\"');
            } else {
                if (version > 0) {
                    cb.append("; Path=");
                } else {
                    cb.append("; path=");
                }
                cb.append(path);
            }
        }
        if (cookie.getSecure()) {
            if (version > 0) {
                cb.append("; Secure");
            } else {
                cb.append("; secure");
            }
        }
        int maxAge = cookie.getMaxAge();
        if (version > 0) {
            CookieImpl extCookie;
            String port;
            if (maxAge >= 0) {
                cb.append("; Max-Age=");
                cb.append(maxAge);
            }
            cb.append("; Version=");
            cb.append(version);
            if (cookie.getComment() != null) {
                if (isCookie2) {
                    cb.append("; Comment=\"");
                    cb.append(cookie.getComment());
                    cb.append("\"");
                } else {
                    cb.append("; Comment=");
                    cb.append(cookie.getComment());
                }
            }
            if (cookie instanceof CookieImpl && (port = (extCookie = (CookieImpl)cookie).getPort()) != null && isCookie2) {
                cb.append("; Port=\"");
                cb.append(port);
                cb.append("\"");
            }
        }
        if (!isCookie2) {
            if (maxAge == 0) {
                cb.append("; expires=Thu, 01-Dec-1994 16:00:00 GMT");
            } else if (maxAge >= 0) {
                this._calendar.setGMTTime(date + 1000L * (long)maxAge);
                cb.append("; expires=");
                cb.append(this._calendar.format("%a, %d-%b-%Y %H:%M:%S GMT"));
            }
        }
        if (cookie.isHttpOnly()) {
            cb.append("; HttpOnly");
        }
        return true;
    }

    public final LogBuffer getLogBuffer() {
        return this._logBuffer;
    }

    public final byte[] fillDateBuffer(long now) {
        if (this._lastDate / 1000L != now / 1000L) {
            this.fillDate(now);
        }
        return this._dateBuffer;
    }

    public final int getDateBufferLength() {
        return this._dateBufferLength;
    }

    public final int getRawDateBufferOffset() {
        return 8;
    }

    public final int getRawDateBufferLength() {
        return 24;
    }

    private void fillDate(long now) {
        if (this._lastDate / 3600000L == now / 3600000L) {
            int min = (int)(now / 60000L % 60L);
            int sec = (int)(now / 1000L % 60L);
            int m2 = 48 + min / 10;
            int m1 = 48 + min % 10;
            int s2 = 48 + sec / 10;
            int s1 = 48 + sec % 10;
            this._dateBuffer[28] = (byte)m2;
            this._dateBuffer[29] = (byte)m1;
            this._dateBuffer[31] = (byte)s2;
            this._dateBuffer[32] = (byte)s1;
            this._lastDate = now;
            return;
        }
        this._lastDate = now;
        this._calendar.setGMTTime(now);
        this._dateCharBuffer.clear();
        this._dateCharBuffer.append("\r\nDate: ");
        this._calendar.printDate(this._dateCharBuffer);
        char[] cb = this._dateCharBuffer.getBuffer();
        int len = this._dateCharBuffer.getLength();
        for (int i = len - 1; i >= 0; --i) {
            this._dateBuffer[i] = (byte)cb[i];
        }
        this._dateBuffer[len] = 13;
        this._dateBuffer[len + 1] = 10;
        this._dateBuffer[len + 2] = 13;
        this._dateBuffer[len + 3] = 10;
        this._dateBufferLength = len + 4;
    }

    public final byte[] fillLogDateBuffer(long now, String timeFormat) {
        if (this._lastLogDate / 1000L != now / 1000L) {
            this.fillLogDate(now, timeFormat);
        }
        return this._logDateBuffer;
    }

    public final int getLogDateBufferLength() {
        return this._logDateBufferLength;
    }

    private void fillLogDate(long now, String timeFormat) {
        if (this._lastLogDate / 3600000L == now / 3600000L) {
            int min = (int)(now / 60000L % 60L);
            int sec = (int)(now / 1000L % 60L);
            int m2 = 48 + min / 10;
            int m1 = 48 + min % 10;
            int s2 = 48 + sec / 10;
            int s1 = 48 + sec % 10;
            this._logDateBuffer[this._logMinutesOffset + 0] = (byte)m2;
            this._logDateBuffer[this._logMinutesOffset + 1] = (byte)m1;
            this._logDateBuffer[this._logSecondsOffset + 0] = (byte)s2;
            this._logDateBuffer[this._logSecondsOffset + 1] = (byte)s1;
            this._lastLogDate = now;
            return;
        }
        this._lastLogDate = now;
        this._localCalendar.setGMTTime(now);
        this._logDateCharBuffer.clear();
        this._localCalendar.format(this._logDateCharBuffer, timeFormat);
        this._logSecondsOffset = this._logDateCharBuffer.lastIndexOf(':') + 1;
        this._logMinutesOffset = this._logSecondsOffset - 3;
        char[] cb = this._logDateCharBuffer.getBuffer();
        int len = this._logDateCharBuffer.getLength();
        for (int i = len - 1; i >= 0; --i) {
            this._logDateBuffer[i] = (byte)cb[i];
        }
        this._logDateBufferLength = len;
    }

    public void close() throws IOException {
        if (!this._request.isSuspend()) {
            this.finishInvocation(true);
        }
    }

    public void finishInvocation() throws IOException {
        boolean isClose = !this._request.isSuspend();
        this.finishInvocation(isClose);
    }

    public void finishRequest() throws IOException {
        this.finishRequest(false);
    }

    private void finishInvocation(boolean isClose) throws IOException {
        if (this._isClosed) {
            return;
        }
        try {
            HttpServletResponseImpl response = this._request.getResponseFacade();
            if (response != null && response.getStatus() == 304) {
                response.handleNotModified();
            }
            if (this._responseStream != null) {
                if (isClose) {
                    this._responseStream.close();
                } else if (!this._request.getRequestFacade().isAsyncStarted() || this._responseStream.getContentLength() != 0) {
                    this._responseStream.flush();
                }
            }
        }
        catch (ClientDisconnectException e) {
            this._request.killKeepalive("client disconnect: " + e);
            this.clientDisconnect();
            if (this.isIgnoreClientDisconnect()) {
                log.fine(e.toString());
            }
            throw e;
        }
        catch (IOException e) {
            this._request.killKeepalive("client ioexception: " + e);
            this.clientDisconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRequest(boolean isClose) throws IOException {
        if (this._isClosed) {
            return;
        }
        try {
            AbstractHttpRequest request = this._request;
            try {
                request.skip();
            }
            catch (BadRequestException e) {
                log.warning(e.toString());
                log.log(Level.FINE, e.toString(), e);
            }
            catch (ClientDisconnectException e) {
                log.log(Level.FINER, e.toString(), e);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            this._isClosed = true;
        }
        finally {
            this._isClosed = true;
        }
    }

    protected void free() {
    }

    static {
        CACHE_CONTROL = new CharBuffer("cache-control");
        CONNECTION = new CharBuffer("connection");
        CONTENT_TYPE = new CharBuffer("content-type");
        CONTENT_LENGTH = new CharBuffer("content-length");
        DATE = new CharBuffer("date");
        SERVER = new CharBuffer("server");
        _contentTypeMap = new ConcurrentHashMap();
        _headerCodes = new CaseInsensitiveIntMap();
        _headerCodes.put("cache-control", 1);
        _headerCodes.put("connection", 6);
        _headerCodes.put("content-type", 2);
        _headerCodes.put("content-length", 3);
        _headerCodes.put("date", 4);
        _headerCodes.put("server", 5);
    }
}

