/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.network.listen.TcpSocketLink;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.HttpRequest;
import com.caucho.server.http.HttpResponseStream;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;

public class HttpResponse
extends AbstractHttpResponse {
    private static final Logger log = Logger.getLogger(HttpResponse.class.getName());
    private static final byte[] _http10ok = "HTTP/1.0 200 OK".getBytes();
    private static final byte[] _http11ok = "HTTP/1.1 200 OK".getBytes();
    private static final byte[] _contentLengthBytes = "\r\nContent-Length: ".getBytes();
    private static final byte[] _contentTypeBytes = "\r\nContent-Type: ".getBytes();
    private static final byte[] _textHtmlBytes = "\r\nContent-Type: text/html".getBytes();
    private static final byte[] _charsetBytes = "; charset=".getBytes();
    private static final byte[] _textHtmlLatin1Bytes = "\r\nContent-Type: text/html; charset=iso-8859-1".getBytes();
    private static final byte[] _connectionCloseBytes = "\r\nConnection: close".getBytes();
    private static final char[] _connectionCb = "Connection".toCharArray();
    private static final CharBuffer _closeCb = new CharBuffer("Close");
    private final byte[] _resinServerBytes;
    private final HttpRequest _request;
    private final CharBuffer _cb = new CharBuffer();
    private boolean _isChunked;
    private WriteStream _rawWrite;

    HttpResponse(HttpRequest request, WriteStream rawWrite) {
        super(request);
        this._request = request;
        this._rawWrite = rawWrite;
        ServletService server = request.getServer();
        this._resinServerBytes = ("\r\nServer: " + server.getServerHeader()).getBytes();
    }

    protected AbstractResponseStream createResponseStream() {
        HttpRequest request = (HttpRequest)this.getRequest();
        return new HttpResponseStream(this, request.getRawWrite());
    }

    boolean isChunkedEncoding() {
        return this._isChunked;
    }

    protected WriteStream getRawWrite() {
        return this._rawWrite;
    }

    protected void writeContinueInt() throws IOException {
        WriteStream os = this.getRawWrite();
        os.print("HTTP/1.1 100 Continue\r\n\r\n");
        os.flush();
    }

    protected boolean writeHeadersInt(int length, boolean isHead) throws IOException {
        String serverHeader;
        HttpServletRequestImpl request = this._request.getRequestFacade();
        HttpServletResponseImpl response = this._request.getResponseFacade();
        if (request == null) {
            return false;
        }
        this._isChunked = false;
        int version = this._request.getVersion();
        boolean debug = log.isLoggable(Level.FINE);
        if (version < 256) {
            this._request.killKeepalive("http client version " + version);
            return false;
        }
        TcpSocketLink tcpConn = null;
        if (this._request.getConnection() instanceof TcpSocketLink) {
            tcpConn = (TcpSocketLink)this._request.getConnection();
        }
        WebApp webApp = request.getWebApp();
        String contentType = response.getContentTypeImpl();
        String charEncoding = response.getCharacterEncodingImpl();
        WriteStream os = this.getRawWrite();
        long contentLength = this.getContentLengthHeader();
        int statusCode = response.getStatus();
        if (statusCode == 200) {
            if (version < 257) {
                os.write(_http10ok, 0, _http10ok.length);
            } else {
                os.write(_http11ok, 0, _http11ok.length);
            }
        } else {
            if (version < 257) {
                os.printLatin1("HTTP/1.0 ");
            } else {
                os.printLatin1("HTTP/1.1 ");
            }
            os.write(statusCode / 100 % 10 + 48);
            os.write(statusCode / 10 % 10 + 48);
            os.write(statusCode % 10 + 48);
            os.write(32);
            os.printLatin1(response.getStatusMessage());
        }
        if (debug) {
            log.fine(this._request.dbgId() + "HTTP/1.1 " + statusCode + " " + response.getStatusMessage());
        }
        boolean isUpgrade = false;
        if (tcpConn != null && tcpConn.isDuplex()) {
            isUpgrade = true;
            String upgrade = this.getHeader("Upgrade");
            if (upgrade != null) {
                os.printLatin1("\r\nUpgrade: ");
                os.printLatin1NoLf(upgrade);
            }
            os.printLatin1("\r\nConnection: Upgrade");
            this._request.killKeepalive("duplex/upgrade");
            if (debug) {
                log.fine(this._request.dbgId() + "Connection: Upgrade");
            }
        }
        if ((serverHeader = this.getServerHeader()) == null) {
            os.write(this._resinServerBytes, 0, this._resinServerBytes.length);
        } else {
            os.printLatin1("\r\nServer: ");
            os.printLatin1NoLf(serverHeader);
        }
        if (statusCode >= 400) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
        } else if (statusCode == 304 || statusCode == 204) {
            contentType = null;
        } else if (!response.isCacheControl()) {
            if (response.isNoCache()) {
                this.removeHeader("ETag");
                this.removeHeader("Last-Modified");
                this.setHeaderImpl("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
                os.printLatin1("\r\nCache-Control: no-cache");
                if (debug) {
                    log.fine(this._request.dbgId() + "" + "Cache-Control: no-cache");
                }
            } else if (response.isNoCacheUnlessVary() && !this.containsHeader("Vary")) {
                os.printLatin1("\r\nCache-Control: private");
                if (debug) {
                    log.fine(this._request.dbgId() + "Cache-Control: private");
                }
            } else if (response.isPrivateCache()) {
                if (257 <= version) {
                    os.printLatin1("\r\nCache-Control: private");
                    if (debug) {
                        log.fine(this._request.dbgId() + "Cache-Control: private");
                    }
                } else {
                    this.setHeaderImpl("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
                    os.printLatin1("\r\nCache-Control: no-cache");
                    if (debug) {
                        log.fine(this._request.dbgId() + "CacheControl: no-cache");
                    }
                }
            }
        }
        int size = this._headerKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)this._headerKeys.get(i);
            if (isUpgrade && "Upgrade".equalsIgnoreCase(key)) continue;
            os.write(13);
            os.write(10);
            os.printLatin1NoLf(key);
            os.write(58);
            os.write(32);
            os.printLatin1NoLf((String)this._headerValues.get(i));
            if (!debug) continue;
            log.fine(this._request.dbgId() + "" + key + ": " + (String)this._headerValues.get(i));
        }
        long now = CurrentTime.getCurrentTime();
        ArrayList<Cookie> cookiesOut = response.getCookies();
        if (cookiesOut != null) {
            for (int i = 0; i < cookiesOut.size(); ++i) {
                Cookie cookie = cookiesOut.get(i);
                int cookieVersion = cookie.getVersion();
                CharBuffer cb = this._cb;
                this.fillCookie(cb, cookie, now, cookieVersion, false);
                os.printLatin1("\r\nSet-Cookie: ");
                os.printLatin1(cb.getBuffer(), 0, cb.getLength());
                if (cookieVersion > 0) {
                    this.fillCookie(cb, cookie, now, cookieVersion, true);
                    os.printLatin1("\r\nSet-Cookie2: ");
                    os.printLatin1(cb.getBuffer(), 0, cb.getLength());
                }
                if (!debug) continue;
                log.fine(this._request.dbgId() + "Set-Cookie: " + cb);
            }
        }
        if (contentType != null) {
            if (charEncoding == null && contentType.startsWith("text/")) {
                if (webApp != null) {
                    charEncoding = webApp.getCharacterEncoding();
                }
                if (charEncoding == null) {
                    charEncoding = "utf-8";
                }
            }
            os.write(_contentTypeBytes, 0, _contentTypeBytes.length);
            os.printLatin1(contentType);
            if (charEncoding != null) {
                os.write(_charsetBytes, 0, _charsetBytes.length);
                os.printLatin1(charEncoding);
            }
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Type: " + contentType + "; charset=" + charEncoding);
            }
        }
        if (this.hasFooter()) {
            contentLength = -1L;
            length = -1;
        }
        boolean hasContentLength = false;
        if (contentLength >= 0L) {
            os.write(_contentLengthBytes, 0, _contentLengthBytes.length);
            os.print(contentLength);
            hasContentLength = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Length: " + contentLength);
            }
        } else if (statusCode == 304) {
            hasContentLength = true;
            this.setHead();
        } else if (statusCode == 204) {
            hasContentLength = true;
            os.write(_contentLengthBytes, 0, _contentLengthBytes.length);
            os.print(0);
            this.setHead();
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Length: 0");
            }
        } else if (length >= 0) {
            os.write(_contentLengthBytes, 0, _contentLengthBytes.length);
            os.print(length);
            hasContentLength = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Length: " + length);
            }
        }
        if (version < 257) {
            this._request.killKeepalive("http response version: " + version);
        } else if (!this._request.isKeepalive()) {
            if (isUpgrade) {
                this._request.killKeepalive("http response upgrade");
            } else {
                os.write(_connectionCloseBytes, 0, _connectionCloseBytes.length);
                if (debug) {
                    log.fine(this._request.dbgId() + "Connection: close");
                }
            }
        }
        if (257 <= version && !hasContentLength && !isHead) {
            os.printLatin1("\r\nTransfer-Encoding: chunked");
            this._isChunked = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Transfer-Encoding: chunked");
            }
        }
        byte[] dateBuffer = this.fillDateBuffer(now);
        int dateBufferLength = this.getDateBufferLength();
        if (this._isChunked) {
            os.write(dateBuffer, 0, dateBufferLength - 2);
        } else {
            os.write(dateBuffer, 0, dateBufferLength);
        }
        return this._isChunked;
    }

    public String toString() {
        return "HttpResponse" + this._request.dbgId();
    }
}

