/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.ResponseStream;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.SendfileOutputStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpResponseStream
extends ResponseStream
implements SendfileOutputStream {
    private static final L10N L = new L10N(HttpResponseStream.class);
    private static final Logger log = Logger.getLogger(HttpResponseStream.class.getName());
    private static final int _tailChunkedLength = 7;
    private static final byte[] _tailChunked = new byte[]{13, 10, 48, 13, 10, 13, 10};
    private HttpResponse _response;
    private WriteStream _nextStream;
    private boolean _isChunkedEncoding;
    private int _bufferStartOffset;

    HttpResponseStream(HttpResponse response, WriteStream next) {
        super(response);
        this._response = response;
        this._nextStream = next;
    }

    public boolean isClosed() {
        return super.isClosed() || this._nextStream.isClosed();
    }

    public void start() {
        super.start();
        this._isChunkedEncoding = false;
        this._bufferStartOffset = 0;
    }

    protected void writeHeaders(int length) throws IOException {
        super.writeHeaders(length);
        this._isChunkedEncoding = this._response.isChunkedEncoding();
    }

    protected byte[] getNextBuffer() {
        return this._nextStream.getBuffer();
    }

    protected int getNextStartOffset() {
        if (this._isChunkedEncoding && this._bufferStartOffset == 0) {
            this._bufferStartOffset = this._nextStream.getBufferOffset() + 8;
            this._nextStream.setBufferOffset(this._bufferStartOffset);
        }
        return this._bufferStartOffset;
    }

    protected int getNextBufferOffset() throws IOException {
        if (this._isChunkedEncoding && this._bufferStartOffset == 0) {
            this._bufferStartOffset = this._nextStream.getBufferOffset() + 8;
            this._nextStream.setBufferOffset(this._bufferStartOffset);
        }
        return this._nextStream.getBufferOffset();
    }

    protected void setNextBufferOffsetImpl(int offset) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.dbgId() + "write-set-offset(" + offset + ")");
        }
        this._nextStream.setBufferOffset(offset);
    }

    protected byte[] writeNextBufferImpl(int offset) throws IOException {
        WriteStream next = this._nextStream;
        int bufferStart = this._bufferStartOffset;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.dbgId() + "write-next-buffer(" + (offset - bufferStart) + ")");
        }
        if (bufferStart > 0) {
            byte[] buffer = next.getBuffer();
            int len = offset - bufferStart;
            if (len > 0) {
                this.writeChunkHeader(buffer, bufferStart, offset - bufferStart);
            } else {
                offset = bufferStart - 8;
            }
            this._bufferStartOffset = 0;
        }
        return next.nextBuffer(offset);
    }

    public void flushNextImpl() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "flush()");
        }
        if (this._bufferStartOffset > 0) {
            this._nextStream.setBufferOffset(this._bufferStartOffset - 8);
        }
        this._nextStream.flush();
        this._bufferStartOffset = 0;
    }

    protected void closeNextImpl() throws IOException {
        this._bufferStartOffset = 0;
        try {
            AbstractHttpRequest req = this._response.getRequest();
            if (!req.isCometActive() && !req.isDuplex()) {
                if (!req.isKeepalive()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this.dbgId() + "close stream");
                    }
                    this._nextStream.close();
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + "finish/keepalive");
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    protected void writeTailImpl(boolean isComplete) throws IOException {
        ArrayList<String> footerKeys;
        if (!this._isChunkedEncoding) {
            if (isComplete) {
                AbstractHttpRequest req = this._response.getRequest();
                if (req.isKeepalive()) {
                    this._nextStream.flushBuffer();
                } else {
                    this._nextStream.close();
                }
            } else {
                this._nextStream.flushBuffer();
            }
            return;
        }
        int bufferStart = this._bufferStartOffset;
        int bufferOffset = this._nextStream.getBufferOffset();
        if (bufferStart < bufferOffset && log.isLoggable(Level.FINER)) {
            log.finer(this.dbgId() + "write-tail(" + (bufferOffset - bufferStart) + ")");
        }
        if (bufferStart > 0) {
            byte[] buffer = this._nextStream.getBuffer();
            int len = bufferOffset - bufferStart;
            if (len > 0) {
                this.writeChunkHeader(buffer, bufferStart, len);
            } else {
                bufferOffset = bufferStart - 8;
            }
            this._bufferStartOffset = 0;
        }
        if ((footerKeys = this._response.getFooterKeys()).size() == 0) {
            this._nextStream.write(_tailChunked, 0, 7);
        } else {
            ArrayList<String> footerValues = this._response.getFooterValues();
            this._nextStream.print("\r\n0\r\n");
            for (int i = 0; i < footerKeys.size(); ++i) {
                this._nextStream.print(footerKeys.get(i));
                this._nextStream.print(": ");
                this._nextStream.print(footerValues.get(i));
                this._nextStream.print("\r\n");
            }
            this._nextStream.print("\r\n");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.dbgId() + "write-chunk-tail(" + 7 + ")");
        }
        this._nextStream.flush();
    }

    private void writeChunkHeader(byte[] buffer, int start, int length) throws IOException {
        if (length == 0) {
            throw new IllegalStateException();
        }
        buffer[start - 8] = 13;
        buffer[start - 7] = 10;
        buffer[start - 6] = HttpResponseStream.hexDigit(length >> 12);
        buffer[start - 5] = HttpResponseStream.hexDigit(length >> 8);
        buffer[start - 4] = HttpResponseStream.hexDigit(length >> 4);
        buffer[start - 3] = HttpResponseStream.hexDigit(length);
        buffer[start - 2] = 13;
        buffer[start - 1] = 10;
    }

    private static byte hexDigit(int value) {
        if ((value &= 0xF) <= 9) {
            return (byte)(48 + value);
        }
        return (byte)(97 + value - 10);
    }

    public boolean isMmapEnabled() {
        return this._nextStream.isMmapEnabled();
    }

    public boolean isSendfileEnabled() {
        return this._nextStream.isSendfileEnabled();
    }

    public void sendFile(Path path, long offset, long length) throws IOException {
        AbstractHttpRequest request = this._response.getRequest();
        WebApp webApp = request.getWebApp();
        if (!this.isSendfileEnabled() || !webApp.isSendfileEnabled() || request.getResponseFacade().isCaching() && length < webApp.getSendfileMinLength()) {
            path.writeToStream(this);
            return;
        }
        webApp.addSendfileCount();
        path.sendfile(this, offset, length);
    }

    public void writeMmap(long mmapAddress, long[] mmapBlocks, long mmapOffset, long mmapLength) throws IOException {
        if (this._isChunkedEncoding) {
            throw new IllegalStateException(L.l("writeMmap cannot use chunked"));
        }
        this.flushBuffer();
        this._nextStream.writeMmap(mmapAddress, mmapBlocks, mmapOffset, mmapLength);
    }

    public void writeSendfile(byte[] fileName, int nameLength, long fileLength) throws IOException {
        if (this._isChunkedEncoding) {
            throw new IllegalStateException(L.l("writeSendfile cannot use chunked"));
        }
        this.flushBuffer();
        this._nextStream.writeSendfile(fileName, nameLength, fileLength);
    }
}

