/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.rewrite.DispatchRule;
import com.caucho.rewrite.RewriteFilter;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.rewrite.MatchRule;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

public class RewriteDispatch {
    private static final L10N L = new L10N(RewriteDispatch.class);
    private static final Logger log = Logger.getLogger(RewriteDispatch.class.getName());
    private final WebApp _webApp;
    private final ServletService _server;
    private HashSet<String> _dispatcherTypes = new HashSet();
    private MatchRule _matchRule;
    private ContainerProgram _program = new ContainerProgram();
    private ArrayList<DispatchRule> _ruleList = new ArrayList();
    private ArrayList<RewriteFilter> _filterList = new ArrayList();
    private final boolean _isFiner;
    private final boolean _isFinest;

    public RewriteDispatch(ServletService server) {
        this(server, null);
    }

    public RewriteDispatch(WebApp webApp) {
        this(null, webApp);
    }

    private RewriteDispatch(ServletService server, WebApp webApp) {
        this._server = server;
        this._webApp = webApp;
        this._isFiner = log.isLoggable(Level.FINER);
        this._isFinest = log.isLoggable(Level.FINEST);
    }

    public WebApp getWebApp() {
        return this._webApp;
    }

    public void addDispatcherType(String type) {
        if (!("REQUEST".equals(type) || "FORWARD".equals(type) || "INCLUDE".equals(type))) {
            throw new ConfigException(L.l("'{0} is an unknown dispatcher-type.  Valid types are 'REQUEST', 'FORWARD', and 'INCLUDE'", (Object)type));
        }
        this._dispatcherTypes.add(type);
    }

    public boolean isRequest() {
        return this._dispatcherTypes.contains("REQUEST") || this._dispatcherTypes.size() == 0;
    }

    public boolean isInclude() {
        return this._dispatcherTypes.contains("INCLUDE");
    }

    public boolean isForward() {
        return this._dispatcherTypes.contains("FORWARD");
    }

    public boolean isError() {
        return this._dispatcherTypes.contains("ERROR");
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public void addRule(DispatchRule rule) {
        this._ruleList.add(rule);
    }

    public void addAction(RewriteFilter action) {
        this._filterList.add(action);
    }

    @PostConstruct
    public void init() {
        this._matchRule = new MatchRule(this);
        this._matchRule.setRegexp(Pattern.compile(".*"));
        this._program.configure(this._matchRule);
        this._matchRule.init();
    }

    public FilterChain map(DispatcherType type, String uri, String queryString, FilterChain chain) {
        try {
            if (this._isFinest) {
                log.finest("rewrite-dispatch check uri '" + uri + "'");
            }
            if (this._matchRule != null) {
                chain = this._matchRule.map(uri, queryString, chain);
            }
            chain = this.mapChain(0, type, uri, queryString, chain);
            for (int i = this._filterList.size() - 1; i >= 0; --i) {
                chain = this._filterList.get(i).map(uri, queryString, chain);
            }
            return chain;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private FilterChain mapChain(int index, DispatcherType type, String uri, String queryString, FilterChain chain) throws ServletException {
        FilterChain next = chain;
        int size = this._ruleList.size();
        if (size <= index) {
            return next;
        }
        DispatchRule firstRule = this._ruleList.get(index);
        uri = firstRule.rewriteUri(uri, queryString);
        for (int tail = index + 1; tail < size; ++tail) {
            DispatchRule uriRule = this._ruleList.get(tail);
            String newUri = uriRule.rewriteUri(uri, queryString);
            if (newUri == uri) continue;
            next = this.mapChain(tail, type, uri, queryString, chain);
            break;
        }
        for (int i = tail - 1; index <= i; --i) {
            DispatchRule rule = this._ruleList.get(i);
            next = rule.map(type, uri, queryString, next, chain);
        }
        return next;
    }

    public void clearCache() {
        if (this._webApp != null) {
            this._webApp.clearCache();
        } else if (this._server != null) {
            this._server.clearCache();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

