/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.spdy;

import com.caucho.server.spdy.SpdyConnection;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

class SpdyStream {
    private final int _clientId;
    private final int _serverId;
    private SpdyConnection _conn;
    private ReadStream _is;
    private WriteStream _os;

    SpdyStream(SpdyConnection conn, int clientId, int serverId, ReadStream is, WriteStream os) {
        this._conn = conn;
        this._clientId = clientId;
        this._serverId = serverId;
        this._is = is;
        this._os = os;
    }

    int getClientId() {
        return this._clientId;
    }

    int readHeaderInt() throws IOException {
        ReadStream is = this._is;
        int ch1 = is.read();
        int ch2 = is.read();
        int ch3 = is.read();
        int ch4 = is.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    String readHeaderString(int len) throws IOException {
        ReadStream is = this._is;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = (char)is.read();
            sb.append(ch);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._conn + "," + this._clientId + "]";
    }
}

