/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.CauchoDispatchRequest;
import com.caucho.server.webapp.ForwardResponse;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharSegment;
import com.caucho.util.HashMapImpl;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardRequest
extends CauchoDispatchRequest {
    private static final IntMap _forwardAttributeMap = new IntMap();
    private static final L10N L = new L10N(ForwardRequest.class);
    private static final int REQUEST_URI_CODE = 1;
    private static final int CONTEXT_PATH_CODE = 2;
    private static final int SERVLET_PATH_CODE = 3;
    private static final int PATH_INFO_CODE = 4;
    private static final int QUERY_STRING_CODE = 5;
    private Invocation _invocation;
    private ForwardResponse _response;
    private HashMapImpl<String, String[]> _fwdFilledForm;

    public ForwardRequest() {
        this._response = new ForwardResponse(this);
    }

    public ForwardRequest(HttpServletRequest request, HttpServletResponse response, Invocation invocation) {
        super(request);
        this._response = new ForwardResponse(this, response);
        this.setResponse(this._response);
        this._invocation = invocation;
    }

    @Override
    protected Invocation getInvocation() {
        return this._invocation;
    }

    void startRequest() {
        this._response.startRequest();
    }

    void finishRequest(boolean isValid) throws IOException {
        this.finishRequest();
        if (isValid) {
            this._response.finishRequest();
        }
    }

    @Override
    public ForwardResponse getResponse() {
        return this._response;
    }

    @Override
    public ServletContext getServletContext() {
        return this._invocation.getWebApp();
    }

    @Override
    public DispatcherType getDispatcherType() {
        return DispatcherType.FORWARD;
    }

    @Override
    public String getRequestURI() {
        return this._invocation.getURI();
    }

    @Override
    public String getContextPath() {
        return this._invocation.getContextPath();
    }

    @Override
    public String getServletPath() {
        return this._invocation.getServletPath();
    }

    @Override
    public String getPathInfo() {
        return this._invocation.getPathInfo();
    }

    @Override
    public String getQueryString() {
        return this.calculateQueryString();
    }

    protected String calculateQueryString() {
        String queryString = this._invocation.getQueryString();
        if (queryString != null) {
            return queryString;
        }
        return this.getRequest().getQueryString();
    }

    @Override
    public String getPageURI() {
        return this._invocation.getURI();
    }

    @Override
    public String getPageContextPath() {
        return this._invocation.getContextPath();
    }

    @Override
    public String getPageServletPath() {
        return this._invocation.getServletPath();
    }

    @Override
    public String getPagePathInfo() {
        return this._invocation.getPathInfo();
    }

    @Override
    public String getPageQueryString() {
        return this.getQueryString();
    }

    @Override
    public WebApp getWebApp() {
        return this._invocation.getWebApp();
    }

    @Override
    public boolean isAsyncSupported() {
        return this._invocation.isAsyncSupported() && this.getRequest().isAsyncSupported();
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException(L.l("The servlet '{0}' at '{1}' does not support async because the servlet or one of the filters does not support asynchronous mode.", (Object)this.getServletName(), (Object)this.getServletPath()));
        }
        return super.startAsync();
    }

    public String getServletName() {
        if (this._invocation != null) {
            return this._invocation.getServletName();
        }
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        switch (_forwardAttributeMap.get(name)) {
            case 1: {
                return this.unwrapRequest().getRequestURI();
            }
            case 2: {
                return this.unwrapRequest().getContextPath();
            }
            case 3: {
                return this.unwrapRequest().getServletPath();
            }
            case 4: {
                return this.unwrapRequest().getPathInfo();
            }
            case 5: {
                return this.unwrapRequest().getQueryString();
            }
        }
        return super.getAttribute(name);
    }

    public HttpServletRequest unwrapRequest() {
        HttpServletRequest request = this.getRequest();
        while (request instanceof ForwardRequest) {
            request = ((ForwardRequest)request).getRequest();
        }
        return request;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (this._fwdFilledForm == null) {
            this._fwdFilledForm = this.parseQuery();
        }
        return Collections.enumeration(this._fwdFilledForm.keySet());
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this._fwdFilledForm == null) {
            this._fwdFilledForm = this.parseQuery();
        }
        return Collections.unmodifiableMap(this._fwdFilledForm);
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this._fwdFilledForm == null) {
            this._fwdFilledForm = this.parseQuery();
        }
        return this._fwdFilledForm.get(name);
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    private HashMapImpl<String, String[]> parseQuery() {
        HashMapImpl<String, String[]> form = new HashMapImpl<String, String[]>();
        Map<String, String[]> map = this.getParameterMapImpl();
        form.putAll(map);
        map = this.getRequest().getParameterMap();
        this.mergeParameters(map, form);
        return form;
    }

    @Override
    protected void parsePostQueryImpl(HashMapImpl<String, String[]> form) {
        AbstractHttpRequest request = this.getAbstractHttpRequest();
        if (request == null) {
            return;
        }
        CharSegment contentType = request.getContentTypeBuffer();
        if (contentType == null || !"POST".equalsIgnoreCase(this.getMethod())) {
            return;
        }
        if (this.getWebApp().isMultipartFormEnabled()) {
            return;
        }
        Invocation invocation = this.getInvocation();
        MultipartConfigElement multipartConfig = invocation.getMultipartConfig();
        if ((this.getWebApp().isMultipartFormEnabled() || multipartConfig != null) && contentType.startsWith("multipart/form-data")) {
            super.parsePostQueryImpl(form);
        }
    }

    static {
        _forwardAttributeMap.put("javax.servlet.forward.request_uri", 1);
        _forwardAttributeMap.put("javax.servlet.forward.context_path", 2);
        _forwardAttributeMap.put("javax.servlet.forward.servlet_path", 3);
        _forwardAttributeMap.put("javax.servlet.forward.path_info", 4);
        _forwardAttributeMap.put("javax.servlet.forward.query_string", 5);
    }
}

