/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ToByteResponseStream;
import com.caucho.server.httpcache.AbstractCacheEntry;
import com.caucho.server.httpcache.AbstractCacheFilterChain;
import com.caucho.server.webapp.IncludeResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeResponseStream2
extends ToByteResponseStream {
    private static final Logger log = Logger.getLogger(IncludeResponseStream2.class.getName());
    private final IncludeResponse _response;
    private AbstractResponseStream _stream;
    private ServletOutputStream _os;
    private PrintWriter _writer;
    private OutputStream _cacheStream;
    private Writer _cacheWriter;
    private boolean _isCommitted;
    private ArrayList<String> _headerKeys = new ArrayList();
    private ArrayList<String> _headerValues = new ArrayList();

    IncludeResponseStream2(IncludeResponse response) {
        if (response == null) {
            throw new NullPointerException();
        }
        this._response = response;
    }

    @Override
    public void start() {
        CauchoResponse cNext;
        if (this._os != null || this._writer != null) {
            throw new IllegalStateException();
        }
        ServletResponse next = this._response.getResponse();
        if (next == null) {
            throw new NullPointerException();
        }
        if (next instanceof CauchoResponse && (cNext = (CauchoResponse)next).isCauchoResponseStream()) {
            this._stream = cNext.getResponseStream();
        }
        this._isCommitted = false;
        this._headerKeys.clear();
        this._headerValues.clear();
        super.start();
        try {
            this.setEncoding(next.getCharacterEncoding());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public boolean isCauchoResponseStream() {
        return this._stream != null;
    }

    void addHeader(String key, String value) {
        this._headerKeys.add(key);
        this._headerValues.add(value);
    }

    List<String> getHeaderKeys() {
        return this._headerKeys;
    }

    List<String> getHeaderValues() {
        return this._headerValues;
    }

    @Override
    public void setByteCacheStream(OutputStream cacheStream) {
        this._cacheStream = cacheStream;
    }

    @Override
    public void setCharCacheStream(Writer cacheWriter) {
        this._cacheWriter = cacheWriter;
    }

    @Override
    public Writer getCharCacheStream() {
        return this._cacheWriter;
    }

    @Override
    protected void flushCharBuffer() throws IOException {
        int charLength = this.getCharOffset();
        if (charLength == 0) {
            return;
        }
        if (this._stream != null) {
            super.flushCharBuffer();
            return;
        }
        this.setCharOffset(0);
        char[] buffer = this.getCharBuffer();
        this.startCaching(false);
        this.getWriter().write(buffer, 0, charLength);
        if (this._cacheWriter != null) {
            this._cacheWriter.write(buffer, 0, charLength);
        }
    }

    @Override
    public void setBufferOffset(int offset) throws IOException {
        super.setBufferOffset(offset);
        if (this._stream == null) {
            this.flushByteBuffer();
        }
    }

    @Override
    public byte[] nextBuffer(int offset) throws IOException {
        super.nextBuffer(offset);
        if (this._stream == null) {
            this.flushByteBuffer();
        }
        return this.getBuffer();
    }

    @Override
    public void write(int ch) throws IOException {
        this.flushCharBuffer();
        if (this._stream != null) {
            super.write(ch);
        } else {
            this.getOutputStream().write(ch);
        }
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        this.flushCharBuffer();
        if (this._cacheStream != null) {
            this._cacheStream.write(buf, offset, length);
        }
        if (this._cacheWriter != null) {
            // empty if block
        }
        if (this._stream != null) {
            super.write(buf, offset, length);
        } else {
            this.getOutputStream().write(buf, offset, length);
        }
    }

    @Override
    protected void writeHeaders(int length) {
        this.startCaching(true);
    }

    @Override
    protected void writeNext(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (length == 0) {
            return;
        }
        if (this._cacheStream != null) {
            this._cacheStream.write(buf, offset, length);
        }
        if (this._stream != null) {
            this._stream.write(buf, offset, length);
        } else {
            this.getOutputStream().write(buf, offset, length);
        }
    }

    protected void startCaching(boolean isByte) {
        if (this._isCommitted) {
            return;
        }
        this._isCommitted = true;
        AbstractCacheFilterChain cacheInvocation = this._response.getCacheInvocation();
        if (cacheInvocation == null) {
            return;
        }
        String contentType = null;
        String charEncoding = null;
        int contentLength = -1;
        AbstractCacheEntry cacheEntry = cacheInvocation.startCaching(this._response.getRequest(), this._response, this._headerKeys, this._headerValues, contentType, charEncoding, contentLength);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setForwardEnclosed(this._response.isForwardEnclosed());
        if (isByte) {
            this._cacheStream = cacheEntry.openOutputStream();
        } else {
            this._cacheWriter = cacheEntry.openWriter();
        }
    }

    @Override
    public void flushByte() throws IOException {
        this.flushBuffer();
        this.getOutputStream().flush();
    }

    @Override
    public void flushChar() throws IOException {
        this.flushBuffer();
        this.getWriter().flush();
    }

    private OutputStream getOutputStream() throws IOException {
        if (this._os == null) {
            this._os = this._response.getResponse().getOutputStream();
        }
        return this._os;
    }

    private Writer getWriter() throws IOException {
        if (this._writer == null) {
            this._writer = this._response.getResponse().getWriter();
        }
        return this._writer;
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.flushBuffer();
        this.closeCache();
        this._stream = null;
        this._os = null;
        this._writer = null;
        this._cacheStream = null;
        this._cacheWriter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeCache() {
        AbstractCacheFilterChain cache = this._response.getCacheInvocation();
        try {
            block9: {
                try {
                    this.flushBuffer();
                    OutputStream cacheStream = this._cacheStream;
                    this._cacheStream = null;
                    Writer cacheWriter = this.getCharCacheStream();
                    this.setCharCacheStream(null);
                    if (cacheStream != null) {
                        cacheStream.close();
                    }
                    if (cacheWriter != null) {
                        cacheWriter.close();
                    }
                    if (cache == null) break block9;
                    cache.finishCaching(this._response);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var5_6 = null;
                    if (cache != null) {
                        cache.killCaching(this._response);
                    }
                }
            }
            Object var5_5 = null;
            if (cache != null) {
                cache.killCaching(this._response);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (cache != null) {
                cache.killCaching(this._response);
            }
            throw throwable;
        }
    }

    private void closeCache() throws IOException {
        AbstractCacheFilterChain cache = this._response.getCacheInvocation();
        OutputStream cacheStream = this._cacheStream;
        this._cacheStream = null;
        Writer cacheWriter = this.getCharCacheStream();
        this.setCharCacheStream(null);
        if (cacheStream != null) {
            cacheStream.close();
        }
        if (cacheWriter != null) {
            cacheWriter.close();
        }
        if (cache != null) {
            cache.killCaching(this._response);
        }
    }
}

