/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.DescriptionGroupConfig;
import com.caucho.util.L10N;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configurable
public class ListenerConfig<T>
extends DescriptionGroupConfig {
    static L10N L = new L10N(ListenerConfig.class);
    private Class<T> _listenerClass;
    private T _object;
    private InjectionTarget<T> _target;
    private ContainerProgram _init;

    public void setListenerClass(Class<T> cl) throws ConfigException {
        Config.checkCanInstantiate(cl);
        if (!(ServletContextListener.class.isAssignableFrom(cl) || ServletContextAttributeListener.class.isAssignableFrom(cl) || ServletRequestListener.class.isAssignableFrom(cl) || ServletRequestAttributeListener.class.isAssignableFrom(cl) || HttpSessionListener.class.isAssignableFrom(cl) || HttpSessionAttributeListener.class.isAssignableFrom(cl) || HttpSessionActivationListener.class.isAssignableFrom(cl))) {
            throw new ConfigException(L.l("listener-class '{0}' does not implement any web-app listener interface.", (Object)cl.getName()));
        }
        this._listenerClass = cl;
    }

    public Class<?> getListenerClass() {
        return this._listenerClass;
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    public Object createListenerObject() throws Exception {
        if (this._object != null) {
            return this._object;
        }
        InjectManager cdiManager = InjectManager.create();
        this._target = cdiManager.discoverInjectionTarget(this._listenerClass);
        CreationalContext env = cdiManager.createCreationalContext(null);
        this._object = this._target.produce(env);
        this._target.inject(this._object, env);
        if (this._init != null) {
            this._init.configure(this._object);
            this._init.init(this._object);
        }
        this._target.postConstruct(this._object);
        return this._object;
    }

    public void destroy() {
        if (this._target != null) {
            this._target.preDestroy(this._object);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._listenerClass + "]";
    }
}

