/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.util.L10N;
import java.security.Principal;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceContextProxy
implements WebServiceContext {
    private static final L10N L = new L10N(WebServiceContextProxy.class);
    private static final ThreadLocal<WebServiceContext> _localContext = new ThreadLocal();

    public static WebServiceContext setContext(WebServiceContext context) {
        WebServiceContext oldContext = _localContext.get();
        _localContext.set(context);
        return oldContext;
    }

    @Override
    public MessageContext getMessageContext() {
        return this.getContext().getMessageContext();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.getContext().getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.getContext().isUserInRole(role);
    }

    @Override
    public EndpointReference getEndpointReference(Element ... arg0) {
        return this.getContext().getEndpointReference(arg0);
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> arg0, Element ... arg1) {
        return this.getContext().getEndpointReference(arg0, arg1);
    }

    private WebServiceContext getContext() {
        WebServiceContext context = _localContext.get();
        if (context != null) {
            return context;
        }
        throw new IllegalStateException(L.l("WebServiceContext is not available here"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + _localContext.get() + "]";
    }
}

