/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.cloud.loadbalance.LoadBalanceBuilder;
import com.caucho.cloud.loadbalance.LoadBalanceManager;
import com.caucho.cloud.loadbalance.LoadBalanceService;
import com.caucho.config.types.Period;
import com.caucho.network.balance.ClientSocket;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpProxyServlet
extends GenericServlet {
    private static final Logger log = Logger.getLogger(HttpProxyServlet.class.getName());
    private static final L10N L = new L10N(HttpProxyServlet.class);
    private LoadBalanceBuilder _loadBalanceBuilder;
    private LoadBalanceManager _loadBalancer;

    public HttpProxyServlet() {
        LoadBalanceService loadBalanceService = LoadBalanceService.getCurrent();
        if (loadBalanceService == null) {
            throw new IllegalStateException(L.l("'{0}' requires an active {1}", (Object)this, (Object)LoadBalanceService.class.getSimpleName()));
        }
        this._loadBalanceBuilder = loadBalanceService.createBuilder();
    }

    public void addAddress(String address) {
        this._loadBalanceBuilder.addAddress(address);
    }

    public void addHost(String host) {
        this.addAddress(host);
    }

    public void setFailRecoverTime(Period period) {
    }

    public void init() throws ServletException {
        this._loadBalancer = this._loadBalanceBuilder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        CauchoRequest cReq = null;
        if (req instanceof CauchoRequest) {
            cReq = (CauchoRequest)req;
        }
        String sessionId = req.getRequestedSessionId();
        String uri = req.isRequestedSessionIdFromURL() ? req.getRequestURI() + ";jsessionid=" + req.getRequestedSessionId() : req.getRequestURI();
        String queryString = null;
        if (cReq != null) {
            queryString = cReq.getPageQueryString();
        } else {
            queryString = (String)req.getAttribute("javax.servlet.include.query_string");
            if (queryString == null) {
                queryString = req.getQueryString();
            }
        }
        if (queryString != null) {
            uri = uri + '?' + queryString;
        }
        ClientSocket stream = this._loadBalancer.openSticky(sessionId, request, null);
        try {
            long startRequestTime = CurrentTime.getCurrentTime();
            if (stream == null) {
                log.warning(L.l("{0}: no backend servers available to process {1}", (Object)this, (Object)req.getRequestURI()));
                res.sendError(503);
            } else if (this.handleRequest(req, res, uri, stream)) {
                stream.free(startRequestTime);
                stream = null;
                Object var13_11 = null;
                if (stream != null) {
                    stream.close();
                }
                return;
            }
            Object var13_12 = null;
            if (stream != null) {
                stream.close();
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (stream != null) {
                stream.close();
            }
            throw throwable;
        }
    }

    private boolean handleRequest(HttpServletRequest req, HttpServletResponse res, String uri, ClientSocket stream) throws ServletException, IOException {
        ReadStream rs = stream.getInputStream();
        WriteStream out = stream.getOutputStream();
        try {
            int len;
            out.print(req.getMethod());
            out.print(' ');
            out.print(uri);
            out.print(" HTTP/1.1\r\n");
            out.print("Host: ");
            String host = req.getHeader("Host");
            if (host == null) {
                host = req.getServerName() + ":" + req.getServerPort();
            }
            out.print(host);
            out.print("\r\n");
            out.print("X-Forwarded-For: ");
            out.print(req.getRemoteAddr());
            out.print("\r\n");
            Enumeration<String> e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if (name.equalsIgnoreCase("Connection") || name.equalsIgnoreCase("Host")) continue;
                Enumeration<String> e1 = req.getHeaders(name);
                while (e1.hasMoreElements()) {
                    String value = e1.nextElement();
                    out.print(name);
                    out.print(": ");
                    out.print(value);
                    out.print("\r\n");
                }
            }
            int contentLength = req.getContentLength();
            ServletInputStream is = req.getInputStream();
            TempBuffer tempBuffer = TempBuffer.allocate();
            byte[] buffer = tempBuffer.getBuffer();
            boolean isFirst = true;
            if (contentLength >= 0) {
                isFirst = false;
                out.print("\r\n");
            }
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                if (isFirst) {
                    out.print("Transfer-Encoding: chunked\r\n");
                }
                if (contentLength < 0) {
                    out.print("\r\n");
                    out.print(Integer.toHexString(len));
                    out.print("\r\n");
                }
                out.write(buffer, 0, len);
                isFirst = false;
            }
            if (isFirst) {
                out.print("Content-Length: 0\r\n\r\n");
            } else if (contentLength < 0) {
                out.print("\r\n0\r\n");
            }
            TempBuffer.free(tempBuffer);
            out.flush();
            return this.parseResults(rs, req, res);
        }
        catch (IOException e1) {
            log.log(Level.FINE, e1.toString(), e1);
            return false;
        }
    }

    private boolean parseResults(ReadStream is, HttpServletRequest req, HttpServletResponse res) throws IOException {
        int p;
        String line = this.parseStatus(is);
        boolean isKeepalive = true;
        if (!line.startsWith("HTTP/1.1")) {
            isKeepalive = false;
        }
        int statusCode = this.parseStatusCode(line);
        String location = null;
        boolean isChunked = false;
        int contentLength = -1;
        while ((line = is.readLine()) != null && (p = line.indexOf(58)) >= 0) {
            String name = line.substring(0, p);
            String value = line.substring(p + 1).trim();
            if (name.equalsIgnoreCase("transfer-encoding")) {
                isChunked = true;
                continue;
            }
            if (name.equalsIgnoreCase("content-length")) {
                contentLength = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("location")) {
                location = value;
                continue;
            }
            if (name.equalsIgnoreCase("connection")) {
                if (!"close".equalsIgnoreCase(value)) continue;
                isKeepalive = false;
                continue;
            }
            res.addHeader(name, value);
        }
        if (location == null) {
            // empty if block
        }
        if (location != null) {
            res.setHeader("Location", location);
        }
        if (statusCode == 302 && location != null) {
            res.sendRedirect(location);
        } else if (statusCode != 200) {
            res.setStatus(statusCode);
        }
        ServletOutputStream os = res.getOutputStream();
        if (isChunked) {
            this.writeChunkedData(os, is);
        } else if (contentLength > 0) {
            res.setContentLength(contentLength);
            this.writeContentLength(os, is, contentLength);
        }
        return isKeepalive;
    }

    private String parseStatus(ReadStream is) throws IOException {
        int ch = is.read();
        while (Character.isWhitespace(ch)) {
            ch = is.read();
        }
        StringBuilder sb = new StringBuilder();
        while (ch >= 0 && ch != 10) {
            if (ch != 13) {
                sb.append((char)ch);
            }
            ch = is.read();
        }
        return sb.toString();
    }

    private int parseStatusCode(String line) {
        char ch;
        int i;
        int len = line.length();
        for (i = 0; i < len && (ch = line.charAt(i)) != ' '; ++i) {
        }
        while (i < len && (ch = line.charAt(i)) == ' ') {
            ++i;
        }
        int statusCode = 0;
        while (i < len && '0' <= (ch = line.charAt(i)) && ch <= '9') {
            statusCode = 10 * statusCode + ch - 48;
            ++i;
        }
        if (statusCode == 0) {
            return 400;
        }
        return statusCode;
    }

    private void writeChunkedData(OutputStream os, ReadStream is) throws IOException {
        int ch;
        while (true) {
            ch = is.read();
            while (Character.isWhitespace(ch)) {
                ch = is.read();
            }
            int len = 0;
            while (ch >= 0) {
                if (48 <= ch && ch <= 57) {
                    len = 16 * len + ch - 48;
                } else if (97 <= ch && ch <= 102) {
                    len = 16 * len + ch - 97 + 10;
                } else {
                    if (65 > ch || ch > 70) break;
                    len = 16 * len + ch - 65 + 10;
                }
                ch = is.read();
            }
            if (ch == 13) {
                ch = is.read();
            }
            if (ch != 10) {
                throw new IllegalStateException(L.l("unexpected chunking at '{0}'", (char)ch));
            }
            if (len == 0) break;
            is.writeToStream(os, len);
        }
        ch = is.read();
        if (ch == 13) {
            ch = is.read();
        }
    }

    private void writeContentLength(OutputStream os, ReadStream is, int length) throws IOException {
        is.writeToStream(os, length);
    }
}

