/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.naming;

import com.caucho.servlets.naming.NamingProxy;
import com.caucho.servlets.naming.RemoteContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RemoteJndiService
implements NamingProxy {
    private static final Logger log = Logger.getLogger(RemoteJndiService.class.getName());
    private String _jndiPath;

    public void setJndiPath(String jndiPath) {
        this._jndiPath = jndiPath;
    }

    public Object lookup(String name) {
        try {
            InitialContext ic;
            Object v;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((v = (ic = new InitialContext()).lookup(this._jndiPath)) == null || name.equals("")) {
                return v;
            }
            if (v instanceof Context) {
                v = ((Context)v).lookup(name);
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " lookup '" + name + "' -> " + v);
            }
            if (v instanceof Context) {
                return new RemoteContext(name);
            }
            return v;
        }
        catch (NamingException e) {
            e.printStackTrace();
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }
}

