/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.ConnectionConfig;
import com.caucho.sql.Credential;
import com.caucho.sql.DBPoolImpl;
import com.caucho.sql.DisjointXAResource;
import com.caucho.sql.DriverConfig;
import com.caucho.sql.ManagedFactoryImpl;
import com.caucho.sql.PreparedStatementCacheItem;
import com.caucho.sql.PreparedStatementKey;
import com.caucho.sql.UserConnection;
import com.caucho.sql.UserPreparedStatement;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.sql.spy.SpyXAResource;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.sql.ConnectionEvent;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConnectionImpl
implements ManagedConnection,
javax.sql.ConnectionEventListener {
    protected static final Logger log = Logger.getLogger(ManagedConnectionImpl.class.getName());
    protected static L10N L = new L10N(ManagedConnectionImpl.class);
    private final String _id;
    private final ManagedFactoryImpl _factory;
    private final DBPoolImpl _dbPool;
    private final DriverConfig _driver;
    private final ConnectionConfig _connConfig;
    private final Credential _credentials;
    private PooledConnection _pooledConnection;
    private Connection _driverConnection;
    private XAResource _xaResource;
    private LocalTransaction _localTransaction;
    private ConnectionEventListener _listener;
    private javax.resource.spi.ConnectionEvent _connClosedEvent;
    private ResourceException _connException;
    private long _lastEventTime;
    private LruCache<PreparedStatementKey, PreparedStatementCacheItem> _preparedStatementCache;
    private PreparedStatementKey _key;
    private int _isolation = -1;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private boolean _hasCatalog;
    private String _catalogOrig = null;
    private String _catalog = null;
    private int _oldIsolation = -1;
    private Map<String, Class<?>> _typeMap;
    private boolean _isPingRequired;
    private boolean _isPastActiveTime;

    ManagedConnectionImpl(ManagedFactoryImpl factory, DriverConfig driver, ConnectionConfig connConfig, Credential credentials) throws SQLException {
        this._factory = factory;
        this._dbPool = factory.getDBPool();
        this._id = this._dbPool.newSpyId(driver);
        this._driver = driver;
        this._connConfig = connConfig;
        this._credentials = credentials;
        this._connClosedEvent = new javax.resource.spi.ConnectionEvent(this, 1);
        this.initDriverConnection();
        this._lastEventTime = CurrentTime.getCurrentTime();
        int preparedStatementCacheSize = this._dbPool.getPreparedStatementCacheSize();
        if (preparedStatementCacheSize > 0) {
            this._preparedStatementCache = new LruCache(preparedStatementCacheSize);
            this._key = new PreparedStatementKey();
        }
    }

    DBPoolImpl getDBPool() {
        return this._dbPool;
    }

    Credential getCredentials() {
        return this._credentials;
    }

    public boolean isClosed() {
        try {
            if (this._driverConnection != null) {
                return this._driverConnection.isClosed();
            }
            return false;
        }
        catch (SQLException e) {
            log.log(Level.FINEST, e.toString(), e);
            return true;
        }
    }

    boolean isWrapStatements() {
        return this._dbPool.isWrapStatements();
    }

    @Override
    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (this._connException != null) {
            throw this._connException;
        }
        if (!this.ping()) {
            return null;
        }
        this._lastEventTime = CurrentTime.getCurrentTime();
        return new UserConnection(this);
    }

    @Override
    public void associateConnection(Object connection) throws ResourceException {
        this._lastEventTime = CurrentTime.getCurrentTime();
        UserConnection uConn = (UserConnection)connection;
        uConn.associate(this);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this._listener != null && this._listener != listener) {
            throw new IllegalStateException();
        }
        this._listener = listener;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this._listener == listener) {
            this._listener = null;
        }
    }

    private void initDriverConnection() throws SQLException {
        String configCatalog;
        int isolation;
        if (this._driverConnection != null) {
            throw new IllegalStateException();
        }
        String user = this._driver.getUser();
        String password = this._driver.getPassword();
        if (this._credentials != null) {
            user = this._credentials.getUserName();
            password = this._credentials.getPassword();
        }
        this._pooledConnection = this._driver.createPooledConnection(user, password);
        if (this._pooledConnection != null) {
            this._pooledConnection.addConnectionEventListener(this);
            this._driverConnection = this._pooledConnection.getConnection();
        }
        if (this._driverConnection == null) {
            this._driverConnection = this._driver.createDriverConnection(user, password);
        }
        if (this._driverConnection == null) {
            throw new SQLException(L.l("Failed to create driver connection for {0}.", (Object)this._driver));
        }
        DBPoolImpl dbPool = this.getDBPool();
        long transactionTimeout = dbPool.getTransactionTimeout();
        if (dbPool.isXA() && !this._connConfig.isReadOnly()) {
            if (this._pooledConnection instanceof XAConnection) {
                try {
                    this._xaResource = ((XAConnection)this._pooledConnection).getXAResource();
                }
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            if (this._xaResource != null && dbPool.isXAForbidSameRM()) {
                this._xaResource = new DisjointXAResource(this._xaResource);
            }
            if (transactionTimeout > 0L && this._xaResource != null) {
                try {
                    this._xaResource.setTransactionTimeout((int)(transactionTimeout / 1000L));
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            boolean allowLocalTransaction = true;
            String className = "";
            if (this._pooledConnection != null) {
                className = this._pooledConnection.getClass().getName();
            }
            if (this._pooledConnection instanceof XAConnection) {
                if (className.startsWith("oracle")) {
                    allowLocalTransaction = false;
                } else if (className.equals("com.mysql.jdbc.jdbc2.optional.MysqlXAConnection")) {
                    allowLocalTransaction = false;
                }
            }
            if (allowLocalTransaction) {
                this._localTransaction = new LocalTransactionImpl();
            }
        }
        if (dbPool.isSpy()) {
            this._driverConnection = new SpyConnection(this._driverConnection, this._dbPool.getSpyDataSource(), this._id);
            if (this._xaResource != null) {
                this._xaResource = new SpyXAResource(this._id, this._xaResource);
            }
        }
        if ((isolation = this._connConfig.getTransactionIsolation()) >= 0) {
            this._driverConnection.setTransactionIsolation(isolation);
        }
        if (this._connConfig.isReadOnly()) {
            this._driverConnection.setReadOnly(true);
        }
        if ((configCatalog = this._connConfig.getCatalog()) != null) {
            this._hasCatalog = true;
            this._catalogOrig = configCatalog;
            this._driverConnection.setCatalog(this._catalogOrig);
        }
    }

    Connection getDriverConnection() {
        return this._driverConnection;
    }

    public Class<?> getDriverClass() {
        return this._driver.getDriverClass();
    }

    public String getURL() {
        return this.getDBPool().getURL();
    }

    @Override
    public XAResource getXAResource() throws ResourceException {
        if (this._xaResource != null) {
            return this._xaResource;
        }
        throw new NotSupportedException();
    }

    @Override
    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this._localTransaction;
    }

    @Override
    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new NotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    @Override
    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public void setIsolation(int isolation) throws SQLException {
    }

    PreparedStatement prepareStatement(UserConnection uConn, String sql, int resultType) throws SQLException {
        Connection conn = this.getDriverConnection();
        if (conn == null) {
            throw new IllegalStateException(L.l("can't prepare statement from closed connection"));
        }
        if (resultType > 0) {
            return conn.prepareStatement(sql, resultType);
        }
        return conn.prepareStatement(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareStatement(UserConnection uConn, String sql) throws SQLException {
        UserPreparedStatement upStmt;
        PreparedStatementCacheItem item;
        PreparedStatementKey key = this._key;
        Connection conn = this.getDriverConnection();
        if (conn == null) {
            throw new IllegalStateException(L.l("can't prepare statement from closed connection"));
        }
        if (key == null) {
            return conn.prepareStatement(sql);
        }
        boolean hasItem = false;
        PreparedStatementKey preparedStatementKey = key;
        synchronized (preparedStatementKey) {
            key.init(sql);
            item = this._preparedStatementCache.get(key);
            if (item != null) {
                upStmt = item.toActive(uConn);
                if (upStmt != null) {
                    return upStmt;
                }
                hasItem = !item.isRemoved();
            }
        }
        PreparedStatement pStmt = conn.prepareStatement(sql);
        if (hasItem) {
            return pStmt;
        }
        key = new PreparedStatementKey(sql);
        item = new PreparedStatementCacheItem(key, pStmt, this);
        upStmt = item.toActive(uConn);
        if (upStmt == null) {
            throw new IllegalStateException("preparedStatement can't activate");
        }
        this._preparedStatementCache.put(key, item);
        return upStmt;
    }

    void remove(PreparedStatementKey key) {
        this._preparedStatementCache.remove(key);
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        this.sendFatalEvent(new SQLException(L.l("unexpected close event from pool")));
        this.closeEvent(null);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        this.sendFatalEvent(event.getSQLException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEvent(UserConnection userConn) {
        if (this._listener != null) {
            javax.resource.spi.ConnectionEvent evt;
            if (this._connException != null) {
                this.sendFatalEvent(this._connException);
            }
            ManagedConnectionImpl managedConnectionImpl = this;
            synchronized (managedConnectionImpl) {
                evt = this._connClosedEvent;
                this._connClosedEvent = null;
            }
            if (evt == null) {
                evt = new javax.resource.spi.ConnectionEvent(this, 1);
            }
            evt.setConnectionHandle(userConn);
            this._listener.connectionClosed(evt);
            evt.setConnectionHandle(null);
            this._connClosedEvent = evt;
            this._lastEventTime = CurrentTime.getCurrentTime();
        }
    }

    public void fatalEvent() {
        this.fatalEvent(new ResourceException("fatal event"));
    }

    public void fatalEvent(Exception e) {
        if (this._pooledConnection == null) {
            this._connException = e instanceof ResourceException ? (ResourceException)e : new ResourceException(e);
        }
    }

    public void sendFatalEvent(Exception e) {
        this._isPingRequired = true;
        if (this._listener != null) {
            javax.resource.spi.ConnectionEvent event = new javax.resource.spi.ConnectionEvent(this, 5, e);
            this._listener.connectionErrorOccurred(event);
        }
    }

    public void onSqlException(SQLException e) {
        this.setPingRequired();
    }

    public void onRuntimeException(RuntimeException e) {
        this.setPingRequired();
    }

    public void setPingRequired() {
        this._isPingRequired = true;
    }

    void killPool() {
        if (this._listener != null) {
            javax.resource.spi.ConnectionEvent event = new javax.resource.spi.ConnectionEvent(this, 5);
            this._listener.connectionErrorOccurred(event);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this._autoCommit = autoCommit;
            this._driverConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this._readOnly = readOnly;
            this._driverConnection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            if (!this._hasCatalog) {
                this._hasCatalog = true;
                this._catalog = this._catalogOrig = this._driverConnection.getCatalog();
            }
            if (catalog == null || catalog.length() == 0) {
                this._catalog = null;
            } else if (this._catalog == null || !this._catalog.equals(catalog)) {
                this._driverConnection.setCatalog(catalog);
                this._catalog = catalog;
            }
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this._typeMap == null) {
            this._typeMap = this._driverConnection.getTypeMap();
        }
        this._driverConnection.setTypeMap(map);
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        if (this._oldIsolation < 0) {
            this._oldIsolation = this._driverConnection.getTransactionIsolation();
        }
        this._isolation = isolation;
        this._driverConnection.setTransactionIsolation(isolation);
    }

    @Override
    public void cleanup() throws ResourceException {
        Connection conn = this._driverConnection;
        if (conn == null) {
            return;
        }
        try {
            boolean needsRollback;
            this._lastEventTime = CurrentTime.getCurrentTime();
            if (this._readOnly) {
                conn.setReadOnly(false);
            }
            this._readOnly = false;
            if (this._catalog != null && !this._catalog.equals(this._catalogOrig) && this._catalogOrig != null && !"".equals(this._catalogOrig)) {
                conn.setCatalog(this._catalogOrig);
            }
            this._catalog = null;
            if (this._typeMap != null) {
                conn.setTypeMap(this._typeMap);
            }
            this._typeMap = null;
            boolean bl = needsRollback = !this._autoCommit;
            if (this._isolation != this._oldIsolation) {
                needsRollback = true;
                conn.setTransactionIsolation(this._oldIsolation);
            }
            this._isolation = this._oldIsolation;
            if (!this._autoCommit) {
                conn.setAutoCommit(true);
            }
            this._autoCommit = true;
            conn.clearWarnings();
        }
        catch (SQLException e) {
            throw new ResourceException(e);
        }
    }

    boolean isValid() {
        try {
            return this.ping();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ping() throws ResourceException {
        DBPoolImpl dbPool = this._factory.getDBPool();
        long now = CurrentTime.getCurrentTime();
        long pingInterval = dbPool.getPingInterval();
        boolean isPingRequired = this._isPingRequired;
        this._isPingRequired = false;
        Connection conn = this._driverConnection;
        if (this.isClosed()) {
            return false;
        }
        if (!isPingRequired) {
            if (pingInterval > 0L && now < this._lastEventTime + pingInterval) {
                return true;
            }
            if (now < this._lastEventTime + 1000L) {
                return true;
            }
        }
        try {
            boolean bl;
            this._lastEventTime = now;
            if (conn == null) {
                return false;
            }
            String pingQuery = dbPool.getPingQuery();
            if (conn.isClosed()) {
                return false;
            }
            if (!dbPool.isPing() || pingQuery == null) {
                if (isPingRequired) return false;
                return true;
            }
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(pingQuery);
                rs.next();
                rs.close();
                bl = true;
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return bl;
        }
        catch (SQLException e) {
            throw new ResourceException(e);
        }
    }

    @Override
    public void destroy() throws ResourceException {
        log.finer("destroy " + this);
        PooledConnection poolConn = this._pooledConnection;
        this._pooledConnection = null;
        Connection driverConn = this._driverConnection;
        this._driverConnection = null;
        if (this._preparedStatementCache != null) {
            Iterator<PreparedStatementCacheItem> iter = this._preparedStatementCache.values();
            while (iter.hasNext()) {
                PreparedStatementCacheItem item = iter.next();
                item.destroy();
            }
        }
        try {
            if (this._isPastActiveTime && driverConn != null) {
                if (this._dbPool.isCommitOnTimeout()) {
                    log.finer("committing closed from active expired " + this);
                    driverConn.commit();
                } else {
                    log.finer("rolling back closed from active expired " + this);
                    driverConn.rollback();
                }
            }
        }
        catch (SQLException e) {
            throw new ResourceException(e);
        }
        try {
            if (poolConn != null) {
                poolConn.close();
            }
        }
        catch (SQLException e) {
            throw new ResourceException(e);
        }
        try {
            if (driverConn != null) {
                driverConn.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }

    public void setPastActiveTime(boolean isPastActiveTime) {
        this._isPastActiveTime = isPastActiveTime;
    }

    class LocalTransactionImpl
    implements LocalTransaction {
        private boolean _oldAutoCommit;

        LocalTransactionImpl() {
        }

        public void begin() throws ResourceException {
            try {
                this._oldAutoCommit = ManagedConnectionImpl.this._autoCommit;
                ManagedConnectionImpl.this.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new ResourceException(e);
            }
        }

        public void commit() throws ResourceException {
            Connection conn = ManagedConnectionImpl.this._driverConnection;
            if (conn == null) {
                throw new ResourceException(L.l("connection is closed"));
            }
            try {
                conn.commit();
            }
            catch (SQLException e) {
                throw new ResourceException(e);
            }
            try {
                ManagedConnectionImpl.this.setAutoCommit(this._oldAutoCommit);
            }
            catch (SQLException e) {
                throw new ResourceException(e);
            }
        }

        public void rollback() throws ResourceException {
            Connection conn = ManagedConnectionImpl.this._driverConnection;
            if (conn == null) {
                throw new ResourceException(L.l("connection is closed"));
            }
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                throw new ResourceException(e);
            }
            try {
                ManagedConnectionImpl.this.setAutoCommit(this._oldAutoCommit);
            }
            catch (SQLException e) {
                throw new ResourceException(e);
            }
        }
    }
}

