/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.env.meter.ActiveTimeSensor;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.sql.UserCallableStatement;
import com.caucho.sql.UserPreparedStatement;
import com.caucho.sql.UserStatement;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.L10N;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserConnection
implements Connection {
    protected static final Logger log = Logger.getLogger(UserConnection.class.getName());
    protected static final L10N L = new L10N(UserConnection.class);
    private ManagedConnectionImpl _mConn;
    private Statement _statement;
    private ArrayList<Statement> _statements;

    UserConnection(ManagedConnectionImpl mConn) {
        if (mConn == null || mConn.getDriverConnection() == null) {
            throw new NullPointerException();
        }
        this._mConn = mConn;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.getDriverConnection();
        if (conn instanceof SpyConnection) {
            conn = ((SpyConnection)conn).getConnection();
        }
        return conn;
    }

    ActiveTimeSensor getTimeProbe() {
        return this._mConn.getDBPool().getTimeProbe();
    }

    public Class<?> getDriverClass() {
        return this.getMConn().getDriverClass();
    }

    public String getURL() {
        return this.getMConn().getDBPool().getURL();
    }

    void associate(ManagedConnectionImpl mConn) {
        this._mConn = mConn;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt;
        Connection conn = this.getDriverConnection();
        try {
            stmt = conn.createStatement();
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt;
        Connection conn = this.getDriverConnection();
        try {
            stmt = conn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt;
        Connection conn = this.getDriverConnection();
        try {
            stmt = conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getMConn().prepareStatement(this, sql);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getMConn().prepareStatement(this, sql, resultSetType);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        if (stmt == null) {
            throw new IllegalStateException(L.l("prepareStatement returned empty SQL\n{0}", (Object)sql));
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserCallableStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareCall(sql);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserCallableStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserCallableStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.getDriverConnection().getCatalog();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.getMConn().setCatalog(catalog);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getDriverConnection().getMetaData();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.getDriverConnection().getTypeMap();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.getMConn().setTypeMap(map);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.getDriverConnection().nativeSQL(sql);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getDriverConnection().getTransactionIsolation();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int isolation) throws SQLException {
        try {
            this.getMConn().setTransactionIsolation(isolation);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            Connection conn = this.getDriverConnection();
            if (conn != null) {
                return conn.getWarnings();
            }
            return null;
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            Connection conn = this.getDriverConnection();
            if (conn != null) {
                conn.clearWarnings();
            }
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.getMConn().setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.getDriverConnection().isReadOnly();
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getDriverConnection().getAutoCommit();
        }
        catch (SQLException e) {
            this.onFatalException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFatalException(e);
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.getMConn().setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            Connection conn = this.getDriverConnection();
            if (conn != null) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            Connection conn = this.getDriverConnection();
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void setHoldability(int hold) throws SQLException {
        try {
            this.getDriverConnection().setHoldability(hold);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.getDriverConnection().getHoldability();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.getDriverConnection().setSavepoint();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            return this.getDriverConnection().setSavepoint(name);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getDriverConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.getDriverConnection().rollback(savepoint);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return this.getDriverConnection().createClob();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return this.getDriverConnection().createBlob();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.getDriverConnection().createNClob();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.getDriverConnection().createSQLXML();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return this.getDriverConnection().isValid(timeout);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getDriverConnection().setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getDriverConnection().setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.getDriverConnection().getClientInfo(name);
        }
        catch (SQLClientInfoException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.getDriverConnection().getClientInfo();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return this.getDriverConnection().createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            return this.getDriverConnection().createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        Connection conn = this.getConnection();
        if (iface.isAssignableFrom(conn.getClass())) {
            return (T)conn;
        }
        return conn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        Connection conn = this.getConnection();
        if (iface.isAssignableFrom(conn.getClass())) {
            return true;
        }
        return conn.isWrapperFor(iface);
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this._mConn == null || this.getDriverConnection() == null || this.getDriverConnection().isClosed();
        }
        catch (SQLException e) {
            this.onSqlException(e);
            log.log(Level.FINER, e.toString(), e);
            return true;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ManagedConnectionImpl mConn;
        UserConnection userConnection = this;
        synchronized (userConnection) {
            mConn = this._mConn;
            this._mConn = null;
            if (mConn == null) {
                return;
            }
        }
        try {
            try {
                this.resetConnection(mConn);
            }
            catch (Throwable e) {
                mConn.fatalEvent();
                log.log(Level.WARNING, e.toString(), e);
                Object var5_6 = null;
                mConn.closeEvent(this);
            }
            Object var5_5 = null;
            mConn.closeEvent(this);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            mConn.closeEvent(this);
            throw throwable;
        }
    }

    private void addStatement(Statement stmt) {
        if (this._statement == null) {
            this._statement = stmt;
        } else if (this._statements != null) {
            this._statements.add(stmt);
        } else {
            this._statements = new ArrayList();
            this._statements.add(stmt);
        }
    }

    private void resetConnection(ManagedConnectionImpl mConn) {
        this.closeStatements(mConn);
    }

    void closeStatement(Statement stmt) {
        if (this._statement == stmt) {
            this._statement = null;
        } else if (this._statements != null) {
            this._statements.remove(stmt);
        }
    }

    private void closeStatements(ManagedConnectionImpl mConn) {
        ArrayList<Statement> statements = this._statements;
        this._statements = null;
        Statement stmt = this._statement;
        this._statement = null;
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        for (int i = 0; statements != null && i < statements.size(); ++i) {
            try {
                stmt = statements.get(i);
                if (stmt == null) continue;
                stmt.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public Connection getDriverConnection() throws SQLException {
        ManagedConnectionImpl mConn = this.getMConn();
        if (mConn == null) {
            throw new IllegalStateException(L.l("Cannot use closed connection.  Check max-active-time and review application code. "));
        }
        Connection conn = mConn.getDriverConnection();
        return conn;
    }

    public ManagedConnectionImpl getMConn() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn == null) {
            throw new IllegalStateException("connection is closed");
        }
        return mConn;
    }

    public void discardConnection() {
        this.fatalEvent();
    }

    private void fatalEvent() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.fatalEvent();
        }
    }

    private void onSqlException(SQLException e) {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.onSqlException(e);
        }
    }

    private void onRuntimeException(RuntimeException e) {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.onRuntimeException(e);
        }
    }

    protected void setPingRequired() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.setPingRequired();
        }
    }

    private void onFatalException(Exception e) {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.sendFatalEvent(e);
        }
    }

    void killPool() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.killPool();
        }
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._mConn + "]";
    }
}

