/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.spy.SpyPooledConnection;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class SpyConnectionPoolDataSource
implements ConnectionPoolDataSource {
    protected static final Logger log = Logger.getLogger(SpyConnectionPoolDataSource.class.getName());
    protected static final L10N L = new L10N(SpyConnectionPoolDataSource.class);
    private String _id;
    private AtomicInteger _connCount = new AtomicInteger();
    private ConnectionPoolDataSource _dataSource;

    public SpyConnectionPoolDataSource(ConnectionPoolDataSource dataSource, String id) {
        this._dataSource = dataSource;
        this._id = id;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        long start = this.start();
        try {
            PooledConnection conn = this._dataSource.getPooledConnection();
            String connId = this._id + "." + this._connCount.getAndIncrement();
            this.log(start, "getConnectionPool() -> " + connId + ":" + conn);
            return new SpyPooledConnection(conn, connId);
        }
        catch (SQLException e) {
            this.log(start, "exn-connect(" + e + ")");
            throw e;
        }
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        long start = this.start();
        try {
            PooledConnection conn = this._dataSource.getPooledConnection(user, password);
            String connId = this._id + "." + this._connCount.getAndIncrement();
            this.log(start, "getPooledConnection(" + user + ") -> " + connId + ":" + conn);
            return new SpyPooledConnection(conn, connId);
        }
        catch (SQLException e) {
            this.log(start, "exn-connect(" + e + ")");
            throw e;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this._dataSource.setLoginTimeout(timeout);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter log) throws SQLException {
        this._dataSource.setLogWriter(log);
    }

    protected long start() {
        return CurrentTime.getExactTime();
    }

    protected void log(long start, String msg) {
        long delta = CurrentTime.getExactTime() - start;
        log.fine("[" + delta + "ms] " + this._id + ":" + msg);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this._id + ",data-source=" + this._dataSource + "]";
    }
}

