/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SpyXAResource
implements XAResource {
    protected static final Logger log = Logger.getLogger(SpyXAResource.class.getName());
    protected static final L10N L = new L10N(SpyXAResource.class);
    private XAResource _xaResource;
    private String _id;

    public SpyXAResource(String id, XAResource resource) {
        this._xaResource = resource;
        this._id = id;
    }

    public XAResource getXAResource() {
        return this._xaResource;
    }

    protected long start() {
        return CurrentTime.getExactTime();
    }

    protected void log(long start, String msg) {
        long delta = CurrentTime.getExactTime() - start;
        log.fine("[" + delta + "ms] " + this._id + ":" + msg);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        long start = this.start();
        try {
            boolean ok = this._xaResource.setTransactionTimeout(seconds);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "set-transaction-timeout(" + seconds + ")->" + ok);
            }
            return ok;
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public int getTransactionTimeout() throws XAException {
        long start = this.start();
        try {
            int seconds = this._xaResource.getTransactionTimeout();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "transaction-timeout()->" + seconds);
            }
            return seconds;
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        long start = this.start();
        try {
            if (resource instanceof SpyXAResource) {
                resource = ((SpyXAResource)resource).getXAResource();
            }
            boolean same = this._xaResource.isSameRM(resource);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "is-same-rm(resource=" + resource + ")->" + same);
            }
            return same;
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        long start = this.start();
        try {
            this._xaResource.start(xid, flags);
            if (log.isLoggable(Level.FINE)) {
                String flagName = "";
                if ((flags & 0x200000) != 0) {
                    flagName = flagName + ",join";
                }
                if ((flags & 0x8000000) != 0) {
                    flagName = flagName + ",resume";
                }
                this.log(start, "start(xid=" + xid + flagName + ")");
            }
        }
        catch (XAException e) {
            this.log(start, "exn-start(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log(start, "exn-start(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        long start = this.start();
        try {
            this._xaResource.end(xid, flags);
            if (log.isLoggable(Level.FINE)) {
                String flagName = "";
                if ((flags & 0x20000000) != 0) {
                    flagName = flagName + ",fail";
                }
                if ((flags & 0x2000000) != 0) {
                    flagName = flagName + ",suspend";
                }
                this.log(start, "end(xid=" + xid + flagName + ")");
            }
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            this.log(start, "exn-end(" + xid + ") -> " + e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log(start, "exn-end(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public int prepare(Xid xid) throws XAException {
        long start = this.start();
        try {
            int value = this._xaResource.prepare(xid);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "prepare(xid=" + xid + ")->" + value);
            }
            return value;
        }
        catch (XAException e) {
            this.log(start, "exn-prepare(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log(start, "exn-prepare(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        long start = this.start();
        try {
            this._xaResource.commit(xid, onePhase);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "commit(xid=" + xid + (onePhase ? ",1P)" : ",2P)"));
            }
        }
        catch (XAException e) {
            this.log(start, "exn-commit(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log(start, "exn-commit(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void rollback(Xid xid) throws XAException {
        long start = this.start();
        try {
            this._xaResource.rollback(xid);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "rollback(xid=" + xid + ")");
            }
        }
        catch (XAException e) {
            this.log(start, "exn-rollback(xid) -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log(start, "exn-rollback(xid) -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public Xid[] recover(int flags) throws XAException {
        long start = this.start();
        try {
            Xid[] xids = this._xaResource.recover(flags);
            if (log.isLoggable(Level.FINE)) {
                String flagString = "";
                if ((flags & 0x1000000) != 0) {
                    flagString = flagString + "start";
                }
                if ((flags & 0x800000) != 0) {
                    if (!flagString.equals("")) {
                        flagString = flagString + ",";
                    }
                    flagString = flagString + "end";
                }
                this.log(start, "recover(flags=" + flagString + ")");
            }
            return xids;
        }
        catch (XAException e) {
            this.log(start, "exn-recover() " + e);
            log.fine(e.toString());
            throw e;
        }
        catch (RuntimeException e) {
            this.log(start, "exn-recover() " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void forget(Xid xid) throws XAException {
        long start = this.start();
        try {
            this._xaResource.forget(xid);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "forget(xid=" + xid + ")");
            }
        }
        catch (XAException e) {
            this.log(start, "exn-force(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log(start, "exn-force(" + xid + ") -> " + e);
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this._id + ",resource=" + this._xaResource + "]";
    }
}

