/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.ConnectionWrapper;
import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSourceWrapper
implements DataSource {
    private static final L10N L = new L10N(DataSourceWrapper.class);
    private final DataSource _dataSource;
    private final ProfilerPoint _profilerPoint;

    public DataSourceWrapper(ProfilerPoint profilerPoint, DataSource dataSource) {
        this._profilerPoint = profilerPoint;
        this._dataSource = dataSource;
    }

    private Connection wrap(Connection connection) {
        return new ConnectionWrapper(this._profilerPoint, connection);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.wrap(this._dataSource.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.wrap(this._dataSource.getConnection(username, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintWriter getLogWriter() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            PrintWriter printWriter = this._dataSource.getLogWriter();
            Object var4_3 = null;
            profiler.finish();
            return printWriter;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._dataSource.setLogWriter(out);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._dataSource.setLoginTimeout(seconds);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLoginTimeout() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._dataSource.getLoginTimeout();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    public String toString() {
        return "DataSourceWrapper[" + this._profilerPoint.getName() + "]";
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

