/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.tools.profiler.ProfilerAdmin;
import com.caucho.tools.profiler.ProfilerPoint;

public class ProfilerManager {
    private static final EnvironmentLocal<ProfilerManager> _local = new EnvironmentLocal();
    private ProfilerPoint _root;
    private boolean _isEnabled = false;

    private ProfilerManager() {
        new ProfilerAdmin(this);
        this._root = new ProfilerPoint(this, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilerManager getLocal() {
        EnvironmentLocal<ProfilerManager> environmentLocal = _local;
        synchronized (environmentLocal) {
            ProfilerManager local = _local.get();
            if (local == null) {
                local = new ProfilerManager();
                _local.set(local);
            }
            return local;
        }
    }

    public ProfilerPoint getRoot() {
        return this._root;
    }

    public ProfilerPoint getProfilerPoint(String name) {
        return this._root.addProfilerPoint(name);
    }

    public void setEnabled(boolean isEnabled) {
        this._isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void enable() {
        if (!this._isEnabled) {
            this.reset();
            this._isEnabled = true;
        }
    }

    public void disable() {
        this._isEnabled = false;
    }

    public ProfilerPoint addProfilerPoint(String name) {
        return this._root.addProfilerPoint(name);
    }

    public ProfilerPoint getCategorizingProfilerPoint(String name) {
        return this._root.addProfilerPoint(name);
    }

    public void reset() {
        this._root.reset();
    }

    public String toString() {
        return "ProfilerManager[" + this.getClass().getClassLoader() + "]";
    }
}

