/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.AlarmClock;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.ThreadTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Alarm
implements ThreadTask,
ClassLoaderListener {
    private static final Logger log = Logger.getLogger(Alarm.class.getName());
    private static final ClassLoader _systemLoader;
    private static AtomicReferenceFieldUpdater<Alarm, Alarm> _nextUpdater;
    private static AtomicLongFieldUpdater<Alarm> _wakeTimeUpdater;
    private static final CoordinatorThread _coordinatorThread;
    private static final AlarmClock _clock;
    private static final AtomicInteger _runningAlarmCount;
    private static final boolean _isStressTest;
    private volatile Alarm _next;
    private volatile long _wakeTime;
    private AlarmListener _listener;
    private ClassLoader _contextLoader;
    private String _name;
    private boolean _isPriority = true;
    private int _bucket = -1;
    private volatile boolean _isRunning;

    protected Alarm() {
        this("alarm");
    }

    protected Alarm(String name) {
        if (_coordinatorThread == null) {
            throw new IllegalStateException("Alarm cannot be instantiated because Resin is running inside a foreign classloader.\n  " + Alarm.class.getClassLoader());
        }
        this._name = name;
        this.addEnvironmentListener();
    }

    public Alarm(AlarmListener listener) {
        this("alarm[" + listener + "]", listener);
    }

    public Alarm(String name, AlarmListener listener) {
        this(name, listener, Thread.currentThread().getContextClassLoader());
    }

    public Alarm(String name, AlarmListener listener, ClassLoader loader) {
        this(name);
        this.setListener(listener);
        this.setContextLoader(loader);
    }

    public Alarm(String name, AlarmListener listener, long delta, ClassLoader loader) {
        this(name);
        this.setListener(listener);
        this.setContextLoader(loader);
        this.queue(delta);
    }

    public Alarm(String name, AlarmListener listener, long delta) {
        this(name, listener);
        this.queue(delta);
    }

    public Alarm(AlarmListener listener, long delta) {
        this(listener);
        this.queue(delta);
    }

    public String getName() {
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public long getWakeTime() {
        return this._wakeTime;
    }

    public void setWakeTime(long wakeTime) {
        this._wakeTime = wakeTime;
    }

    boolean setWakeTime(long prevWakeTime, long wakeTime) {
        return _wakeTimeUpdater.compareAndSet(this, prevWakeTime, wakeTime);
    }

    long getAndSetWakeTime(long wakeTime) {
        return _wakeTimeUpdater.getAndSet(this, wakeTime);
    }

    int getHeapIndex() {
        return 0;
    }

    int getBucket() {
        return this._bucket;
    }

    void setBucket(int bucket) {
        this._bucket = bucket;
    }

    void setHeapIndex(int index) {
    }

    Alarm getNext() {
        return this._next;
    }

    boolean setNext(Alarm prevNext, Alarm next) {
        return _nextUpdater.compareAndSet(this, prevNext, next);
    }

    void setNext(Alarm next) {
        this._next = next;
    }

    public AlarmListener getListener() {
        return this._listener;
    }

    public void setListener(AlarmListener listener) {
        this._listener = listener;
    }

    public void setContextLoader(ClassLoader loader) {
        this._contextLoader = loader;
    }

    public ClassLoader getContextLoader() {
        return this._contextLoader;
    }

    public boolean isQueued() {
        return this._bucket >= 0;
    }

    boolean isRunning() {
        return this._isRunning;
    }

    public void setPriority(boolean isPriority) {
        this._isPriority = isPriority;
    }

    public boolean isPriority() {
        return this._isPriority;
    }

    protected void addEnvironmentListener() {
    }

    public void queue(long delta) {
        long now = CurrentTime.getExactTime();
        boolean isNotify = _clock.queueAt(this, now + delta);
        if (isNotify) {
            _coordinatorThread.wake();
        }
    }

    public void queueAt(long wakeTime) {
        boolean isNotify = _clock.queueAt(this, wakeTime);
        if (isNotify) {
            _coordinatorThread.wake();
        }
    }

    public void dequeue() {
        _clock.dequeue(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.handleAlarm();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var3_2 = null;
                this._isRunning = false;
                _runningAlarmCount.decrementAndGet();
                return;
            }
            Object var3_1 = null;
            this._isRunning = false;
            _runningAlarmCount.decrementAndGet();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._isRunning = false;
            _runningAlarmCount.decrementAndGet();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAlarm() {
        AlarmListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.getContextLoader();
        if (loader != null) {
            thread.setContextClassLoader(loader);
        } else {
            thread.setContextClassLoader(_systemLoader);
        }
        try {
            listener.handleAlarm(this);
            Object var5_4 = null;
            thread.setContextClassLoader(_systemLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(_systemLoader);
            throw throwable;
        }
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.close();
    }

    public void close() {
        this.dequeue();
    }

    static void testClear() {
        _clock.testClear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAlarmTestTime(long time) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            long now = CurrentTime.getCurrentTime();
            _clock.extractAlarm(now, true);
            Object var7_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public String toString() {
        return "Alarm[" + this._name + "]";
    }

    static {
        _clock = new AlarmClock();
        _runningAlarmCount = new AtomicInteger();
        CoordinatorThread coordinator = null;
        ClassLoader loader = Alarm.class.getClassLoader();
        try {
            coordinator = new CoordinatorThread();
            coordinator.wake();
        }
        catch (Throwable e) {
            log.fine("Alarm not started: " + e);
        }
        _nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Alarm.class, Alarm.class, "_next");
        _wakeTimeUpdater = AtomicLongFieldUpdater.newUpdater(Alarm.class, "_wakeTime");
        _systemLoader = loader;
        _coordinatorThread = coordinator;
        _isStressTest = System.getProperty("caucho.stress.test") != null;
    }

    static class CoordinatorThread
    extends AbstractTaskWorker {
        private long _lastTime;

        CoordinatorThread() {
        }

        protected boolean isPermanent() {
            return true;
        }

        public long runTask() {
            long next;
            long now;
            if (CurrentTime.isTest()) {
                return -1L;
            }
            this._lastTime = CurrentTime.getExactTime();
            do {
                now = CurrentTime.getExactTime();
                next = _clock.extractAlarm(now, false);
                if (next >= 0L) continue;
                return 120000L;
            } while (now >= next);
            return next - now;
        }
    }
}

