/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.FreeList;
import java.security.SecureRandom;
import java.util.Random;

public class RandomUtil {
    private static FreeList<Random> _freeRandomList = new FreeList(64);
    private static Random _testRandom;
    private static boolean _isTest;

    public static long getRandomLong() {
        Random random = RandomUtil.getRandom();
        long value = random.nextLong();
        if (!_isTest) {
            _freeRandomList.free(random);
        }
        return value;
    }

    public static int nextInt(int n) {
        Random random = RandomUtil.getRandom();
        int value = random.nextInt(n);
        if (!_isTest) {
            _freeRandomList.free(random);
        }
        return value;
    }

    public static double nextDouble() {
        Random random = RandomUtil.getRandom();
        double value = random.nextDouble();
        if (!_isTest) {
            _freeRandomList.free(random);
        }
        return value;
    }

    private static Random getRandom() {
        if (_isTest) {
            return _testRandom;
        }
        Random random = _freeRandomList.allocate();
        if (random == null) {
            random = new SecureRandom();
        }
        return random;
    }

    public static void setTestSeed(long seed) {
        _isTest = true;
        _testRandom = new Random(seed);
    }
}

