/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingValueQueue<T> {
    private static final Logger log = Logger.getLogger(RingValueQueue.class.getName());
    private final Item<T>[] _ring;
    private final AtomicInteger _headAlloc = new AtomicInteger();
    private final AtomicInteger _head = new AtomicInteger();
    private final AtomicInteger _tailAlloc = new AtomicInteger();
    private final AtomicInteger _tail = new AtomicInteger();
    private final int _size;
    private final int _mask;
    private final AtomicBoolean _isOfferWait = new AtomicBoolean();

    public RingValueQueue(int capacity) {
        int size;
        for (size = 8; size < capacity; size *= 2) {
        }
        this._size = size;
        this._ring = new Item[size];
        this._mask = size - 1;
        for (int i = 0; i < this._ring.length; ++i) {
            this._ring[i] = new Item();
        }
    }

    public final boolean isEmpty() {
        return this._head.get() == this._tail.get();
    }

    public final int getSize() {
        int head = this._head.get();
        int tail = this._tail.get();
        return head - tail + this._size & this._mask;
    }

    public final int getCapacity() {
        return this._size;
    }

    public final int getHead() {
        return this._head.get();
    }

    public final int getHeadAlloc() {
        return this._headAlloc.get();
    }

    public final int getTail() {
        return this._tail.get();
    }

    public final int getTailAlloc() {
        return this._tailAlloc.get();
    }

    public final boolean offer(T value) {
        return this.offer(value, 0L);
    }

    public final boolean put(T value) {
        return this.offer(value, CurrentTime.getCurrentTime() + Integer.MAX_VALUE);
    }

    public final boolean offer(T value, long expireTime) {
        int headAlloc;
        int nextHeadAlloc;
        if (value == null) {
            throw new NullPointerException();
        }
        AtomicInteger headRef = this._head;
        AtomicInteger headAllocRef = this._headAlloc;
        AtomicInteger tailRef = this._tail;
        int mask = this._mask;
        while (true) {
            int tail;
            if ((nextHeadAlloc = (headAlloc = headAllocRef.get()) + 1 & mask) == (tail = tailRef.get())) {
                if (this.finishPoll()) continue;
                if (expireTime <= 0L) {
                    return false;
                }
                this.waitForAvailable(headAlloc, tail);
                continue;
            }
            if (headAllocRef.compareAndSet(headAlloc, nextHeadAlloc)) break;
        }
        Item<T> item = this.get(headAlloc);
        item.set(value);
        if (!headRef.compareAndSet(headAlloc, nextHeadAlloc)) {
            this.finishOffer(headAlloc);
        }
        this.wakeAvailable();
        return true;
    }

    private final boolean finishOffer() {
        int headAlloc;
        int head = this._head.get();
        if (head != (headAlloc = this._headAlloc.get()) && this.get(head).isSet()) {
            this.finishOffer(head);
            return true;
        }
        return false;
    }

    private void finishOffer(int index) {
        int retryMax;
        AtomicInteger headRef = this._head;
        AtomicInteger headAllocRef = this._headAlloc;
        int mask = this._mask;
        int retryCount = retryMax = (index & 0xF) + 1 << 4;
        int count = 4;
        while (retryCount-- >= 0) {
            int headAlloc;
            int head = headRef.get();
            if (head == (headAlloc = headAllocRef.get())) {
                return;
            }
            if (!this.get(head).isSet()) continue;
            int nextHead = head + 1 & mask;
            if (headRef.compareAndSet(head, nextHead) && count-- <= 0) {
                return;
            }
            retryCount = retryMax;
        }
    }

    public final T peek() {
        int tail = this._tailAlloc.get();
        int head = this._head.get();
        if (head != tail) {
            return this.getValue(tail);
        }
        return null;
    }

    public final T poll() {
        int nextTail;
        int tailAlloc;
        AtomicInteger tailAllocRef = this._tailAlloc;
        AtomicInteger tailRef = this._tail;
        AtomicInteger headRef = this._head;
        do {
            tailAlloc = tailAllocRef.get();
            int head = headRef.get();
            if (head != tailAlloc || this.finishOffer()) continue;
            return null;
        } while (!tailAllocRef.compareAndSet(tailAlloc, nextTail = tailAlloc + 1 & this._mask));
        Item<T> item = this.get(tailAlloc);
        T value = item.getAndClear();
        if (!tailRef.compareAndSet(tailAlloc, nextTail)) {
            this.completePoll(tailAlloc);
        }
        return value;
    }

    private final boolean finishPoll() {
        int headAlloc;
        int tail = this._tail.get();
        if (tail != (headAlloc = this._tailAlloc.get()) && !this.get(tail).isSet()) {
            this.completePoll(tail);
            return true;
        }
        return false;
    }

    private void completePoll(int index) {
        int retryMax;
        AtomicInteger tailRef = this._tail;
        AtomicInteger tailAllocRef = this._tailAlloc;
        int retryCount = retryMax = (index & 0xF) + 1 << 4;
        int count = 4;
        while (retryCount-- >= 0) {
            int tailAlloc;
            int tail = tailRef.get();
            if (tail == (tailAlloc = tailAllocRef.get())) {
                this.wakeAvailable();
                return;
            }
            if (this.get(tail).isSet()) continue;
            int nextTail = tail + 1 & this._mask;
            if (tailRef.compareAndSet(tail, nextTail) && count-- <= 0) {
                this.wakeAvailable();
                return;
            }
            retryCount = retryMax;
        }
        this.wakeAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAvailable(int headAlloc, int tail) {
        if (this._headAlloc.get() == headAlloc && this._tail.get() == tail) {
            AtomicBoolean atomicBoolean = this._isOfferWait;
            synchronized (atomicBoolean) {
                this._isOfferWait.set(true);
                if (this._headAlloc.get() == headAlloc && this._tail.get() == tail) {
                    try {
                        this._isOfferWait.wait(10L);
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                }
            }
        }
    }

    private Item<T> get(int index) {
        return this._ring[index];
    }

    public T getValue(int index) {
        return this._ring[index & this._mask].get();
    }

    public int nextIndex(int index) {
        return index + 1 & this._mask;
    }

    public int prevIndex(int index) {
        return index + this._mask & this._mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeAvailable() {
        int size = this.getSize();
        if (this._isOfferWait.get() && (2 * size <= this._size || this._size - size > 64) && this._isOfferWait.compareAndSet(true, false)) {
            AtomicBoolean atomicBoolean = this._isOfferWait;
            synchronized (atomicBoolean) {
                this._isOfferWait.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Item<T> {
        private volatile T _value;

        private Item() {
        }

        final boolean isSet() {
            return this._value != null;
        }

        final T get() {
            return this._value;
        }

        final T getAndClear() {
            T value = this._value;
            this._value = null;
            return value;
        }

        final void set(T value) {
            this._value = value;
        }

        final void clear() {
            this._value = null;
        }
    }
}

