/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RingValueQueue2<T> {
    private static final Logger log = Logger.getLogger(RingValueQueue2.class.getName());
    private final Item<T>[] _ring;
    private final AtomicLong _headAlloc = new AtomicLong();
    private final AtomicLong _head = new AtomicLong();
    private final AtomicLong _tailAlloc = new AtomicLong();
    private final AtomicLong _tail = new AtomicLong();
    private final int _size;
    private final int _mask;
    private final AtomicBoolean _isOfferWait = new AtomicBoolean();

    public RingValueQueue2(int capacity) {
        int size;
        for (size = 8; size < capacity; size *= 2) {
        }
        this._size = size;
        this._ring = new Item[size];
        this._mask = size - 1;
        for (int i = 0; i < this._ring.length; ++i) {
            this._ring[i] = new Item();
        }
    }

    public final boolean isEmpty() {
        return this._head.get() == this._tail.get();
    }

    public final int getSize() {
        long head = this._head.get();
        long tail = this._tail.get();
        return (int)(head - tail);
    }

    public final long getHead() {
        return this._head.get();
    }

    public final long getHeadAlloc() {
        return this._headAlloc.get();
    }

    public final long getTail() {
        return this._tail.get();
    }

    public final long getTailAlloc() {
        return this._tailAlloc.get();
    }

    public final boolean offer(T value) {
        return this.offer(value, 0L);
    }

    public final boolean put(T value) {
        return this.offer(value, CurrentTime.getCurrentTime() + Integer.MAX_VALUE);
    }

    public final boolean offer(T value, long expireTime) {
        long headAlloc;
        long nextHeadAlloc;
        if (value == null) {
            throw new NullPointerException();
        }
        AtomicLong headRef = this._head;
        AtomicLong headAllocRef = this._headAlloc;
        AtomicLong tailRef = this._tail;
        int mask = this._mask;
        while (true) {
            long tail;
            if (((nextHeadAlloc = (headAlloc = headAllocRef.get()) + 1L) & (long)mask) == ((tail = tailRef.get()) & (long)mask)) {
                if (this.finishPoll()) continue;
                if (expireTime <= 0L) {
                    return false;
                }
                this.waitForAvailable(headAlloc, tail);
                continue;
            }
            if (headAllocRef.compareAndSet(headAlloc, nextHeadAlloc)) break;
        }
        Item<T> item = this.get(headAlloc);
        item.set(value);
        if (!headRef.compareAndSet(headAlloc, nextHeadAlloc)) {
            this.finishOffer(headAlloc);
        }
        this.wakeAvailable();
        return true;
    }

    private final boolean finishOffer() {
        long headAlloc;
        long head = this._head.get();
        if (head != (headAlloc = this._headAlloc.get()) && this.get(head).isSet()) {
            this.finishOffer(head);
            return true;
        }
        return false;
    }

    private void finishOffer(long index) {
        int retryMax;
        AtomicLong headRef = this._head;
        AtomicLong headAllocRef = this._headAlloc;
        int mask = this._mask;
        int retryCount = retryMax = (int)((index & 0xFL) + 1L << 4);
        int count = 4;
        while (retryCount-- >= 0) {
            long headAlloc;
            long head = headRef.get();
            if (head == (headAlloc = headAllocRef.get())) {
                return;
            }
            if (!this.get(head).isSet()) continue;
            long nextHead = head + 1L;
            if (headRef.compareAndSet(head, nextHead) && count-- <= 0) {
                return;
            }
            retryCount = retryMax;
        }
    }

    public final T peek() {
        long tail = this._tailAlloc.get();
        return this.getValue(tail);
    }

    public final T poll() {
        long nextTail;
        long tailAlloc;
        AtomicLong tailAllocRef = this._tailAlloc;
        AtomicLong tailRef = this._tail;
        AtomicLong headRef = this._head;
        do {
            tailAlloc = tailAllocRef.get();
            long head = headRef.get();
            if (head != tailAlloc || this.finishOffer()) continue;
            return null;
        } while (!tailAllocRef.compareAndSet(tailAlloc, nextTail = tailAlloc + 1L));
        Item<T> item = this.get(tailAlloc);
        T value = item.getAndClear();
        if (!tailRef.compareAndSet(tailAlloc, nextTail)) {
            this.completePoll(tailAlloc);
        }
        return value;
    }

    private final boolean finishPoll() {
        long headAlloc;
        long tail = this._tail.get();
        if (tail != (headAlloc = this._tailAlloc.get()) && !this.get(tail).isSet()) {
            this.completePoll(tail);
            return true;
        }
        return false;
    }

    private void completePoll(long index) {
        int retryMax;
        AtomicLong tailRef = this._tail;
        AtomicLong tailAllocRef = this._tailAlloc;
        int retryCount = retryMax = (int)((index & 0xFL) + 1L << 4);
        int count = 4;
        while (retryCount-- >= 0) {
            long tailAlloc;
            long tail = tailRef.get();
            if (tail == (tailAlloc = tailAllocRef.get())) {
                this.wakeAvailable();
                return;
            }
            if (this.get(tail).isSet()) continue;
            long nextTail = tail + 1L;
            if (tailRef.compareAndSet(tail, nextTail) && count-- <= 0) {
                this.wakeAvailable();
                return;
            }
            retryCount = retryMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAvailable(long headAlloc, long tail) {
        if (this._headAlloc.get() == headAlloc && this._tail.get() == tail) {
            AtomicBoolean atomicBoolean = this._isOfferWait;
            synchronized (atomicBoolean) {
                if (this._headAlloc.get() == headAlloc && this._tail.get() == tail) {
                    this._isOfferWait.set(true);
                    try {
                        this._isOfferWait.wait(100L);
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                }
            }
        }
    }

    private Item<T> get(long index) {
        return this._ring[(int)(index & (long)this._mask)];
    }

    public T getValue(long index) {
        return this.get(index).get();
    }

    public final long nextIndex(long index) {
        return index + 1L;
    }

    public long prevIndex(long index) {
        return index + (long)this._mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeAvailable() {
        if (this._isOfferWait.compareAndSet(true, false)) {
            AtomicBoolean atomicBoolean = this._isOfferWait;
            synchronized (atomicBoolean) {
                this._isOfferWait.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Item<T> {
        private volatile T _value;

        private Item() {
        }

        final boolean isSet() {
            return this._value != null;
        }

        final T get() {
            return this._value;
        }

        final T getAndClear() {
            T value = this._value;
            this._value = null;
            return value;
        }

        final void set(T value) {
            this._value = value;
        }

        final void clear() {
            this._value = null;
        }
    }
}

