/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;

@Module
public final class InetAddressUtil {
    public static int createIpAddress(byte[] address, char[] buffer) {
        if (InetAddressUtil.isIpv4(address)) {
            return InetAddressUtil.createIpv4Address(address, 0, buffer, 0);
        }
        int offset = 0;
        boolean isZeroCompress = false;
        boolean isInZeroCompress = false;
        buffer[offset++] = 91;
        for (int i = 0; i < 16; i += 2) {
            int value = (address[i] & 0xFF) * 256 + (address[i + 1] & 0xFF);
            if (value == 0 && i != 14) {
                if (isInZeroCompress) continue;
                if (!isZeroCompress) {
                    isZeroCompress = true;
                    isInZeroCompress = true;
                    continue;
                }
            }
            if (isInZeroCompress) {
                isInZeroCompress = false;
                buffer[offset++] = 58;
                buffer[offset++] = 58;
            } else if (i != 0) {
                buffer[offset++] = 58;
            }
            if (value == 0) {
                buffer[offset++] = 48;
                continue;
            }
            offset = InetAddressUtil.writeHexDigit(buffer, offset, value >> 12);
            offset = InetAddressUtil.writeHexDigit(buffer, offset, value >> 8);
            offset = InetAddressUtil.writeHexDigit(buffer, offset, value >> 4);
            offset = InetAddressUtil.writeHexDigit(buffer, offset, value);
        }
        buffer[offset++] = 93;
        return offset;
    }

    private static boolean isIpv4(byte[] buffer) {
        if (buffer[10] != -1 || buffer[11] != -1) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static int writeHexDigit(char[] buffer, int offset, int value) {
        if (value == 0) {
            return offset;
        }
        buffer[offset++] = (value &= 0xF) < 10 ? (char)(48 + value) : (char)(97 + value - 10);
        return offset;
    }

    private static int createIpv4Address(byte[] address, int addressOffset, char[] buffer, int bufferOffset) {
        int tailOffset = bufferOffset;
        for (int i = 12; i < 16; ++i) {
            if (i > 12) {
                buffer[tailOffset++] = 46;
            }
            int digit = address[addressOffset + i] & 0xFF;
            int d1 = digit / 100;
            int d2 = digit / 10 % 10;
            int d3 = digit % 10;
            if (digit >= 100) {
                buffer[tailOffset++] = (char)(48 + d1);
            }
            if (digit >= 10) {
                buffer[tailOffset++] = (char)(48 + d2);
            }
            buffer[tailOffset++] = (char)(48 + d3);
        }
        return tailOffset - bufferOffset;
    }
}

