/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.JniTroubleshoot;
import com.caucho.util.JniUtil;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

public class JniFileStream
extends StreamImpl
implements LockableStream {
    private static final JniTroubleshoot _jniTroubleshoot;
    private int _fd;
    private long _pos;
    private boolean _canRead;
    private boolean _canWrite;

    public JniFileStream(int fd, boolean canRead, boolean canWrite) {
        _jniTroubleshoot.checkIsValid();
        this.init(fd, canRead, canWrite);
    }

    void init(int fd, boolean canRead, boolean canWrite) {
        this._fd = fd;
        this._pos = 0L;
        this._canRead = canRead;
        this._canWrite = canWrite;
    }

    public static boolean isEnabled() {
        return _jniTroubleshoot.isEnabled();
    }

    public static Throwable getDisableCause() {
        return _jniTroubleshoot.getCause();
    }

    static int openFileDescriptorRead(byte[] name, int length) {
        return JniFileStream.nativeOpenRead(name, length);
    }

    static void closeFileDescriptor(int fd) throws IOException {
        JniFileStream.nativeClose(fd);
    }

    public static JniFileStream openRead(byte[] name, int length) {
        int fd = JniFileStream.nativeOpenRead(name, length);
        if (fd >= 0) {
            return new JniFileStream(fd, true, false);
        }
        return null;
    }

    public static JniFileStream openWrite(byte[] name, int length, boolean isAppend) {
        int fd = JniFileStream.nativeOpenWrite(name, length, isAppend);
        if (fd >= 0) {
            return new JniFileStream(fd, false, true);
        }
        return null;
    }

    public boolean canRead() {
        return this._canRead && this._fd >= 0;
    }

    public boolean hasSkip() {
        return this._fd >= 0;
    }

    public long skip(long length) throws IOException {
        long pos = this.nativeSkip(this._fd, length);
        if (pos < 0L) {
            return -1L;
        }
        this._pos = pos;
        return length;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this.nativeRead(this._fd, buf, offset, length);
        if (result > 0) {
            this._pos += (long)result;
        }
        return result;
    }

    public int getAvailable() throws IOException {
        if (this._fd < 0) {
            return -1;
        }
        if (this.getPath() instanceof FilesystemPath) {
            long length = this.getPath().getLength();
            return (int)(length - this._pos);
        }
        return this.nativeAvailable(this._fd);
    }

    public boolean canWrite() {
        return this._canWrite && this._fd >= 0;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.nativeWrite(this._fd, buf, offset, length);
    }

    public void seekStart(long offset) throws IOException {
        this.nativeSeekStart(this._fd, offset);
    }

    public void seekEnd(long offset) throws IOException {
        this.nativeSeekEnd(this._fd, offset);
    }

    public void flush() throws IOException {
    }

    public void flushToDisk() throws IOException {
        this.nativeFlushToDisk(this._fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int fd;
        JniFileStream jniFileStream = this;
        synchronized (jniFileStream) {
            fd = this._fd;
            this._fd = -1;
        }
        JniFileStream.nativeClose(fd);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    native int nativeRead(int var1, byte[] var2, int var3, int var4) throws IOException;

    native int nativeAvailable(int var1) throws IOException;

    private static native int nativeOpenRead(byte[] var0, int var1);

    private static native int nativeOpenWrite(byte[] var0, int var1, boolean var2);

    native int nativeWrite(int var1, byte[] var2, int var3, int var4) throws IOException;

    native long nativeSkip(int var1, long var2) throws IOException;

    native int nativeFlushToDisk(int var1) throws IOException;

    static native int nativeClose(int var0) throws IOException;

    native int nativeSeekStart(int var1, long var2) throws IOException;

    native int nativeSeekEnd(int var1, long var2) throws IOException;

    public boolean lock(boolean shared, boolean block) {
        if (shared && !this._canRead) {
            return false;
        }
        return shared || this._canWrite;
    }

    public boolean unlock() {
        return true;
    }

    public String toString() {
        return "JniFileStream[" + this.getPath().getNativePath() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        JniTroubleshoot jniTroubleshoot;
        block4: {
            jniTroubleshoot = null;
            Class<JniFileStream> cl = JniFileStream.class;
            JniUtil.acquire();
            try {
                try {
                    System.loadLibrary("resin_os");
                    jniTroubleshoot = new JniTroubleshoot(cl, "resin_os");
                }
                catch (Throwable e) {
                    jniTroubleshoot = new JniTroubleshoot(cl, "resin_os", e);
                    Object var4_3 = null;
                    JniUtil.release();
                    break block4;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                JniUtil.release();
                throw throwable;
            }
            JniUtil.release();
        }
        _jniTroubleshoot = jniTroubleshoot;
    }
}

